/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.spi;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.spi.ServiceDelegate;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.core.StubExt;
import org.jboss.ws.core.jaxws.client.ClientImpl;
import org.jboss.ws.core.jaxws.client.ClientProxy;
import org.jboss.ws.core.jaxws.client.DispatchImpl;
import org.jboss.ws.core.jaxws.client.ServiceObjectFactory;
import org.jboss.ws.core.jaxws.handler.HandlerResolverImpl;
import org.jboss.ws.integration.ResourceLoaderAdapter;
import org.jboss.ws.integration.UnifiedVirtualFile;
import org.jboss.ws.metadata.builder.jaxws.JAXWSClientMetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilder;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXWS;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDelegateImpl
extends ServiceDelegate {
    private final Logger log = Logger.getLogger(ServiceDelegateImpl.class);
    private static ExecutorService defaultExecutor = Executors.newCachedThreadPool();
    private ServiceMetaData serviceMetaData;
    private UnifiedServiceRefMetaData usRef;
    private HandlerResolver handlerResolver;
    private ExecutorService executor;
    private List<QName> annotatedPorts = new ArrayList<QName>();

    public ServiceDelegateImpl(URL wsdlURL, QName serviceName, Class serviceClass) {
        UnifiedVirtualFile vfsRoot;
        this.usRef = ServiceObjectFactory.getServiceRefAssociation();
        if (this.usRef != null) {
            vfsRoot = this.usRef.getVfsRoot();
            if (wsdlURL != null && serviceClass != Service.class) {
                try {
                    InputStream is = wsdlURL.openStream();
                    is.close();
                }
                catch (IOException e) {
                    this.log.warn("Cannot access wsdlURL: " + wsdlURL);
                    wsdlURL = null;
                }
            }
        } else {
            vfsRoot = new ResourceLoaderAdapter();
        }
        if (wsdlURL != null) {
            JAXWSClientMetaDataBuilder builder = new JAXWSClientMetaDataBuilder();
            this.serviceMetaData = builder.buildMetaData(serviceName, wsdlURL, vfsRoot);
        } else {
            UnifiedMetaData wsMetaData = new UnifiedMetaData(vfsRoot);
            this.serviceMetaData = new ServiceMetaData(wsMetaData, serviceName);
            wsMetaData.addService(this.serviceMetaData);
        }
        this.handlerResolver = new HandlerResolverImpl();
        if (this.usRef != null) {
            this.serviceMetaData.setServiceRefName(this.usRef.getServiceRefName());
            if (this.usRef.getHandlerChain() != null) {
                String filename = this.usRef.getHandlerChain();
                UnifiedHandlerChainsMetaData handlerChainsMetaData = JAXWSMetaDataBuilder.getHandlerChainsMetaData(serviceClass, filename);
                for (UnifiedHandlerChainMetaData UnifiedHandlerChainMetaData2 : handlerChainsMetaData.getHandlerChains()) {
                    for (UnifiedHandlerMetaData uhmd : UnifiedHandlerChainMetaData2.getHandlers()) {
                        HandlerMetaDataJAXWS handler = uhmd.getHandlerMetaDataJAXWS(HandlerMetaData.HandlerType.ENDPOINT);
                        this.serviceMetaData.addHandler(handler);
                    }
                }
                ((HandlerResolverImpl)this.handlerResolver).initServiceHandlerChain(this.serviceMetaData);
            }
        }
    }

    @Override
    public <T> T getPort(QName portName, Class<T> seiClass) {
        this.assertSEIConstraints(seiClass);
        if (this.serviceMetaData == null) {
            throw new WebServiceException("Service meta data not available");
        }
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null) {
            this.log.warn("Cannot get port meta data for: " + portName);
            if (!seiClass.isAnnotationPresent(WebService.class)) {
                throw new IllegalArgumentException("Cannot find @WebService on: " + seiClass.getName());
            }
            QName portType = this.getPortTypeName(seiClass);
            epMetaData = new ClientEndpointMetaData(this.serviceMetaData, portName, portType, EndpointMetaData.Type.JAXWS);
        }
        String seiClassName = seiClass.getName();
        epMetaData.setServiceEndpointInterfaceName(seiClassName);
        return this.getPortInternal(epMetaData, seiClass);
    }

    private <T> QName getPortTypeName(Class<T> seiClass) {
        String nsURI;
        WebService anWebService = seiClass.getAnnotation(WebService.class);
        String localPart = anWebService.name();
        if (localPart.length() == 0) {
            localPart = WSDLUtils.getJustClassName(seiClass);
        }
        if ((nsURI = anWebService.targetNamespace()).length() == 0) {
            nsURI = WSDLUtils.getTypeNamespace(seiClass);
        }
        QName portType = new QName(nsURI, localPart);
        return portType;
    }

    @Override
    public <T> T getPort(Class<T> seiClass) {
        this.assertSEIConstraints(seiClass);
        if (this.serviceMetaData == null) {
            throw new WebServiceException("Service meta data not available");
        }
        String seiClassName = seiClass.getName();
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpointByServiceEndpointInterface(seiClassName);
        if (epMetaData == null && this.serviceMetaData.getEndpoints().size() == 1) {
            epMetaData = this.serviceMetaData.getEndpoints().get(0);
            epMetaData.setServiceEndpointInterfaceName(seiClassName);
        } else {
            WebService ws = seiClass.getAnnotation(WebService.class);
            String ns = ws.targetNamespace();
            String name = ws.name();
            QName portTypeName = new QName(ns, name);
            for (EndpointMetaData epmd : this.serviceMetaData.getEndpoints()) {
                QName interfaceQName = epmd.getPortTypeName();
                if (!interfaceQName.getLocalPart().equals(portTypeName.getLocalPart())) continue;
                epmd.setServiceEndpointInterfaceName(seiClass.getName());
                epMetaData = epmd;
                break;
            }
        }
        if (epMetaData == null) {
            throw new WebServiceException("Cannot get port meta data for: " + seiClassName);
        }
        return this.getPortInternal(epMetaData, seiClass);
    }

    private <T> T getPortInternal(EndpointMetaData epMetaData, Class<T> seiClass) {
        QName portName = epMetaData.getPortName();
        if (!this.annotatedPorts.contains(portName)) {
            JAXWSClientMetaDataBuilder metaDataBuilder = new JAXWSClientMetaDataBuilder();
            metaDataBuilder.rebuildEndpointMetaData(epMetaData, seiClass);
            this.annotatedPorts.add(portName);
        }
        return this.createProxy(seiClass, epMetaData);
    }

    private void assertSEIConstraints(Class seiClass) {
        if (seiClass == null) {
            throw new IllegalArgumentException("Service endpoint interface cannot be null");
        }
        if (!seiClass.isAnnotationPresent(WebService.class)) {
            throw new WebServiceException("SEI is missing @WebService annotation: " + seiClass);
        }
    }

    @Override
    public void addPort(QName portName, String bindingId, String epAddress) {
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null) {
            epMetaData = new ClientEndpointMetaData(this.serviceMetaData, portName, null, EndpointMetaData.Type.JAXWS);
            this.serviceMetaData.addEndpoint(epMetaData);
        }
        epMetaData.setBindingId(bindingId);
        epMetaData.setEndpointAddress(epAddress);
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode) {
        ExecutorService executor = (ExecutorService)this.getExecutor();
        EndpointMetaData epMetaData = this.getEndpointMetaData(portName);
        DispatchImpl<T> dispatch = new DispatchImpl<T>(executor, epMetaData, type, mode);
        return dispatch;
    }

    @Override
    public Dispatch<Object> createDispatch(QName portName, JAXBContext jbc, Service.Mode mode) {
        ExecutorService executor = (ExecutorService)this.getExecutor();
        EndpointMetaData epMetaData = this.getEndpointMetaData(portName);
        DispatchImpl<Object> dispatch = new DispatchImpl<Object>(executor, epMetaData, jbc, mode);
        return dispatch;
    }

    private EndpointMetaData getEndpointMetaData(QName portName) {
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null) {
            throw new WebServiceException("Cannot find port: " + portName);
        }
        return epMetaData;
    }

    @Override
    public QName getServiceName() {
        return this.serviceMetaData.getServiceName();
    }

    @Override
    public Iterator<QName> getPorts() {
        ArrayList<QName> portNames = new ArrayList<QName>();
        for (EndpointMetaData epMetaData : this.serviceMetaData.getEndpoints()) {
            portNames.add(epMetaData.getPortName());
        }
        return portNames.iterator();
    }

    @Override
    public URL getWSDLDocumentLocation() {
        return this.serviceMetaData.getWsdlLocation();
    }

    @Override
    public HandlerResolver getHandlerResolver() {
        return this.handlerResolver;
    }

    @Override
    public void setHandlerResolver(HandlerResolver handlerResolver) {
        this.handlerResolver = handlerResolver;
    }

    @Override
    public Executor getExecutor() {
        if (this.executor == null) {
            this.executor = defaultExecutor;
        }
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        if (!(executor instanceof ExecutorService)) {
            throw new IllegalArgumentException("Supported executors must implement " + ExecutorService.class.getName());
        }
        this.executor = (ExecutorService)executor;
    }

    private <T> T createProxy(Class<T> seiClass, EndpointMetaData epMetaData) throws WebServiceException {
        try {
            ExecutorService executor = (ExecutorService)this.getExecutor();
            ClientProxy handler = new ClientProxy(executor, new ClientImpl(epMetaData, this.handlerResolver));
            ClassLoader cl = epMetaData.getClassLoader();
            Object proxy = Proxy.newProxyInstance(cl, new Class[]{seiClass, BindingProvider.class, StubExt.class}, (InvocationHandler)handler);
            this.configureStub((StubExt)proxy);
            return (T)proxy;
        }
        catch (WebServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebServiceException("Cannot create proxy", ex);
        }
    }

    private void configureStub(StubExt stub) {
        EndpointMetaData epMetaData = stub.getEndpointMetaData();
        String seiName = epMetaData.getServiceEndpointInterfaceName();
        QName portName = epMetaData.getPortName();
        if (this.usRef == null) {
            this.log.debug("No port configuration for: " + portName);
            return;
        }
        String configFile = this.usRef.getConfigFile();
        String configName = this.usRef.getConfigName();
        UnifiedPortComponentRefMetaData pcref = this.usRef.getPortComponentRef(seiName, portName);
        if (pcref != null) {
            if (pcref.getConfigFile() != null) {
                configFile = pcref.getConfigFile();
            }
            if (pcref.getConfigName() != null) {
                configName = pcref.getConfigName();
            }
            BindingProvider bp = (BindingProvider)((Object)stub);
            Map<String, Object> reqCtx = bp.getRequestContext();
            for (UnifiedStubPropertyMetaData prop : pcref.getStubProperties()) {
                this.log.debug("Set stub property: " + prop);
                reqCtx.put(prop.getPropName(), prop.getPropValue());
            }
        }
        if (configName != null || configFile != null) {
            this.log.debug("Configure Stub: [configName=" + configName + ",configFile=" + configFile + "]");
            stub.setConfigName(configName, configFile);
        }
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
        throw new NotImplementedException();
    }

    @Override
    public <T> Dispatch<T> createDispatch(EndpointReference endpointReference, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
        throw new NotImplementedException();
    }

    @Override
    public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        throw new NotImplementedException();
    }

    @Override
    public Dispatch<Object> createDispatch(EndpointReference endpointReference, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        throw new NotImplementedException();
    }

    @Override
    public <T> T getPort(QName portName, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        throw new NotImplementedException();
    }

    @Override
    public <T> T getPort(EndpointReference endpointReference, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        throw new NotImplementedException();
    }

    @Override
    public <T> T getPort(Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        throw new NotImplementedException();
    }
}

