/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.spi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServicePermission;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.core.jaxws.binding.BindingProviderImpl;
import org.jboss.ws.core.server.HttpContext;
import org.jboss.ws.core.server.HttpServer;
import org.jboss.ws.core.server.ServiceEndpointManagerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointImpl
extends Endpoint {
    private final Logger log = Logger.getLogger(EndpointImpl.class);
    private static final WebServicePermission ENDPOINT_PUBLISH_PERMISSION = new WebServicePermission("publishEndpoint");
    private Object implementor;
    private Executor executor;
    private List<Source> metadata;
    private BindingProvider bindingProvider;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private HttpContext serverContext;
    private boolean isPublished;
    private boolean isDestroyed;

    public EndpointImpl(String bindingId, Object implementor) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("new EndpointImpl(bindingId=" + bindingId + ",implementor=" + implementor + ")");
        }
        if (implementor == null) {
            throw new IllegalArgumentException("Implementor cannot be null");
        }
        this.implementor = implementor;
        this.bindingProvider = new BindingProviderImpl(bindingId);
    }

    @Override
    public Binding getBinding() {
        return this.bindingProvider.getBinding();
    }

    @Override
    public Object getImplementor() {
        return this.implementor;
    }

    @Override
    public void publish(String address) {
        URI addrURI;
        if (this.log.isDebugEnabled()) {
            this.log.debug("publish: " + address);
        }
        try {
            addrURI = new URI(address);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid address: " + address);
        }
        this.checkPublishEndpointPermission();
        HttpServer httpServer = HttpServer.create();
        httpServer.setProperties(this.properties);
        httpServer.start();
        String path = addrURI.getPath();
        String contextRoot = "/" + new StringTokenizer(path, "/").nextToken();
        HttpContext context = httpServer.createContext(contextRoot);
        this.publish(context);
    }

    @Override
    public void publish(Object context) {
        boolean isStandalone;
        if (this.log.isDebugEnabled()) {
            this.log.debug("publish: " + context);
        }
        if (this.isDestroyed) {
            throw new IllegalStateException("Endpoint already destroyed");
        }
        this.checkPublishEndpointPermission();
        try {
            ServiceEndpointManagerFactory factory = ServiceEndpointManagerFactory.getInstance();
            factory.getServiceEndpointManager();
            isStandalone = false;
        }
        catch (Exception ex) {
            isStandalone = true;
        }
        if (!isStandalone) {
            throw new IllegalStateException("Cannot publish endpoint from within server");
        }
        if (context instanceof HttpContext) {
            this.serverContext = (HttpContext)context;
            HttpServer httpServer = this.serverContext.getHttpServer();
            httpServer.publish(this.serverContext, this);
            this.isPublished = true;
        }
    }

    @Override
    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("stop");
        }
        if (this.serverContext == null || !this.isPublished) {
            this.log.error("Endpoint not published");
        }
        try {
            if (this.serverContext != null) {
                HttpServer httpServer = this.serverContext.getHttpServer();
                httpServer.destroy(this.serverContext, this);
            }
        }
        catch (Exception ex) {
            this.log.error("Cannot stop endpoint", ex);
        }
        this.isPublished = false;
        this.isDestroyed = true;
    }

    @Override
    public boolean isPublished() {
        return this.isPublished;
    }

    @Override
    public List<Source> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(List<Source> list2) {
        this.log.info("Ignore metadata, not implemented");
        this.metadata = list2;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.log.info("Ignore executor, not implemented");
        this.executor = executor;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Object> map) {
        this.properties = map;
    }

    private void checkPublishEndpointPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ENDPOINT_PUBLISH_PERMISSION);
        }
    }

    @Override
    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        throw new NotImplementedException();
    }

    @Override
    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        throw new NotImplementedException();
    }
}

