/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.binding;

import java.io.IOException;
import java.io.OutputStream;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.invocation.OnewayInvocation;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.ws.core.HTTPMessageImpl;
import org.jboss.ws.core.utils.DOMWriter;
import org.w3c.dom.Element;

public class HTTPMessageMarshaller
implements Marshaller {
    private static Logger log = Logger.getLogger(HTTPMessageMarshaller.class);

    public void write(Object dataObject, OutputStream output) throws IOException {
        if (dataObject instanceof InvocationRequest) {
            dataObject = ((InvocationRequest)dataObject).getParameter();
        }
        if (dataObject instanceof OnewayInvocation) {
            dataObject = ((OnewayInvocation)dataObject).getParameters()[0];
        }
        if (!(dataObject instanceof HTTPMessageImpl)) {
            throw new IllegalArgumentException("Not a HTTPMessage: " + dataObject);
        }
        HTTPMessageImpl httpMessage = (HTTPMessageImpl)dataObject;
        Element root = httpMessage.getXmlFragment().toElement();
        if (log.isTraceEnabled()) {
            log.trace("Outgoing Message\n" + DOMWriter.printNode(root, true));
        }
        new DOMWriter(output).print(root);
    }

    public Marshaller cloneMarshaller() throws CloneNotSupportedException {
        return new HTTPMessageMarshaller();
    }
}

