/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.ws.core.jaxrpc.TypeMappingImpl;
import org.jboss.ws.core.jaxrpc.binding.BindingException;
import org.jboss.ws.core.jaxrpc.binding.ComplexTypeDeserializer;
import org.jboss.ws.core.jaxrpc.binding.SerializationContext;
import org.jboss.ws.core.jaxws.JAXBContextCache;
import org.jboss.ws.extensions.xop.jaxws.AttachmentUnmarshallerImpl;

public class JAXBDeserializer
extends ComplexTypeDeserializer {
    private static final Logger log = Logger.getLogger(JAXBDeserializer.class);

    public Object deserialize(QName xmlName, QName xmlType, Source xmlFragment, SerializationContext serContext) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
        }
        Object value = null;
        try {
            Class[] javaTypes = (Class[])serContext.getProperty("org.jboss.ws.jaxrpc.binding.contextTypes");
            TypeMappingImpl typeMapping = serContext.getTypeMapping();
            Class javaType = typeMapping.getJavaType(xmlType);
            JAXBContextCache contextCache = JAXBContextCache.getContextCache();
            JAXBContext jaxbContext = contextCache.getInstance(javaTypes);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)new AttachmentUnmarshallerImpl());
            JAXBElement jbe = unmarshaller.unmarshal(xmlFragment, javaType);
            value = jbe.getValue();
            if (log.isDebugEnabled()) {
                log.debug("deserialized: " + (value != null ? value.getClass().getName() : null));
            }
        }
        catch (Exception ex) {
            this.handleUnmarshallException(ex);
        }
        return value;
    }

    private JAXBContext getJAXBContext(Class[] types) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])types);
        return jaxbContext;
    }

    private void handleUnmarshallException(Exception ex) {
        if (ex instanceof WebServiceException) {
            throw (WebServiceException)ex;
        }
        throw new WebServiceException(ex);
    }
}

