/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.TypeMappingImpl;
import org.jboss.ws.core.jaxrpc.binding.BindingException;
import org.jboss.ws.core.jaxrpc.binding.BufferedStreamResult;
import org.jboss.ws.core.jaxrpc.binding.NullValueSerializer;
import org.jboss.ws.core.jaxrpc.binding.SerializationContext;
import org.jboss.ws.core.jaxrpc.binding.SerializerFactoryBase;
import org.jboss.ws.core.jaxrpc.binding.SerializerSupport;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.XMLFragment;
import org.jboss.ws.core.utils.JavaUtils;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.w3c.dom.NamedNodeMap;

public class SOAPArraySerializer
extends SerializerSupport {
    private static final Logger log = Logger.getLogger(SOAPArraySerializer.class);
    private ParameterMetaData paramMetaData;
    private SerializerSupport compSerializer;
    private NullValueSerializer nullSerializer = new NullValueSerializer();
    private boolean isArrayComponentType;
    private StringBuilder buffer;

    public Result serialize(SOAPContentElement soapElement, SerializationContext serContext) throws BindingException {
        this.paramMetaData = soapElement.getParamMetaData();
        QName xmlName = soapElement.getElementQName();
        QName xmlType = soapElement.getXmlType();
        Object value = soapElement.getObjectValue();
        NamedNodeMap attributes = soapElement.getAttributes();
        return this.serialize(xmlName, xmlType, value, serContext, attributes);
    }

    public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException {
        log.debug("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + ",valueType=" + value.getClass().getName() + "]");
        try {
            if (this.paramMetaData == null) {
                throw new IllegalStateException("Use serialize(SOAPContenentElement, SerializationContext)");
            }
            QName compXmlName = this.paramMetaData.getXmlName();
            QName compXmlType = this.paramMetaData.getSOAPArrayCompType();
            Class javaType = this.paramMetaData.getJavaType();
            Class<?> compJavaType = javaType.getComponentType();
            boolean bl = this.isArrayComponentType = this.isArrayJavaType(compJavaType) && this.isArrayXmlType(compXmlType);
            while (compJavaType.getComponentType() != null && !this.isArrayComponentType) {
                this.isArrayComponentType = this.isArrayJavaType(compJavaType = compJavaType.getComponentType()) && this.isArrayXmlType(compXmlType);
            }
            TypeMappingImpl typeMapping = serContext.getTypeMapping();
            if (compXmlType == null) {
                compXmlType = typeMapping.getXMLType(compJavaType);
                this.paramMetaData.setSOAPArrayCompType(compXmlType);
            }
            if (compXmlType == null) {
                throw new WSException("Cannot obtain component xmlType for: " + compJavaType);
            }
            log.debug("Get component serializer for: [javaType=" + compJavaType.getName() + ",xmlType=" + compXmlType + "]");
            SerializerFactoryBase compSerializerFactory = (SerializerFactoryBase)typeMapping.getSerializer(compJavaType, compXmlType);
            if (compSerializerFactory == null) {
                log.warn("Cannot obtain component serializer for: [javaType=" + compJavaType.getName() + ",xmlType=" + compXmlType + "]");
                compSerializerFactory = (SerializerFactoryBase)typeMapping.getSerializer(null, compXmlType);
            }
            if (compSerializerFactory == null) {
                throw new WSException("Cannot obtain component serializer for: " + compXmlType);
            }
            this.compSerializer = compSerializerFactory.getSerializer();
            if (JavaUtils.isPrimitive(value.getClass())) {
                value = JavaUtils.getWrapperValueArray(value);
            }
            String nodeName = new NameImpl(compXmlName).getQualifiedName();
            this.buffer = new StringBuilder("<" + nodeName + " xmlns:" + "soap11-enc" + "='" + "http://schemas.xmlsoap.org/soap/encoding/" + "' ");
            if (!(value instanceof Object[])) {
                throw new WSException("Unsupported array type: " + javaType);
            }
            Object[] objArr = (Object[])value;
            String arrayDim = "" + objArr.length;
            Object[] subArr = (Object[])value;
            while (!this.isArrayComponentType && subArr.length > 0 && subArr[0] instanceof Object[]) {
                subArr = (Object[])subArr[0];
                arrayDim = arrayDim + "," + subArr.length;
            }
            compXmlType = serContext.getNamespaceRegistry().registerQName(compXmlType);
            compXmlName = serContext.getNamespaceRegistry().registerQName(compXmlName);
            String arrayType = "soap11-enc:arrayType='" + compXmlType.getPrefix() + ":" + compXmlType.getLocalPart() + "[" + arrayDim + "]'";
            this.buffer.append(arrayType);
            this.buffer.append(" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'");
            if (!compXmlType.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                this.buffer.append(" xmlns:" + compXmlType.getPrefix() + "='" + compXmlType.getNamespaceURI() + "'");
            }
            if (compXmlName.getNamespaceURI().length() > 0 && !compXmlName.getNamespaceURI().equals(compXmlType.getNamespaceURI())) {
                this.buffer.append(" xmlns:" + compXmlName.getPrefix() + "='" + compXmlName.getNamespaceURI() + "'");
            }
            this.buffer.append(">");
            this.serializeArrayComponents(compXmlName, compXmlType, serContext, objArr);
            this.buffer.append("</" + nodeName + ">");
            String xmlFragment = this.buffer.toString();
            log.debug("serialized: " + xmlFragment);
            return new BufferedStreamResult(xmlFragment);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    private void serializeArrayComponents(QName xmlName, QName xmlType, SerializationContext serContext, Object[] objArr) throws BindingException {
        for (Object compValue : objArr) {
            if (!this.isArrayComponentType && compValue instanceof Object[]) {
                this.serializeArrayComponents(xmlName, xmlType, serContext, (Object[])compValue);
                continue;
            }
            SerializerSupport ser = this.compSerializer;
            if (compValue == null) {
                ser = this.nullSerializer;
            }
            Result result = ser.serialize(new QName("item"), xmlType, compValue, serContext, null);
            this.buffer.append(new XMLFragment(result).toXMLString());
        }
    }

    private boolean isArrayXmlType(QName xmlType) {
        boolean isArrayType = Constants.TYPE_SOAP11_BASE64.equals(xmlType);
        isArrayType = isArrayType || Constants.TYPE_SOAP11_BASE64.equals(xmlType);
        isArrayType = isArrayType || Constants.TYPE_SOAP11_BASE64BINARY.equals(xmlType);
        isArrayType = isArrayType || Constants.TYPE_SOAP11_HEXBINARY.equals(xmlType);
        isArrayType = isArrayType || Constants.TYPE_SOAP11_NMTOKENS.equals(xmlType);
        isArrayType = isArrayType || Constants.TYPE_LITERAL_BASE64BINARY.equals(xmlType);
        isArrayType = isArrayType || Constants.TYPE_LITERAL_HEXBINARY.equals(xmlType);
        isArrayType = isArrayType || Constants.TYPE_LITERAL_NMTOKENS.equals(xmlType);
        return isArrayType;
    }

    private boolean isArrayJavaType(Class javaType) {
        boolean isBinaryType = String[].class.equals((Object)javaType) || Byte[].class.equals((Object)javaType) || byte[].class.equals((Object)javaType);
        return isBinaryType;
    }
}

