/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import java.util.Calendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.core.jaxrpc.binding.BindingException;
import org.jboss.ws.core.jaxrpc.binding.DeserializerSupport;
import org.jboss.ws.core.jaxrpc.binding.SerializationContext;
import org.jboss.xb.binding.SimpleTypeBindings;

public class CalendarDeserializer
extends DeserializerSupport {
    private static final Logger log = Logger.getLogger(CalendarDeserializer.class);

    public Object deserialize(QName xmlName, QName xmlType, Source xmlFragment, SerializationContext serContext) throws BindingException {
        return this.deserialize(xmlName, xmlType, CalendarDeserializer.sourceToString(xmlFragment), serContext);
    }

    private Object deserialize(QName xmlName, QName xmlType, String xmlFragment, SerializationContext serContext) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
        }
        Calendar value = null;
        String valueStr = this.unwrapValueStr(xmlFragment);
        if (valueStr != null) {
            if (Constants.TYPE_LITERAL_DATE.equals(xmlType)) {
                value = SimpleTypeBindings.unmarshalDate(valueStr);
            } else if (Constants.TYPE_LITERAL_TIME.equals(xmlType)) {
                value = SimpleTypeBindings.unmarshalTime(valueStr);
            } else if (Constants.TYPE_LITERAL_DATETIME.equals(xmlType)) {
                value = SimpleTypeBindings.unmarshalDateTime(valueStr);
            } else {
                throw new IllegalArgumentException("Invalid xmlType: " + xmlType);
            }
        }
        return value;
    }
}

