/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.ws.addressing.EndpointReference;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.MessageTrace;
import org.jboss.ws.core.WSTimeoutException;
import org.jboss.ws.core.client.EndpointInfo;
import org.jboss.ws.core.client.RemotingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemotingConnectionImpl
implements RemotingConnection {
    private static Logger log = Logger.getLogger(RemotingConnectionImpl.class);
    private Map<String, Object> clientConfig = new HashMap<String, Object>();
    private static Map<String, String> metadataMap = new HashMap<String, String>();
    private static Map<String, String> configMap;
    private boolean closed;

    public RemotingConnectionImpl() {
        this.clientConfig.put("enableLease", false);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    @Override
    public MessageAbstraction invoke(MessageAbstraction reqMessage, Object endpoint, boolean oneway) throws IOException {
        String targetAddress;
        if (endpoint == null) {
            throw new IllegalArgumentException("Given endpoint cannot be null");
        }
        if (this.closed) {
            throw new IOException("Connection is already closed");
        }
        Object timeout = null;
        Map<Object, Object> callProps = new HashMap();
        if (endpoint instanceof EndpointInfo) {
            EndpointInfo epInfo = (EndpointInfo)endpoint;
            targetAddress = epInfo.getTargetAddress();
            callProps = epInfo.getProperties();
            if (callProps.containsKey("org.jboss.ws.timeout")) {
                timeout = callProps.get("org.jboss.ws.timeout");
                targetAddress = this.addURLParameter(targetAddress, "timeout", timeout.toString());
            }
        } else if (endpoint instanceof EndpointReference) {
            EndpointReference epr = (EndpointReference)endpoint;
            targetAddress = epr.getAddress().toString();
        } else {
            targetAddress = endpoint.toString();
        }
        Map<String, Object> metadata = this.createRemotingMetaData(reqMessage, callProps);
        Client client = this.createRemotingClient(endpoint, targetAddress, oneway);
        try {
            if (log.isDebugEnabled()) {
                log.debug("Remoting metadata: " + metadata);
            }
            MessageTrace.traceMessage("Outgoing Request Message", reqMessage);
            MessageAbstraction resMessage = null;
            if (oneway) {
                client.invokeOneway(reqMessage, metadata, false);
            } else {
                resMessage = (MessageAbstraction)client.invoke(reqMessage, metadata);
            }
            client.disconnect();
            callProps.clear();
            callProps.putAll(metadata);
            MessageTrace.traceMessage("Incoming Response Message", resMessage);
            return resMessage;
        }
        catch (Throwable th) {
            if (timeout != null && th.getCause() instanceof SocketTimeoutException) {
                throw new WSTimeoutException("Timeout after: " + timeout + "ms", new Long(timeout.toString()));
            }
            IOException io = new IOException("Could not transmit message");
            io.initCause(th);
            throw io;
        }
    }

    private String addURLParameter(String url, String key, String value) {
        int qmIndex = url.indexOf("?");
        url = url + (qmIndex < 0 ? "?" : "&") + key + "=" + value;
        return url;
    }

    private Client createRemotingClient(Object endpoint, String targetAddress, boolean oneway) {
        Client client;
        try {
            log.debug("Get locator for: " + endpoint);
            targetAddress = this.addURLParameter(targetAddress, "datatype", "JBossWSMessage");
            InvokerLocator locator = new InvokerLocator(targetAddress);
            Marshaller marshaller = this.getMarshaller();
            UnMarshaller unmarshaller = this.getUnmarshaller();
            MarshalFactory.addMarshaller("JBossWSMessage", marshaller, unmarshaller);
            client = new Client(locator, "jbossws", this.clientConfig);
            client.connect();
            client.setMarshaller(marshaller);
            if (!oneway) {
                client.setUnMarshaller(unmarshaller);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed endpoint address", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not setup remoting client", e);
        }
        return client;
    }

    protected abstract UnMarshaller getUnmarshaller();

    protected abstract Marshaller getMarshaller();

    private Map<String, Object> createRemotingMetaData(MessageAbstraction reqMessage, Map callProps) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("NoThrowOnError", "true");
        if (reqMessage != null) {
            this.populateHeaders(reqMessage, metadata);
        } else {
            metadata.put("TYPE", "GET");
        }
        if (callProps != null) {
            Iterator it = callProps.entrySet().iterator();
            String authType = (String)callProps.get("org.jboss.ws.authType");
            if (authType == null) {
                authType = "org.jboss.ws.authType.basic";
            }
            while (it.hasNext()) {
                String remotingKey;
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (metadataMap.containsKey(key)) {
                    remotingKey = metadataMap.get(key);
                    if ("http.basic.username".equals(remotingKey) || "http.basic.password".equals(remotingKey)) {
                        if (authType.equals("org.jboss.ws.authType.basic")) {
                            metadata.put(remotingKey, val);
                        } else {
                            log.warn("Ignore '" + key + "' with auth typy: " + authType);
                        }
                    } else {
                        metadata.put(remotingKey, val);
                    }
                }
                if (!configMap.containsKey(key)) continue;
                remotingKey = configMap.get(key);
                this.clientConfig.put(remotingKey, val);
            }
        }
        return metadata;
    }

    protected void populateHeaders(MessageAbstraction reqMessage, Map<String, Object> metadata) {
        MimeHeaders mimeHeaders = reqMessage.getMimeHeaders();
        Properties props = new Properties();
        metadata.put("HEADER", props);
        Iterator i = mimeHeaders.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader header = (MimeHeader)i.next();
            String currentValue = props.getProperty(header.getName());
            if (currentValue != null) {
                props.put(header.getName(), currentValue + "," + header.getValue());
                continue;
            }
            props.put(header.getName(), header.getValue());
        }
    }

    static {
        metadataMap.put("javax.xml.rpc.security.auth.username", "http.basic.username");
        metadataMap.put("javax.xml.rpc.security.auth.password", "http.basic.password");
        metadataMap.put("javax.xml.ws.security.auth.username", "http.basic.username");
        metadataMap.put("javax.xml.ws.security.auth.password", "http.basic.password");
        configMap = new HashMap<String, String>();
        configMap.put("org.jboss.ws.keyStore", "org.jboss.remoting.keyStore");
        configMap.put("org.jboss.ws.keyStorePassword", "org.jboss.remoting.keyStorePassword");
        configMap.put("org.jboss.ws.keyStoreType", "org.jboss.remoting.keyStoreType");
        configMap.put("org.jboss.ws.trustStore", "org.jboss.remoting.trustStore");
        configMap.put("org.jboss.ws.trustStorePassword", "org.jboss.remoting.trustStorePassword");
        configMap.put("org.jboss.ws.trustStoreType", "org.jboss.remoting.trustStoreType");
    }
}

