/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.tm.TransactionManagerLocator;
import org.jboss.util.NestedRuntimeException;

public class TransactionDemarcationSupport {
    private static final TransactionManagerLocator locator = TransactionManagerLocator.getInstance();

    public static Transaction suspendAnyTransaction() {
        TransactionManager tm = locator.locate();
        try {
            return tm.suspend();
        }
        catch (SystemException e) {
            throw new NestedRuntimeException("Unable to suspend transaction", e);
        }
    }

    public static void resumeAnyTransaction(Transaction tx) {
        if (tx == null) {
            return;
        }
        TransactionManager tm = locator.locate();
        try {
            tm.resume(tx);
        }
        catch (InvalidTransactionException e) {
            throw new NestedRuntimeException("Unable to resume an invalid transaction", e);
        }
        catch (SystemException e) {
            throw new NestedRuntimeException("Unable to suspend transaction", e);
        }
    }
}

