/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.jboss.deployers.plugins.structure.AbstractDeploymentContext;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.AttachmentsSerializer;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.util.file.Files;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableDeploymentRepository
implements DeploymentRepository {
    private static final Logger log = Logger.getLogger(SerializableDeploymentRepository.class);
    private File root;
    private File bootstrapDir;
    private File libDir;
    private File deployersDir;
    private File applicationDir;
    private File adminEditsRoot;
    private ProfileKey key;
    private LinkedHashMap<String, DeploymentContext> bootstrapCtxs = new LinkedHashMap();
    private LinkedHashMap<String, DeploymentContext> deployerCtxs = new LinkedHashMap();
    private LinkedHashMap<String, DeploymentContext> applicationCtxs = new LinkedHashMap();
    private AttachmentsSerializer serializer;

    public SerializableDeploymentRepository(File root, ProfileKey key) {
        this.root = root;
        this.key = key;
    }

    public AttachmentsSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(AttachmentsSerializer serializer) {
        this.serializer = serializer;
    }

    public boolean exists() {
        File profileRoot = new File(this.root, this.key.getName());
        return profileRoot.exists();
    }

    @Override
    public URI getDeploymentURI(Profile.DeploymentPhase phase) {
        URI uri = null;
        switch (phase) {
            case BOOTSTRAP: {
                uri = this.getBootstrapURI();
                break;
            }
            case DEPLOYER: {
                uri = this.getDeployersURI();
                break;
            }
            case APPLICATION: {
                uri = this.getApplicationURI();
            }
        }
        return uri;
    }

    @Override
    public void setDeploymentURI(URI uri, Profile.DeploymentPhase phase) {
        switch (phase) {
            case BOOTSTRAP: {
                this.setBootstrapURI(uri);
                break;
            }
            case DEPLOYER: {
                this.setDeployersURI(uri);
                break;
            }
            case APPLICATION: {
                this.setApplicationURI(uri);
            }
        }
    }

    @Override
    public Set<String> getDeploymentNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.bootstrapCtxs.keySet());
        names.addAll(this.deployerCtxs.keySet());
        names.addAll(this.applicationCtxs.keySet());
        return names;
    }

    @Override
    public Set<String> getDeploymentNames(Profile.DeploymentPhase phase) {
        HashSet<String> names = new HashSet<String>();
        switch (phase) {
            case BOOTSTRAP: {
                names.addAll(this.bootstrapCtxs.keySet());
                break;
            }
            case DEPLOYER: {
                names.addAll(this.deployerCtxs.keySet());
                break;
            }
            case APPLICATION: {
                names.addAll(this.applicationCtxs.keySet());
            }
        }
        return names;
    }

    @Override
    public Set<String> getDeploymentNamesForType(String type) {
        HashSet<String> names = new HashSet<String>();
        for (DeploymentContext ctx : this.bootstrapCtxs.values()) {
            if (!ctx.getTypes().contains(type)) continue;
            names.add(ctx.getName());
        }
        for (DeploymentContext ctx : this.deployerCtxs.values()) {
            if (!ctx.getTypes().contains(type)) continue;
            names.add(ctx.getName());
        }
        for (DeploymentContext ctx : this.applicationCtxs.values()) {
            if (!ctx.getTypes().contains(type)) continue;
            names.add(ctx.getName());
        }
        return names;
    }

    @Override
    public void addDeploymentContent(String name, ZipInputStream contentIS, Profile.DeploymentPhase phase) throws IOException {
    }

    @Override
    public void addDeployment(String vfsPath, DeploymentContext d, Profile.DeploymentPhase phase) throws Exception {
        switch (phase) {
            case BOOTSTRAP: {
                this.addBootstrap(vfsPath, d);
                break;
            }
            case DEPLOYER: {
                this.addDeployer(vfsPath, d);
                break;
            }
            case APPLICATION: {
                this.addApplication(vfsPath, d);
            }
        }
    }

    @Override
    public void updateDeployment(String vfsPath, DeploymentContext d, Profile.DeploymentPhase phase) throws Exception {
    }

    @Override
    public DeploymentContext getDeployment(String name, Profile.DeploymentPhase phase) throws Exception, NoSuchDeploymentException {
        DeploymentContext ctx = null;
        if (phase == null) {
            try {
                ctx = this.getBootstrap(name);
            }
            catch (NoSuchDeploymentException ignore) {
                // empty catch block
            }
            try {
                if (ctx == null) {
                    ctx = this.getDeployer(name);
                }
            }
            catch (NoSuchDeploymentException ignore) {
                // empty catch block
            }
            try {
                if (ctx == null) {
                    ctx = this.getApplication(name);
                }
            }
            catch (NoSuchDeploymentException ignore) {}
        } else {
            switch (phase) {
                case BOOTSTRAP: {
                    ctx = this.getBootstrap(name);
                    break;
                }
                case DEPLOYER: {
                    ctx = this.getDeployer(name);
                    break;
                }
                case APPLICATION: {
                    ctx = this.getApplication(name);
                }
            }
        }
        if (ctx == null) {
            throw new NoSuchDeploymentException("name=" + name + ", phase=" + (Object)((Object)phase));
        }
        return ctx;
    }

    @Override
    public Collection<DeploymentContext> getDeployments() {
        HashSet<DeploymentContext> deployments = new HashSet<DeploymentContext>();
        deployments.addAll(this.bootstrapCtxs.values());
        deployments.addAll(this.deployerCtxs.values());
        deployments.addAll(this.applicationCtxs.values());
        return Collections.unmodifiableCollection(deployments);
    }

    @Override
    public synchronized Collection<ModificationInfo> getModifiedDeployments() throws Exception {
        ArrayList<ModificationInfo> modified = new ArrayList<ModificationInfo>();
        Collection<DeploymentContext> apps = this.getApplications();
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Checking applications for modifications");
        }
        if (apps != null) {
            Iterator<DeploymentContext> iter = apps.iterator();
            while (iter.hasNext()) {
                DeploymentContext ctx = iter.next();
                VirtualFile root = ctx.getRoot();
                Long rootLastModified = root.getLastModified();
                String name = root.getPathName();
                if (!root.exists()) {
                    ModificationInfo info = new ModificationInfo(ctx, rootLastModified, ModificationInfo.ModifyStatus.REMOVED);
                    modified.add(info);
                    iter.remove();
                    if (!trace) continue;
                    log.trace(name + " was removed");
                    continue;
                }
                if (!root.hasBeenModified()) continue;
                if (trace) {
                    log.trace(name + " was modified: " + rootLastModified);
                }
                DeploymentContext ctx2 = this.loadDeploymentData(root);
                ModificationInfo info = new ModificationInfo(ctx2, rootLastModified, ModificationInfo.ModifyStatus.MODIFIED);
                modified.add(info);
            }
            VFS deployVFS = VFS.getVFS(this.applicationDir.toURI());
            VirtualFile deployDir = deployVFS.getRoot();
            List<VirtualFile> children = deployDir.getChildren();
            for (VirtualFile vf : children) {
                if (this.applicationCtxs.containsKey(vf.getPathName())) continue;
                DeploymentContext ctx = this.loadDeploymentData(vf);
                ModificationInfo info = new ModificationInfo(ctx, vf.getLastModified(), ModificationInfo.ModifyStatus.ADDED);
                modified.add(info);
                this.applicationCtxs.put(vf.getPathName(), ctx);
            }
        }
        return modified;
    }

    @Override
    public Collection<DeploymentContext> getDeployments(Profile.DeploymentPhase phase) throws Exception {
        Collection<DeploymentContext> ctxs = null;
        switch (phase) {
            case BOOTSTRAP: {
                ctxs = this.getBootstraps();
                break;
            }
            case DEPLOYER: {
                ctxs = this.getDeployers();
                break;
            }
            case APPLICATION: {
                ctxs = this.getApplications();
            }
        }
        return ctxs;
    }

    @Override
    public DeploymentContext removeDeployment(String name, Profile.DeploymentPhase phase) throws Exception {
        DeploymentContext ctx = null;
        switch (phase) {
            case BOOTSTRAP: {
                ctx = this.removeBootstrap(name);
                break;
            }
            case DEPLOYER: {
                ctx = this.removeDeployer(name);
                break;
            }
            case APPLICATION: {
                ctx = this.removeApplication(name);
            }
        }
        return ctx;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder(super.toString());
        tmp.append("(root=");
        tmp.append(this.root);
        tmp.append(", key=");
        tmp.append(this.key);
        tmp.append(")");
        return tmp.toString();
    }

    @Override
    public void create() throws Exception {
        File profileRoot = new File(this.root, this.key.getName());
        if (profileRoot.exists()) {
            throw new IOException("Profile root already exists: " + profileRoot);
        }
        if (!profileRoot.mkdirs()) {
            throw new IOException("Failed to create profile root: " + profileRoot);
        }
        this.bootstrapDir = new File(profileRoot, "bootstrap");
        if (!this.bootstrapDir.mkdirs()) {
            throw new IOException("Failed to create profile bootstrap dir: " + this.bootstrapDir);
        }
        this.deployersDir = new File(profileRoot, "deployers");
        if (!this.deployersDir.mkdirs()) {
            throw new IOException("Failed to create profile deployers dir: " + this.deployersDir);
        }
        this.applicationDir = new File(profileRoot, "deploy");
        if (!this.applicationDir.mkdirs()) {
            throw new IOException("Failed to create profile deploy dir: " + this.applicationDir);
        }
        this.libDir = new File(profileRoot, "lib");
        if (!this.libDir.mkdirs()) {
            throw new IOException("Failed to create profile lib dir: " + this.libDir);
        }
        this.adminEditsRoot = new File(profileRoot, "profile/edits");
        if (!this.adminEditsRoot.mkdirs()) {
            throw new IOException("Failed to create profile adminEdits dir: " + this.adminEditsRoot);
        }
    }

    @Override
    public void load() throws Exception, NoSuchProfileException {
        if (this.serializer == null) {
            throw new IllegalStateException("serializer has not been set");
        }
        File profileRoot = new File(this.root, this.key.getName());
        if (!profileRoot.exists()) {
            throw new NoSuchProfileException("Profile root does not exists: " + profileRoot);
        }
        this.bootstrapDir = new File(profileRoot, "bootstrap");
        if (!this.bootstrapDir.exists()) {
            this.bootstrapDir = null;
        }
        this.deployersDir = new File(profileRoot, "deployers");
        if (!this.deployersDir.exists()) {
            throw new FileNotFoundException("Profile contains no deployers dir: " + this.deployersDir);
        }
        this.applicationDir = new File(profileRoot, "deploy");
        if (!this.applicationDir.exists()) {
            throw new FileNotFoundException("Profile contains no deploy dir: " + this.applicationDir);
        }
        this.adminEditsRoot = new File(profileRoot, "profile/edits");
        if (this.bootstrapDir != null) {
            VFS bootstrapVFS = VFS.getVFS(this.bootstrapDir.toURI());
            this.loadBootstraps(bootstrapVFS.getRoot());
        } else {
            this.loadBootstraps(null);
        }
        VFS deployersVFS = VFS.getVFS(this.deployersDir.toURI());
        this.loadDeployers(deployersVFS.getRoot());
        VFS deployVFS = VFS.getVFS(this.applicationDir.toURI());
        this.loadApplications(deployVFS.getRoot());
    }

    @Override
    public void remove() throws IOException, NoSuchProfileException {
        File profileRoot = new File(this.root, this.key.getName());
        Files.delete(profileRoot);
    }

    protected void addBootstrap(String vfsPath, DeploymentContext ctx) throws Exception {
        this.bootstrapCtxs.put(vfsPath, ctx);
    }

    @Override
    public void addManagedObject(String vfsPath, Attachments edits) throws IOException {
        Map map = edits.getAttachments();
        File attachments = new File(this.adminEditsRoot, vfsPath + ".edits");
        FileOutputStream fos = new FileOutputStream(attachments);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(map);
        oos.close();
        fos.close();
    }

    protected void addDeployer(String vfsPath, DeploymentContext ctx) throws Exception {
        this.deployerCtxs.put(vfsPath, ctx);
    }

    protected void addApplication(String vfsPath, DeploymentContext ctx) throws Exception {
        this.applicationCtxs.put(vfsPath, ctx);
    }

    protected DeploymentContext getBootstrap(String vfsPath) throws Exception {
        DeploymentContext ctx = this.bootstrapCtxs.get(vfsPath);
        if (ctx == null) {
            throw new NoSuchDeploymentException(vfsPath);
        }
        return ctx;
    }

    protected Collection<DeploymentContext> getBootstraps() throws Exception {
        Collection<DeploymentContext> ctxs = this.bootstrapCtxs.values();
        return ctxs;
    }

    protected URI getBootstrapURI() {
        return this.bootstrapDir.toURI();
    }

    protected URI getDeployersURI() {
        return this.deployersDir.toURI();
    }

    protected URI getApplicationURI() {
        return this.applicationDir.toURI();
    }

    protected DeploymentContext getDeployer(String vfsPath) throws Exception {
        DeploymentContext ctx = this.deployerCtxs.get(vfsPath);
        if (ctx == null) {
            throw new NoSuchDeploymentException(vfsPath);
        }
        return ctx;
    }

    protected Collection<DeploymentContext> getDeployers() throws Exception {
        Collection<DeploymentContext> ctxs = this.deployerCtxs.values();
        return ctxs;
    }

    protected DeploymentContext getApplication(String vfsPath) throws Exception {
        DeploymentContext ctx = this.applicationCtxs.get(vfsPath);
        if (ctx == null) {
            throw new NoSuchDeploymentException(vfsPath);
        }
        return ctx;
    }

    protected Collection<DeploymentContext> getApplications() throws Exception {
        Collection<DeploymentContext> ctxs = this.applicationCtxs.values();
        return ctxs;
    }

    protected DeploymentContext removeBootstrap(String vfsPath) throws IOException {
        File bootstrapFile = new File(this.bootstrapDir, vfsPath);
        if (!bootstrapFile.delete()) {
            throw new IOException("Failed to delete: " + bootstrapFile);
        }
        return (DeploymentContext)this.bootstrapCtxs.remove(vfsPath);
    }

    protected DeploymentContext removeDeployer(String vfsPath) throws IOException {
        File deployerFile = new File(this.deployersDir, vfsPath);
        if (!Files.delete(deployerFile)) {
            throw new IOException("Failed to delete: " + deployerFile);
        }
        return this.removeDeployer(vfsPath);
    }

    protected DeploymentContext removeApplication(String vfsPath) throws IOException {
        File deploymentFile = new File(this.applicationDir, vfsPath);
        if (!Files.delete(deploymentFile)) {
            throw new IOException("Failed to delete: " + deploymentFile);
        }
        return (DeploymentContext)this.applicationCtxs.remove(vfsPath);
    }

    protected void setBootstrapURI(URI uri) {
        this.bootstrapDir = new File(uri);
    }

    protected void setDeployersURI(URI uri) {
        this.deployersDir = new File(uri);
    }

    protected void setApplicationURI(URI uri) {
        this.applicationDir = new File(uri);
    }

    private void loadBootstraps(VirtualFile bootstrapDir) throws IOException {
        if (bootstrapDir != null) {
            List<VirtualFile> children = bootstrapDir.getChildren();
            for (VirtualFile vf : children) {
                DeploymentContext vfCtx = this.loadDeploymentData(vf);
                this.bootstrapCtxs.put(vf.getPathName(), vfCtx);
            }
        } else {
            File profileRoot = new File(this.root, this.key.getName());
            File confDir = new File(profileRoot, "conf");
            VirtualFile confVF = VFS.getRoot(confDir.toURI());
            VirtualFile jbossServiceVF = confVF.findChild("jboss-service.xml");
            DeploymentContext vfCtx = this.loadDeploymentData(jbossServiceVF);
            this.bootstrapCtxs.put(jbossServiceVF.getPathName(), vfCtx);
        }
    }

    private void loadDeployers(VirtualFile deployersDir) throws IOException {
        List<VirtualFile> children = deployersDir.getChildren();
        for (VirtualFile vf : children) {
            DeploymentContext vfCtx = this.loadDeploymentData(vf);
            this.deployerCtxs.put(vf.getPathName(), vfCtx);
        }
    }

    private void loadApplications(VirtualFile applicationDir) throws IOException {
        List<VirtualFile> children = applicationDir.getChildren();
        for (VirtualFile vf : children) {
            DeploymentContext vfCtx = this.loadDeploymentData(vf);
            this.applicationCtxs.put(vf.getPathName(), vfCtx);
        }
    }

    private DeploymentContext loadDeploymentData(VirtualFile file) {
        AbstractDeploymentContext deployment = new AbstractDeploymentContext(file);
        log.debug("Created deployment: " + deployment + ", tmo=" + deployment.getTransientManagedObjects());
        return deployment;
    }
}

