/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profile.basic;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.plugins.structure.AbstractDeploymentContext;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.util.JBossObject;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileImpl
extends JBossObject
implements Profile {
    private String name;
    private File profileRoot;
    private LinkedHashMap<String, DeploymentContext> bootstraps = new LinkedHashMap();
    private LinkedHashMap<String, DeploymentContext> applications = new LinkedHashMap();
    private LinkedHashMap<String, DeploymentContext> deployers = new LinkedHashMap();
    private volatile boolean hotdeployEnabled;

    public ProfileImpl(String profileRoot, String name) {
        this.name = name;
        this.profileRoot = new File(profileRoot);
        this.log.info("Using profile root:" + this.profileRoot.getAbsolutePath());
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public Set<String> getDeploymentNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.bootstraps.keySet());
        names.addAll(this.deployers.keySet());
        names.addAll(this.applications.keySet());
        return names;
    }

    @Override
    public VirtualFile getRootFile(Profile.DeploymentPhase phase) throws Exception {
        VirtualFile root = VFS.getRoot(this.profileRoot.toURI());
        switch (phase) {
            case BOOTSTRAP: {
                root = root.findChild("conf");
                break;
            }
            case DEPLOYER: {
                root = root.findChild("deployers");
                break;
            }
            case APPLICATION: {
                root = root.findChild("deploy");
            }
        }
        return root;
    }

    @Override
    public void addDeployment(DeploymentContext d, Profile.DeploymentPhase phase) throws Exception {
        switch (phase) {
            case BOOTSTRAP: {
                this.addBootstrap(d);
                break;
            }
            case DEPLOYER: {
                this.addDeployer(d);
                break;
            }
            case APPLICATION: {
                this.addApplication(d);
            }
        }
    }

    @Override
    public void updateDeployment(DeploymentContext d, Profile.DeploymentPhase phase) throws Exception {
    }

    private DeploymentContext findDeployment(String name, Profile.DeploymentPhase phase) {
        DeploymentContext ctx = null;
        if (phase == null) {
            ctx = this.getBootstrap(name);
            if (ctx == null) {
                ctx = this.getDeployer(name);
            }
            if (ctx == null) {
                ctx = this.getApplication(name);
            }
        } else {
            switch (phase) {
                case BOOTSTRAP: {
                    ctx = this.getBootstrap(name);
                    break;
                }
                case DEPLOYER: {
                    ctx = this.getDeployer(name);
                    break;
                }
                case APPLICATION: {
                    ctx = this.getApplication(name);
                }
            }
        }
        return ctx;
    }

    @Override
    public DeploymentContext getDeployment(String name, Profile.DeploymentPhase phase) throws NoSuchDeploymentException {
        DeploymentContext ctx = this.findDeployment(name, phase);
        if (ctx == null) {
            throw new NoSuchDeploymentException("name=" + name + ", phase=" + (Object)((Object)phase));
        }
        return ctx;
    }

    @Override
    public boolean hasDeployment(String name, Profile.DeploymentPhase phase) {
        return this.findDeployment(name, phase) != null;
    }

    @Override
    public Set<String> getDeploymentNames(Profile.DeploymentPhase phase) {
        HashSet<String> names = new HashSet<String>();
        switch (phase) {
            case BOOTSTRAP: {
                names.addAll(this.bootstraps.keySet());
                break;
            }
            case DEPLOYER: {
                names.addAll(this.deployers.keySet());
                break;
            }
            case APPLICATION: {
                names.addAll(this.applications.keySet());
            }
        }
        return names;
    }

    @Override
    public Set<String> getDeploymentNamesForType(String type) {
        HashSet<String> names = new HashSet<String>();
        for (DeploymentContext ctx : this.bootstraps.values()) {
            if (!ctx.getTypes().contains(type)) continue;
            names.add(ctx.getName());
        }
        for (DeploymentContext ctx : this.deployers.values()) {
            if (!ctx.getTypes().contains(type)) continue;
            names.add(ctx.getName());
        }
        for (DeploymentContext ctx : this.applications.values()) {
            if (!ctx.getTypes().contains(type)) continue;
            names.add(ctx.getName());
        }
        return names;
    }

    @Override
    public Collection<DeploymentContext> getDeployments() {
        HashSet<DeploymentContext> deployments = new HashSet<DeploymentContext>();
        deployments.addAll(this.bootstraps.values());
        deployments.addAll(this.deployers.values());
        deployments.addAll(this.applications.values());
        return Collections.unmodifiableCollection(deployments);
    }

    @Override
    public Collection<ModificationInfo> getModifiedDeployments() throws Exception {
        if (!this.hotdeployEnabled) {
            return Collections.emptyList();
        }
        ArrayList<ModificationInfo> modified = new ArrayList<ModificationInfo>();
        Collection<DeploymentContext> apps = this.applications.values();
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace("Checking applications for modifications");
        }
        VirtualFile applicationDir = null;
        if (apps != null) {
            Iterator<DeploymentContext> iter = apps.iterator();
            while (iter.hasNext()) {
                DeploymentContext ctx = iter.next();
                VirtualFile root = ctx.getRoot();
                VirtualFile parent = root.getParent();
                if (applicationDir == null || parent.getPathName().compareTo(applicationDir.getPathName()) < 0) {
                    applicationDir = parent;
                }
                Long rootLastModified = root.getLastModified();
                String name = root.getPathName();
                if (!root.exists()) {
                    ModificationInfo info = new ModificationInfo(ctx, rootLastModified, ModificationInfo.ModifyStatus.REMOVED);
                    modified.add(info);
                    iter.remove();
                    if (!trace) continue;
                    this.log.trace(name + " was removed");
                    continue;
                }
                if (!root.hasBeenModified()) continue;
                if (trace) {
                    this.log.trace(name + " was modified: " + rootLastModified);
                }
                AbstractDeploymentContext ctx2 = new AbstractDeploymentContext(root);
                ModificationInfo info = new ModificationInfo((DeploymentContext)ctx2, rootLastModified, ModificationInfo.ModifyStatus.MODIFIED);
                modified.add(info);
            }
            if (applicationDir == null) {
                applicationDir = this.getRootFile(Profile.DeploymentPhase.APPLICATION);
            }
            ArrayList<VirtualFile> added = new ArrayList<VirtualFile>();
            this.addDeployments(added, applicationDir);
            for (VirtualFile vf : added) {
                AbstractDeploymentContext ctx = new AbstractDeploymentContext(vf);
                ModificationInfo info = new ModificationInfo((DeploymentContext)ctx, vf.getLastModified(), ModificationInfo.ModifyStatus.ADDED);
                modified.add(info);
                this.applications.put(ctx.getName(), (DeploymentContext)ctx);
            }
        }
        return modified;
    }

    @Override
    public void enableModifiedDeploymentChecks(boolean flag) {
        this.hotdeployEnabled = flag;
    }

    @Override
    public Collection<DeploymentContext> getDeployments(Profile.DeploymentPhase phase) {
        Collection<DeploymentContext> ctxs = null;
        switch (phase) {
            case BOOTSTRAP: {
                ctxs = this.getBootstraps();
                break;
            }
            case DEPLOYER: {
                ctxs = this.getDeployers();
                break;
            }
            case APPLICATION: {
                ctxs = this.getApplications();
            }
        }
        return ctxs;
    }

    @Override
    public DeploymentContext removeDeployment(String name, Profile.DeploymentPhase phase) throws Exception {
        DeploymentContext ctx = null;
        switch (phase) {
            case BOOTSTRAP: {
                ctx = this.removeBootstrap(name);
                break;
            }
            case DEPLOYER: {
                ctx = this.removeDeployer(name);
                break;
            }
            case APPLICATION: {
                ctx = this.removeApplication(name);
            }
        }
        return ctx;
    }

    @Override
    public Map<String, Object> getConfig() {
        return null;
    }

    protected void addBootstrap(DeploymentContext d) {
        this.bootstraps.put(d.getName(), d);
    }

    protected DeploymentContext removeBootstrap(String name) {
        return (DeploymentContext)this.bootstraps.remove(name);
    }

    protected DeploymentContext getBootstrap(String name) {
        DeploymentContext deployment = this.bootstraps.get(name);
        return deployment;
    }

    protected Collection<DeploymentContext> getBootstraps() {
        return Collections.unmodifiableCollection(this.bootstraps.values());
    }

    protected void addDeployer(DeploymentContext d) {
        this.deployers.put(d.getName(), d);
    }

    protected DeploymentContext removeDeployer(String name) {
        return (DeploymentContext)this.deployers.remove(name);
    }

    protected DeploymentContext getDeployer(String name) {
        DeploymentContext deployment = this.deployers.get(name);
        return deployment;
    }

    protected Collection<DeploymentContext> getDeployers() {
        return Collections.unmodifiableCollection(this.deployers.values());
    }

    protected void addApplication(DeploymentContext d) {
        this.applications.put(d.getName(), d);
    }

    protected DeploymentContext removeApplication(String name) {
        return (DeploymentContext)this.applications.remove(name);
    }

    protected DeploymentContext getApplication(String name) {
        DeploymentContext deployment = this.applications.get(name);
        return deployment;
    }

    protected Collection<DeploymentContext> getApplications() {
        return Collections.unmodifiableCollection(this.applications.values());
    }

    private void addDeployments(List<VirtualFile> list2, VirtualFile root) throws Exception {
        List<VirtualFile> components = root.getChildren();
        for (VirtualFile component : components) {
            String key = component.toURI().toString();
            if (this.applications.containsKey(key)) continue;
            if (component.isLeaf()) {
                list2.add(component);
                continue;
            }
            if (component.getName().indexOf(46) == -1) {
                this.addDeployments(list2, component);
                continue;
            }
            list2.add(component);
        }
    }
}

