/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.providers.MappingProviderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentRolesMappingProvider
implements MappingProvider<Group> {
    private static Logger log = Logger.getLogger(DeploymentRolesMappingProvider.class);
    private boolean trace = log.isTraceEnabled();

    @Override
    public void init(Map options) {
    }

    @Override
    public void performMapping(Map map, Group mappedObject) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("Context Map is null or empty");
        }
        Principal principal = (Principal)map.get("Principal");
        Map principalRolesMap = (Map)map.get("deploymentPrincipalRolesMap");
        if (this.trace) {
            log.trace("Principal=" + principal + ":principalRolesMap=" + principalRolesMap);
        }
        if (principal == null || principalRolesMap == null || principalRolesMap.isEmpty()) {
            return;
        }
        Set roleset = (Set)principalRolesMap.get(principal.getName());
        if (roleset != null) {
            SimpleGroup newRoles = new SimpleGroup("Roles");
            for (String rolename : roleset) {
                newRoles.addMember(this.createNewPrincipal(mappedObject, rolename));
            }
            mappedObject = MappingProviderUtil.replacePrincipals(mappedObject, newRoles);
        }
    }

    private Principal createNewPrincipal(Group mappedObject, String name) {
        Principal origp;
        Principal p = new SimplePrincipal(name);
        if (mappedObject.members().hasMoreElements() && (p = MappingProviderUtil.instantiatePrincipal((origp = (Principal)mappedObject.members().nextElement()).getClass(), name)) == null) {
            p = new SimplePrincipal(name);
        }
        return p;
    }
}

