/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jacc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SubjectInfo;
import org.jboss.security.plugins.SecurityContextAssociation;
import org.jboss.security.plugins.SecurityContextFactory;

public class SubjectPolicyContextHandler
implements PolicyContextHandler {
    public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
    public static final HashSet EMPTY_SET = new HashSet();

    public Object getContext(String key, Object data) throws PolicyContextException {
        if (!key.equalsIgnoreCase(SUBJECT_CONTEXT_KEY)) {
            return null;
        }
        Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
        return subject;
    }

    public String[] getKeys() throws PolicyContextException {
        String[] keys = new String[]{SUBJECT_CONTEXT_KEY};
        return keys;
    }

    public boolean supports(String key) throws PolicyContextException {
        return key.equalsIgnoreCase(SUBJECT_CONTEXT_KEY);
    }

    private static class GetSubjectAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetSubjectAction();

        private GetSubjectAction() {
        }

        public Object run() {
            Subject theSubject = null;
            SecurityContext sc = SecurityContextAssociation.getSecurityContext();
            if (sc != null) {
                SubjectInfo si = sc.getSubjectInfo();
                SecurityContextUtil util = SecurityContextFactory.createUtil();
                if (si != null) {
                    Subject activeSubject = si.getAuthenticatedSubject();
                    RunAsIdentity callerRunAsIdentity = (RunAsIdentity)util.get(sc, "CallerRunAsIdentity");
                    if (activeSubject != null) {
                        Set principalsSet = null;
                        principalsSet = callerRunAsIdentity == null ? activeSubject.getPrincipals() : callerRunAsIdentity.getPrincipalsSet();
                        theSubject = new Subject(true, principalsSet, activeSubject.getPublicCredentials(), activeSubject.getPrivateCredentials());
                    } else if (callerRunAsIdentity != null) {
                        Set principalsSet = callerRunAsIdentity.getPrincipalsSet();
                        theSubject = new Subject(true, principalsSet, EMPTY_SET, EMPTY_SET);
                    }
                }
            }
            return theSubject;
        }
    }
}

