/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.metadata.repository;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.resource.spi.ActivationSpec;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.logging.Logger;
import org.jboss.resource.deployment.AdminObject;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.repository.DefaultJCAEntryFormatter;
import org.jboss.resource.metadata.repository.JCAConnectorMetaDataEntry;
import org.jboss.resource.metadata.repository.JCAConnectorMetaDataKey;
import org.jboss.resource.metadata.repository.JCADeploymentMetaDataEntry;
import org.jboss.resource.metadata.repository.JCADeploymentType;
import org.jboss.resource.metadata.repository.JCAMetaDataEntryFormatter;
import org.jboss.resource.metadata.repository.JCAMetaDataRepository;

@JMX(exposedInterface=JCAMetaDataRepository.class, name="jboss.jca:service=JCAMetaDataRepository,name=DefaultJCAMetaDataRepository")
public class DefaultJCAMetaDataRepository
implements JCAMetaDataRepository,
Serializable {
    private static final Logger log = Logger.getLogger(DefaultJCAMetaDataRepository.class);
    private static final long serialVersionUID = 244233303934974673L;
    private static final String DEFAULT_FORMATTER = DefaultJCAEntryFormatter.class.getName();
    private String formatterClassName;
    private JCAMetaDataEntryFormatter formatter;
    private Map<JCAConnectorMetaDataKey, JCAConnectorMetaDataEntry> connectors = new ConcurrentHashMap<JCAConnectorMetaDataKey, JCAConnectorMetaDataEntry>();

    public void setFormatterClassName(String formatterClassName) {
        if (formatterClassName != null) {
            if (this.formatterClassName != null && !this.formatterClassName.equals(formatterClassName)) {
                this.loadFormatter(formatterClassName);
                this.formatterClassName = this.formatter.getClass().getName();
            }
        } else {
            this.formatterClassName = "org.jboss.resource.metadata.repository.DefaultJCAEntryFormatter";
            this.loadFormatter(this.formatterClassName);
        }
    }

    public String getFormatterClassName() {
        return this.formatterClassName;
    }

    public void create() throws Exception {
        if (this.formatter == null && this.formatterClassName != null) {
            this.loadFormatter(this.formatterClassName);
        } else if (this.formatter == null && this.formatterClassName == null) {
            this.loadFormatter(DEFAULT_FORMATTER);
        }
    }

    public void addConnectorMetaData(String name, ConnectorMetaData cmd) {
        JCAConnectorMetaDataKey key = new JCAConnectorMetaDataKey(name);
        key.setName(name);
        JCAConnectorMetaDataEntry entry = this.connectors.get(key);
        if (entry != null) {
            entry.setConnectorMetaData(cmd);
        } else {
            entry = new JCAConnectorMetaDataEntry();
            entry.setConnectorMetaData(cmd);
            this.connectors.put(key, entry);
        }
    }

    public ConnectorMetaData getConnectorMetaData(String name) {
        JCAConnectorMetaDataKey entry = new JCAConnectorMetaDataKey(name);
        entry.setName(name);
        ConnectorMetaData md = this.getConnectorMetaData(entry);
        return md;
    }

    private ConnectorMetaData getConnectorMetaData(JCAConnectorMetaDataKey key) {
        JCAConnectorMetaDataEntry entry = this.connectors.get(key);
        return entry.getConnectorMetaData();
    }

    public void addActivationSpec(String rarName, ActivationSpec spec) {
        JCAConnectorMetaDataKey key = new JCAConnectorMetaDataKey(rarName);
        this.addDeployment(key, JCADeploymentType.ACTIVATION_SPEC, spec);
    }

    public void addAdminObject(String rarName, AdminObject adminObject) {
        JCAConnectorMetaDataKey key = new JCAConnectorMetaDataKey(rarName);
        this.addDeployment(key, JCADeploymentType.ADMIN_OBJECT, adminObject);
    }

    public void addManagedConnectionFactoryDeploymentGroup(ManagedConnectionFactoryDeploymentGroup group) {
        List<ManagedConnectionFactoryDeploymentMetaData> mcf = group.getDeployments();
        for (ManagedConnectionFactoryDeploymentMetaData deployment : mcf) {
            JCAConnectorMetaDataKey key = new JCAConnectorMetaDataKey(deployment.getRarName());
            this.addDeployment(key, JCADeploymentType.MCF, deployment);
        }
    }

    public Object listDeploymentsForConnector(String rarName) {
        String results = null;
        JCAConnectorMetaDataKey key = new JCAConnectorMetaDataKey(rarName);
        JCAConnectorMetaDataEntry entry = this.connectors.get(key);
        if (entry != null) {
            List<JCADeploymentMetaDataEntry> deployments = entry.getDeployments();
            results = (String)this.formatter.formatEntries(deployments);
        } else {
            results = "No entries for ConnectorMetaData " + rarName;
        }
        return results;
    }

    private void addDeployment(JCAConnectorMetaDataKey key, JCADeploymentType deploymentType, Object deployment) {
        JCAConnectorMetaDataEntry entry = this.connectors.get(key);
        if (entry == null) {
            entry = new JCAConnectorMetaDataEntry();
            entry.addDeployment(deploymentType, deployment);
            this.connectors.put(key, entry);
        } else {
            entry.addDeployment(deploymentType, deployment);
        }
    }

    public int getActivationSpecCount() {
        return this.getCount(JCADeploymentType.ACTIVATION_SPEC);
    }

    public int getAdminObjectCount() {
        return this.getCount(JCADeploymentType.ADMIN_OBJECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectorMetaDataCount() {
        int count = 0;
        Map<JCAConnectorMetaDataKey, JCAConnectorMetaDataEntry> map = this.connectors;
        synchronized (map) {
            for (JCAConnectorMetaDataEntry entry : this.connectors.values()) {
                if (entry.getConnectorMetaData() == null) continue;
                ++count;
            }
        }
        return count;
    }

    public int getManagedConnectionFactoryCount() {
        return this.getCount(JCADeploymentType.MCF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCount(JCADeploymentType deploymentType) {
        int count = 0;
        Map<JCAConnectorMetaDataKey, JCAConnectorMetaDataEntry> map = this.connectors;
        synchronized (map) {
            for (JCAConnectorMetaDataEntry entry : this.connectors.values()) {
                List<JCADeploymentMetaDataEntry> deployments = entry.getDeployments();
                for (JCADeploymentMetaDataEntry deployment : deployments) {
                    if (!deployment.getDeploymentType().equals((Object)deploymentType)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private void loadFormatter(String name) {
        if (name != null) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> clz = cl.loadClass(this.formatterClassName);
                this.formatter = (JCAMetaDataEntryFormatter)clz.newInstance();
                this.formatterClassName = name;
            }
            catch (Exception e) {
                log.trace("Could not formatter for classname " + this.formatterClassName + " using default.");
                this.formatter = new DefaultJCAEntryFormatter();
                this.formatterClassName = this.formatter.getClass().getName();
            }
        }
    }
}

