/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers.builder;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.resource.deployers.builder.AbstractBuilder;
import org.jboss.resource.metadata.mcf.DataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryTransactionSupportMetaData;
import org.jboss.system.metadata.ServiceAttributeMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFactoryBindingBuilder
extends AbstractBuilder {
    private static final String DATASOURCE = "org.jboss.resource.adapter.jdbc.remote.WrapperDataSourceService";
    private static final String CONNECTION_FACTORY = "org.jboss.resource.connectionmanager.ConnectionFactoryBindingService";
    private static final String DATASOURCE_JMX = "jboss.jca:service=DataSourceBinding,name=";
    private static final String CONNNECTION_FACTORY_JMX = "jboss.jca:service=ConnectionFactoryBinding,name=";

    @Override
    public List<ServiceAttributeMetaData> buildAttributes(ManagedConnectionFactoryDeploymentMetaData md) {
        ArrayList<ServiceAttributeMetaData> attributes = new ArrayList<ServiceAttributeMetaData>();
        ServiceAttributeMetaData attribute = new ServiceAttributeMetaData();
        attribute = this.buildSimpleAttribute("JndiName", md.getJndiName());
        attributes.add(attribute);
        attribute = this.buildSimpleAttribute("UseJavaContext", String.valueOf(md.isUseJavaContext()));
        attributes.add(attribute);
        if (!md.isUseJavaContext()) {
            attribute = this.buildDependencyAttribute("JMXInvokerName", md.getJmxInvokerName());
            attributes.add(attribute);
        }
        attribute = this.buildDependencyAttribute("ConnectionManager", this.buildCMName(md));
        attributes.add(attribute);
        return attributes;
    }

    @Override
    public ObjectName buildObjectName(ManagedConnectionFactoryDeploymentMetaData md) {
        ObjectName on = null;
        on = md instanceof DataSourceDeploymentMetaData ? ObjectNameFactory.create(DATASOURCE_JMX + md.getJndiName()) : ObjectNameFactory.create(CONNNECTION_FACTORY_JMX + md.getJndiName());
        return on;
    }

    @Override
    public String getCode(ManagedConnectionFactoryDeploymentMetaData md) {
        return md instanceof DataSourceDeploymentMetaData ? DATASOURCE : CONNECTION_FACTORY;
    }

    private String buildCMName(ManagedConnectionFactoryDeploymentMetaData md) {
        String cmType = "jboss.jca:service=";
        String jndiName = md.getJndiName();
        cmType = md.getTransactionSupportMetaData().equals((Object)ManagedConnectionFactoryTransactionSupportMetaData.NONE) ? cmType + "NoTxCM,name=" + jndiName : (md.getTransactionSupportMetaData().equals((Object)ManagedConnectionFactoryTransactionSupportMetaData.LOCAL) ? (md instanceof DataSourceDeploymentMetaData ? cmType + "LocalTxCM,name=" + jndiName : cmType + "TxCM,name=" + jndiName) : (md instanceof DataSourceDeploymentMetaData ? cmType + "XATxCM,name=" + jndiName : cmType + "TxCM,name=" + jndiName));
        return cmType;
    }
}

