/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.vendor;

import java.lang.reflect.Method;
import javax.management.ObjectName;
import javax.transaction.xa.XAException;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jdbc.vendor.OracleXAExceptionFormatterMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.XAExceptionFormatter;

public class OracleXAExceptionFormatter
extends ServiceMBeanSupport
implements XAExceptionFormatter,
OracleXAExceptionFormatterMBean {
    private static final String EXCEPTION_CLASS_NAME = "oracle.jdbc.xa.OracleXAException";
    private static final Object[] NOARGS = new Object[0];
    private ObjectName transactionManagerService;
    private Class oracleXAExceptionClass;
    private Method getXAError;
    private Method getXAErrorMessage;
    private Method getOracleError;
    private Method getOracleSQLError;

    public ObjectName getTransactionManagerService() {
        return this.transactionManagerService;
    }

    public void setTransactionManagerService(ObjectName transactionManagerService) {
        this.transactionManagerService = transactionManagerService;
    }

    protected void startService() throws Exception {
        this.oracleXAExceptionClass = Thread.currentThread().getContextClassLoader().loadClass(EXCEPTION_CLASS_NAME);
        this.getXAError = this.oracleXAExceptionClass.getMethod("getXAError", new Class[0]);
        this.getXAErrorMessage = this.oracleXAExceptionClass.getMethod("getXAErrorMessage", this.getXAError.getReturnType());
        this.getOracleError = this.oracleXAExceptionClass.getMethod("getOracleError", new Class[0]);
        this.getOracleSQLError = this.oracleXAExceptionClass.getMethod("getOracleSQLError", new Class[0]);
        this.getServer().invoke(this.transactionManagerService, "registerXAExceptionFormatter", new Object[]{this.oracleXAExceptionClass, this}, new String[]{Class.class.getName(), XAExceptionFormatter.class.getName()});
    }

    protected void stopService() throws Exception {
        this.getServer().invoke(this.transactionManagerService, "unregisterXAExceptionFormatter", new Object[]{this.oracleXAExceptionClass}, new String[]{Class.class.getName()});
        this.oracleXAExceptionClass = null;
        this.getXAError = null;
        this.getXAErrorMessage = null;
        this.getOracleError = null;
        this.getOracleSQLError = null;
    }

    public void formatXAException(XAException xae, Logger log) {
        try {
            log.warn("xa error: " + this.getXAError.invoke((Object)xae, NOARGS) + " (" + this.getXAErrorMessage.invoke((Object)xae, this.getXAError.invoke((Object)xae, NOARGS)) + "); " + "oracle error: " + this.getOracleError.invoke((Object)xae, NOARGS) + "; " + "oracle sql error: " + this.getOracleSQLError.invoke((Object)xae, NOARGS) + ";", xae);
        }
        catch (Exception e) {
            log.warn("Problem trying to format XAException: ", e);
        }
    }
}

