/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.loading;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.remoting.loading.ClassBytes;
import org.jboss.remoting.loading.ObjectInputStreamWithClassLoader;

public class ClassUtil {
    protected static final Logger log = Logger.getLogger(class$org$jboss$remoting$loading$ClassUtil == null ? (class$org$jboss$remoting$loading$ClassUtil = ClassUtil.class$("org.jboss.remoting.loading.ClassUtil")) : class$org$jboss$remoting$loading$ClassUtil);
    static /* synthetic */ Class class$org$jboss$remoting$loading$ClassUtil;
    static /* synthetic */ Class class$java$lang$Object;

    public static Object deserialize(ClassBytes cb, ClassLoader cl) throws IOException, ClassNotFoundException {
        if (cb.getClassBytes() == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(cb.getClassBytes());
        ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader(bis, cl);
        Object result = ois.readObject();
        bis = null;
        ois = null;
        return result;
    }

    public static Object deserialize(byte[] buf) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = (class$org$jboss$remoting$loading$ClassUtil == null ? (class$org$jboss$remoting$loading$ClassUtil = ClassUtil.class$("org.jboss.remoting.loading.ClassUtil")) : class$org$jboss$remoting$loading$ClassUtil).getClassLoader();
        }
        return ClassUtil.deserialize(buf, cl);
    }

    public static Object deserialize(byte[] buf, ClassLoader cl) throws IOException, ClassNotFoundException {
        if (buf == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader(bis, cl);
        Object result = ois.readObject();
        bis = null;
        ois = null;
        return result;
    }

    public static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.flush();
        bos.flush();
        byte[] buf = bos.toByteArray();
        bos = null;
        oos = null;
        return buf;
    }

    public static boolean isArrayClass(String className) {
        return className.startsWith("[L") && className.endsWith(";");
    }

    public static String getArrayClassPart(String className) {
        String cn = className;
        int i = className.indexOf("[L");
        if (i > -1) {
            cn = className.substring(i + 2, className.length() - 1);
        }
        return cn;
    }

    public static String getPackageName(Class cl) {
        String n = cl.getName();
        int i = n.lastIndexOf(".");
        return i > -1 ? n.substring(0, i) : n;
    }

    public static String getShortClassName(Class cl) {
        String n = cl.getName();
        int i = n.lastIndexOf(".");
        return i > -1 ? n.substring(i + 1) : n;
    }

    public static Class[] getInterfacesFor(Class clazz) {
        HashSet set = new HashSet();
        ClassUtil.addInterfaces(set, clazz);
        return set.toArray(new Class[set.size()]);
    }

    private static void addInterfaces(Set list2, Class clazz) {
        if (clazz != null && clazz != (class$java$lang$Object == null ? (class$java$lang$Object = ClassUtil.class$("java.lang.Object")) : class$java$lang$Object)) {
            Class<?>[] interfaces;
            if (clazz.isInterface() && !list2.contains(clazz)) {
                list2.add(clazz);
            }
            if ((interfaces = clazz.getInterfaces()) != null && interfaces.length > 0) {
                for (int c = 0; c < interfaces.length; ++c) {
                    Class<?> interfaceClass = interfaces[c];
                    if (!list2.contains(interfaceClass)) {
                        list2.add(interfaceClass);
                    }
                    ClassUtil.addInterfaces(list2, interfaceClass);
                }
            }
            ClassUtil.addInterfaces(list2, clazz.getSuperclass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] getClassBytes(String className, ClassLoader classbyteloader) {
        block16: {
            String cn = null;
            cn = ClassUtil.isArrayClass(className) ? ClassUtil.getArrayClassPart(className).replace('.', '/') + ".class" : className.replace('.', '/') + ".class";
            if (log.isTraceEnabled()) {
                log.trace("trying to load class: " + className + " from path: " + cn);
            }
            InputStream in = null;
            ClassLoader cl = classbyteloader;
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            if (cl != null && (in = cl.getResourceAsStream(cn)) != null) {
                byte[] byArray;
                block14: {
                    if (log.isTraceEnabled()) {
                        log.trace("looking for classes at: " + cl);
                    }
                    byte[] data = ClassUtil.read(in);
                    if (log.isTraceEnabled()) {
                        log.trace("found class at classloader: " + cl);
                    }
                    byArray = data;
                    Object var8_8 = null;
                    if (in == null) break block14;
                    try {
                        in.close();
                    }
                    catch (Exception ig) {
                        // empty catch block
                    }
                    in = null;
                }
                return byArray;
                catch (IOException io) {
                    try {
                        Object var8_9 = null;
                        if (in == null) break block16;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception ig) {
                                // empty catch block
                            }
                            in = null;
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (Exception ig) {
                        // empty catch block
                    }
                    in = null;
                    {
                    }
                }
            }
        }
        return null;
    }

    protected static byte[] read(InputStream in) throws IOException {
        int c;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((c = in.read(buf)) >= 0) {
            out.write(buf, 0, c);
        }
        return out.toByteArray();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

