/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.reflect.plugins.javassist.JavassistConstructor;
import org.jboss.reflect.plugins.javassist.JavassistField;
import org.jboss.reflect.plugins.javassist.JavassistMethod;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.UnreachableStatementException;

public class JavassistReflectionFactory {
    private static final SynchronizedInt counter = new SynchronizedInt(0);
    private final boolean check;

    public JavassistReflectionFactory(boolean check) {
        this.check = check;
    }

    public JavassistMethod createMethod(CtMethod ctMethod) throws Throwable {
        boolean needsCast;
        boolean isInstanceMethod;
        ClassPool pool = JavassistTypeInfoFactoryImpl.pool;
        final CtClass result = pool.makeClass(JavassistMethod.class.getName() + counter.increment());
        result.addInterface(pool.get(JavassistMethod.class.getName()));
        CtConstructor constructor = new CtConstructor(null, result);
        constructor.setBody("super();");
        result.addConstructor(constructor);
        CtClass object = pool.get(Object.class.getName());
        JBossStringBuilder buffer = new JBossStringBuilder();
        buffer.append("public Object invoke(Object target, Object[] args) throws Throwable {");
        boolean bl = isInstanceMethod = !Modifier.isStatic((int)ctMethod.getModifiers());
        if (this.check && isInstanceMethod) {
            buffer.append("if (target == null) throw new IllegalArgumentException(\"Null target for ");
            buffer.append(ctMethod.getName()).append(ctMethod.getSignature()).append("\");");
        }
        CtClass declaring = ctMethod.getDeclaringClass();
        boolean bl2 = needsCast = isInstanceMethod && !object.equals(declaring);
        if (this.check && needsCast) {
            buffer.append("if (target instanceof ").append(declaring.getName()).append(" == false) ");
            buffer.append("throw new IllegalArgumentException(\"Target \" + target + \"");
            buffer.append(" is not an instance of ").append(declaring.getName());
            buffer.append(" for ").append(ctMethod.getName()).append(ctMethod.getSignature()).append("\");");
        }
        CtClass[] params = ctMethod.getParameterTypes();
        if (this.check) {
            if (params.length != 0) {
                buffer.append("if (args == null || args.length != ").append(params.length).append(") ");
                buffer.append("throw new IllegalArgumentException(\"Expected ").append(params.length).append(" parameter(s)");
                buffer.append(" for ").append(ctMethod.getName()).append(ctMethod.getSignature()).append("\");");
            } else {
                buffer.append("if (args != null && args.length != 0)");
                buffer.append("throw new IllegalArgumentException(\"Expected no parameters");
                buffer.append(" for ").append(ctMethod.getName()).append(ctMethod.getSignature()).append("\");");
            }
            for (int i = 0; i < params.length; ++i) {
                if (object.equals(params[i])) continue;
                String paramType = this.getBoxedType(params[i]);
                if (params[i].isPrimitive()) {
                    buffer.append("if (args[").append(i).append("] == null) ");
                    buffer.append("throw new IllegalArgumentException(\"Parameter ").append(i);
                    buffer.append(" cannot be null for ").append(params[i].getName());
                    buffer.append(" for ").append(ctMethod.getName()).append(ctMethod.getSignature()).append("\");");
                }
                buffer.append("if (args[").append(i).append("] != null && ");
                buffer.append("args[").append(i).append("] instanceof ").append(paramType).append(" == false) ");
                buffer.append("throw new IllegalArgumentException(\"Parameter ").append(i).append(" \" + args[").append(i).append("] + \"");
                buffer.append(" is not an instance of ").append(paramType);
                buffer.append(" for ").append(ctMethod.getName()).append(ctMethod.getSignature()).append("\");");
            }
        }
        CtClass returnType = ctMethod.getReturnType();
        boolean isVoid = CtClass.voidType.equals(returnType);
        boolean isPrimitive = returnType.isPrimitive();
        if (!isVoid) {
            buffer.append("return ");
            if (isPrimitive) {
                buffer.append("new ").append(this.getBoxedType(returnType)).append('(');
            }
        }
        if (isInstanceMethod) {
            buffer.append('(');
            if (needsCast) {
                buffer.append("(").append(declaring.getName()).append(')');
            }
            buffer.append("target).");
        } else {
            buffer.append(declaring.getName()).append('.');
        }
        buffer.append(ctMethod.getName()).append('(');
        for (int i = 0; i < params.length; ++i) {
            buffer.append('(');
            if (!object.equals(params[i])) {
                buffer.append("(").append(this.getBoxedType(params[i])).append(')');
            }
            buffer.append("args[").append(i).append("])");
            if (params[i].isPrimitive()) {
                this.unbox(buffer, params[i]);
            }
            if (i >= params.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(')');
        if (!isVoid && isPrimitive) {
            buffer.append(')');
        }
        buffer.append(';');
        if (isVoid) {
            buffer.append("return null;");
        }
        buffer.append('}');
        String code = buffer.toString();
        try {
            CtMethod invoke = CtNewMethod.make((String)code, (CtClass)result);
            result.addMethod(invoke);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot compile " + code, e);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JavassistMethod>(){

                @Override
                public JavassistMethod run() throws Exception {
                    Class clazz = result.toClass();
                    return (JavassistMethod)clazz.newInstance();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    public JavassistConstructor createConstructor(CtConstructor ctConstructor) throws Throwable {
        int i;
        ClassPool pool = JavassistTypeInfoFactoryImpl.pool;
        final CtClass result = pool.makeClass(JavassistConstructor.class.getName() + counter.increment());
        try {
            CtClass magic = pool.get("sun.reflect.MagicAccessorImpl");
            result.setSuperclass(magic);
        }
        catch (NotFoundException ignored) {
            // empty catch block
        }
        result.addInterface(pool.get(JavassistConstructor.class.getName()));
        CtConstructor constructor = new CtConstructor(null, result);
        constructor.setBody("super();");
        result.addConstructor(constructor);
        CtClass object = pool.get(Object.class.getName());
        JBossStringBuilder buffer = new JBossStringBuilder();
        buffer.append("public Object newInstance(Object[] args) throws Throwable {");
        String declaring = ctConstructor.getDeclaringClass().getName();
        CtClass[] params = ctConstructor.getParameterTypes();
        if (this.check) {
            if (params.length != 0) {
                buffer.append("if (args == null || args.length != ").append(params.length).append(") ");
                buffer.append("throw new IllegalArgumentException(\"Expected ").append(params.length).append(" parameter(s)");
                buffer.append(" for ").append("new ").append(declaring).append(ctConstructor.getSignature()).append("\");");
            } else {
                buffer.append("if (args != null && args.length != 0)");
                buffer.append("throw new IllegalArgumentException(\"Expected no parameters");
                buffer.append(" for ").append("new ").append(declaring).append(ctConstructor.getSignature()).append("\");");
            }
            for (i = 0; i < params.length; ++i) {
                if (object.equals(params[i])) continue;
                String paramType = this.getBoxedType(params[i]);
                if (params[i].isPrimitive()) {
                    buffer.append("if (args[").append(i).append("] == null) ");
                    buffer.append("throw new IllegalArgumentException(\"Parameter ").append(i);
                    buffer.append(" cannot be null for ").append(params[i].getName());
                    buffer.append(" for ").append("new ").append(declaring).append(ctConstructor.getSignature()).append("\");");
                }
                buffer.append("if (args[").append(i).append("] != null && ");
                buffer.append("args[").append(i).append("] instanceof ").append(paramType).append(" == false) ");
                buffer.append("throw new IllegalArgumentException(\"Parameter ").append(i).append(" \" + args[").append(i).append("] + \"");
                buffer.append(" is not an instance of ").append(paramType);
                buffer.append(" for ").append("new ").append(declaring).append(ctConstructor.getSignature()).append("\");");
            }
        }
        buffer.append("return new ").append(declaring).append('(');
        for (i = 0; i < params.length; ++i) {
            buffer.append('(');
            if (!object.equals(params[i])) {
                buffer.append("(").append(this.getBoxedType(params[i])).append(')');
            }
            buffer.append("args[").append(i).append("])");
            if (params[i].isPrimitive()) {
                this.unbox(buffer, params[i]);
            }
            if (i >= params.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(");}");
        String code = buffer.toString();
        try {
            CtMethod newInstance = CtNewMethod.make((String)code, (CtClass)result);
            result.addMethod(newInstance);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot compile " + code, e);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JavassistConstructor>(){

                @Override
                public JavassistConstructor run() throws Exception {
                    Class clazz = result.toClass();
                    return (JavassistConstructor)clazz.newInstance();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    public JavassistField createField(CtField ctField) throws Throwable {
        boolean needsCast;
        boolean isInstanceField;
        ClassPool pool = JavassistTypeInfoFactoryImpl.pool;
        final CtClass result = pool.makeClass(JavassistField.class.getName() + counter.increment());
        try {
            CtClass magic = pool.get("sun.reflect.MagicAccessorImpl");
            result.setSuperclass(magic);
        }
        catch (NotFoundException ignored) {
            // empty catch block
        }
        result.addInterface(pool.get(JavassistField.class.getName()));
        CtConstructor constructor = new CtConstructor(null, result);
        constructor.setBody("super();");
        result.addConstructor(constructor);
        CtClass object = pool.get(Object.class.getName());
        JBossStringBuilder buffer = new JBossStringBuilder();
        buffer.append("public Object get(Object target) throws Throwable {");
        boolean bl = isInstanceField = !Modifier.isStatic((int)ctField.getModifiers());
        if (this.check && isInstanceField) {
            buffer.append("if (target == null) throw new IllegalArgumentException(\"Null target");
            buffer.append(" for ").append(ctField.getName()).append("\");");
        }
        CtClass declaring = ctField.getDeclaringClass();
        boolean bl2 = needsCast = isInstanceField && !object.equals(declaring);
        if (this.check && needsCast) {
            buffer.append("if (target instanceof ").append(declaring.getName()).append(" == false) ");
            buffer.append("throw new IllegalArgumentException(\"Target \" + target + \"");
            buffer.append(" is not an instance of ").append(declaring.getName());
            buffer.append(" for ").append(ctField.getName()).append("\");");
        }
        CtClass type = ctField.getType();
        boolean isPrimitive = type.isPrimitive();
        buffer.append("return ");
        if (isPrimitive) {
            buffer.append("new ").append(this.getBoxedType(type)).append('(');
        }
        if (isInstanceField) {
            buffer.append('(');
            if (needsCast) {
                buffer.append("(").append(declaring.getName()).append(')');
            }
            buffer.append("target).");
        } else {
            buffer.append(declaring.getName()).append('.');
        }
        buffer.append(ctField.getName());
        if (isPrimitive) {
            buffer.append(')');
        }
        buffer.append(";}");
        String code = buffer.toString();
        CtMethod get = CtNewMethod.make((String)code, (CtClass)result);
        try {
            result.addMethod(get);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot compile " + code, e);
        }
        buffer = new JBossStringBuilder();
        buffer.append("public void set(Object target, Object value) throws Throwable {");
        if (this.check && isInstanceField) {
            buffer.append("if (target == null) throw new IllegalArgumentException(\"Null target");
            buffer.append(" for ").append(ctField.getName()).append("\");");
        }
        if (this.check && needsCast) {
            buffer.append("if (target instanceof ").append(declaring.getName()).append(" == false) ");
            buffer.append("throw new IllegalArgumentException(\"Target \" + target + \"");
            buffer.append(" is not an instance of ").append(declaring.getName());
            buffer.append(" for ").append(ctField.getName()).append("\");");
        }
        if (this.check && !object.equals(type)) {
            String paramType = this.getBoxedType(type);
            if (type.isPrimitive()) {
                buffer.append("if (type == null) ");
                buffer.append("throw new IllegalArgumentException(\"Value ");
                buffer.append(" cannot be null for ").append(type.getName());
                buffer.append(" for ").append(ctField.getName()).append("\");");
            }
            buffer.append("if (value != null && ");
            buffer.append("value instanceof ").append(paramType).append(" == false) ");
            buffer.append("throw new IllegalArgumentException(\"Value \" + value + \"");
            buffer.append(" is not an instance of ").append(paramType);
            buffer.append(" for ").append(ctField.getName()).append("\");");
        }
        if (isInstanceField) {
            buffer.append('(');
            if (needsCast) {
                buffer.append("(").append(declaring.getName()).append(')');
            }
            buffer.append("target).");
        } else {
            buffer.append(declaring.getName()).append('.');
        }
        buffer.append(ctField.getName()).append("=");
        buffer.append('(');
        if (!object.equals(type)) {
            buffer.append("(").append(this.getBoxedType(type)).append(')');
        }
        buffer.append("value)");
        if (type.isPrimitive()) {
            this.unbox(buffer, type);
        }
        buffer.append(";}");
        code = buffer.toString();
        try {
            CtMethod set = CtNewMethod.make((String)code, (CtClass)result);
            result.addMethod(set);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot compile " + code, e);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JavassistField>(){

                @Override
                public JavassistField run() throws Exception {
                    Class clazz = result.toClass();
                    return (JavassistField)clazz.newInstance();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    protected void unbox(JBossStringBuilder buffer, CtClass primitive) {
        if (CtClass.booleanType.equals(primitive)) {
            buffer.append(".booleanValue()");
        } else if (CtClass.byteType.equals(primitive)) {
            buffer.append(".byteValue()");
        } else if (CtClass.charType.equals(primitive)) {
            buffer.append(".charValue()");
        } else if (CtClass.doubleType.equals(primitive)) {
            buffer.append(".doubleValue()");
        } else if (CtClass.floatType.equals(primitive)) {
            buffer.append(".floatValue()");
        } else if (CtClass.intType.equals(primitive)) {
            buffer.append(".intValue()");
        } else if (CtClass.longType.equals(primitive)) {
            buffer.append(".longValue()");
        } else if (CtClass.shortType.equals(primitive)) {
            buffer.append(".shortValue()");
        } else {
            throw new UnreachableStatementException();
        }
    }

    protected String getBoxedType(CtClass type) {
        if (type.isPrimitive()) {
            if (CtClass.booleanType.equals(type)) {
                return Boolean.class.getName();
            }
            if (CtClass.byteType.equals(type)) {
                return Byte.class.getName();
            }
            if (CtClass.charType.equals(type)) {
                return Character.class.getName();
            }
            if (CtClass.doubleType.equals(type)) {
                return Double.class.getName();
            }
            if (CtClass.floatType.equals(type)) {
                return Float.class.getName();
            }
            if (CtClass.intType.equals(type)) {
                return Integer.class.getName();
            }
            if (CtClass.longType.equals(type)) {
                return Long.class.getName();
            }
            if (CtClass.shortType.equals(type)) {
                return Short.class.getName();
            }
            throw new UnreachableStatementException();
        }
        return type.getName();
    }
}

