/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy;

import java.security.Principal;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationKey;
import org.jboss.proxy.Interceptor;
import org.jboss.proxy.SecurityActions;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;

public class SecurityInterceptor
extends Interceptor {
    private static final long serialVersionUID = -4206940878404525061L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        Object credential;
        SecurityActions sa = SecurityActions.UTIL.getSecurityActions();
        Principal principal = sa.getPrincipal();
        if (principal != null) {
            invocation.setPrincipal(principal);
        }
        if ((credential = sa.getCredential()) != null) {
            invocation.setCredential(credential);
        }
        RunAsIdentity callerRAI = sa.getCallerRunAsIdentity();
        SecurityContext newSc = this.createSecurityContext(invocation);
        if (callerRAI != null) {
            newSc.getUtil().set(newSc, "RunAsIdentity", callerRAI);
        }
        invocation.getAsIsPayload().put(InvocationKey.SECURITY_CONTEXT, newSc);
        try {
            Object object = this.getNext().invoke(invocation);
            return object;
        }
        finally {
            SecurityContext existingSC = sa.getSecurityContext();
            if (existingSC != null) {
                existingSC.getUtil().set(existingSC, "RunAsIdentity", callerRAI);
            }
        }
    }

    private SecurityContext createSecurityContext(Invocation invocation) {
        SecurityActions sa = SecurityActions.UTIL.getSecurityActions();
        Principal p = invocation.getPrincipal();
        Object cred = invocation.getCredential();
        return sa.createSecurityContext(p, cred, "CLIENT_PROXY");
    }
}

