/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.aop;

import java.util.Map;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployers.spi.management.ComponentType;
import org.jboss.deployers.spi.management.ComponentTypeListener;
import org.jboss.deployers.spi.management.ComponentTypeVisitor;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.AttachmentsSerializer;

public class DeployerAspects {
    private static Logger log = Logger.getLogger(DeployerAspects.class);
    private static ComponentTypeVisitor compVisitor;
    private static ComponentTypeListener compListener;
    private static AttachmentsSerializer attachmentsSerializer;
    private static boolean trace;

    public static ComponentTypeVisitor getCompVisitor() {
        return compVisitor;
    }

    public static void setCompVisitor(ComponentTypeVisitor compVisitor) {
        DeployerAspects.compVisitor = compVisitor;
    }

    public static ComponentTypeListener getCompListener() {
        return compListener;
    }

    public static void setCompListener(ComponentTypeListener compListener) {
        DeployerAspects.compListener = compListener;
    }

    public static AttachmentsSerializer getAttachmentsSerializer() {
        return attachmentsSerializer;
    }

    public static void setAttachmentsSerializer(AttachmentsSerializer attachmentsSerializer) {
        DeployerAspects.attachmentsSerializer = attachmentsSerializer;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (trace) {
            log.trace(invocation);
        }
        MethodInvocation mi = (MethodInvocation)invocation;
        String methodName = mi.getMethod().getName();
        Object value = null;
        value = methodName.equals("prepareDeploy") ? this.prepareDeploy(mi) : (methodName.equals("commitDeploy") ? this.commitDeploy(mi) : (methodName.equals("prepareUndeploy") ? this.prepareUndeploy(mi) : (methodName.equals("commitUndeploy") ? this.commitUndeploy(mi) : invocation.invokeNext())));
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object prepareDeploy(MethodInvocation invocation) throws Throwable {
        Deployer target = (Deployer)Deployer.class.cast(invocation.getTargetObject());
        Object[] args = invocation.getArguments();
        DeploymentUnit unit = (DeploymentUnit)DeploymentUnit.class.cast(args[0]);
        if (trace) {
            log.trace("prepareDeploy, target=" + target + ", unit=" + unit.getSimpleName());
        }
        if (attachmentsSerializer != null) {
            ClassLoader loader = null;
            try {
                loader = unit.getClassLoader();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            ClassLoader prevTCL = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = prevTCL;
            }
            String deployerID = target.getClass().getSimpleName();
            try {
                Map<String, Object> map = attachmentsSerializer.loadAttachments(unit, deployerID, loader);
                if (map != null) {
                    if (unit.getSimpleName().equals("hsqldb-ds.xml")) {
                        log.info("Loading hsqldb-ds.xml attachments, " + deployerID);
                    }
                    for (String key : map.keySet()) {
                        Object value = map.get(key);
                        DeploymentContext ctx = unit.getDeploymentContext();
                        ctx.getPredeterminedManagedObjects().addAttachment(key, value);
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevTCL);
            }
        }
        return invocation.invokeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object commitDeploy(MethodInvocation invocation) throws Throwable {
        ComponentType type;
        Object value = invocation.invokeNext();
        Object[] args = invocation.getArguments();
        Deployer target = (Deployer)Deployer.class.cast(invocation.getTargetObject());
        DeploymentUnit unit = (DeploymentUnit)DeploymentUnit.class.cast(args[0]);
        if (trace) {
            log.trace("commitDeploy, target=" + target + ", unit=" + unit.getSimpleName());
        }
        if (compVisitor != null && (type = compVisitor.visit(unit)) != null && compListener != null) {
            compListener.updateComponentType(unit, type);
        }
        if (attachmentsSerializer != null) {
            ClassLoader loader = null;
            try {
                loader = unit.getClassLoader();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            ClassLoader prevTCL = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = prevTCL;
            }
            String deployerID = target.getClass().getSimpleName();
            try {
                attachmentsSerializer.saveAttachments(unit, deployerID, loader);
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevTCL);
            }
        }
        return value;
    }

    public Object prepareUndeploy(MethodInvocation invocation) throws Throwable {
        Object target = invocation.getTargetObject();
        if (trace) {
            log.trace("prepareUndeploy, target=" + target);
        }
        return invocation.invokeNext();
    }

    public Object commitUndeploy(MethodInvocation invocation) throws Throwable {
        Object target = invocation.getTargetObject();
        Object value = invocation.invokeNext();
        if (trace) {
            log.trace("commitUndeploy, target=" + target);
        }
        return value;
    }

    static {
        trace = true;
    }
}

