/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.metadata.DDObjectFactory;
import org.jboss.metadata.EjbLocalRefMetaData;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EnvEntryMetaData;
import org.jboss.metadata.MessageDestinationMetaData;
import org.jboss.metadata.MessageDestinationRefMetaData;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.metadata.SecurityRoleMetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.metadata.web.PassivationConfig;
import org.jboss.metadata.web.ReplicationConfig;
import org.jboss.metadata.web.Servlet;
import org.jboss.metadata.web.ServletMapping;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.ws.integration.ServiceRefMetaData;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class JBossWebMetaDataObjectFactory
extends DDObjectFactory {
    private static Logger log = Logger.getLogger(JBossWebMetaDataObjectFactory.class);
    private static final ThreadLocal<WebMetaData> activeMetaData = new ThreadLocal();
    private WebMetaData metaData;

    public static WebMetaData parse(URL ddResource, WebMetaData dd) throws JBossXBException, IOException {
        if (ddResource == null) {
            return null;
        }
        log.debug("found jboss-web.xml " + ddResource);
        InputStream is = ddResource.openStream();
        return JBossWebMetaDataObjectFactory.parse(dd, is);
    }

    public static WebMetaData parse(WebMetaData metaData, InputStream is) throws JBossXBException {
        JBossWebMetaDataObjectFactory factory = null;
        Unmarshaller unmarshaller = null;
        if (metaData == null) {
            metaData = new WebMetaData();
        }
        activeMetaData.set(metaData);
        factory = new JBossWebMetaDataObjectFactory(metaData);
        UnmarshallerFactory unmarshallerFactory = UnmarshallerFactory.newInstance();
        unmarshaller = unmarshallerFactory.newUnmarshaller();
        JBossEntityResolver entityResolver = new JBossEntityResolver();
        unmarshaller.setEntityResolver(entityResolver);
        metaData = (WebMetaData)unmarshaller.unmarshal(is, (ObjectModelFactory)factory, null);
        return metaData;
    }

    public JBossWebMetaDataObjectFactory(WebMetaData dd) {
        this.metaData = dd;
    }

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if (root == null && this.metaData == null) {
            throw new IllegalStateException("No existing WebMetaData, check the JBossWebAppParsingDeployer order");
        }
        return root == null ? this.metaData : root;
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        return root;
    }

    public Object newChild(WebMetaData dd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Object child = null;
        log.debug("newChild, " + localName);
        child = this.newEnvRefGroupChild(localName);
        if (child != null) {
            return child;
        }
        if (localName.equals("security-role")) {
            child = new SecurityRoleMetaData();
        } else if (localName.equals("class-loading")) {
            child = new LoaderRepositoryFactory.LoaderRepositoryConfig();
        } else if (localName.equals("servlet")) {
            child = new Servlet();
        } else if (localName.equals("replication-config")) {
            child = new ReplicationConfig();
        } else if (localName.equals("passivation-config")) {
            child = new PassivationConfig();
        } else if (localName.equals("message-destination")) {
            child = new MessageDestinationMetaData();
        }
        return child;
    }

    public void addChild(WebMetaData parent, ReplicationConfig config, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setReplicationConfig(config);
    }

    public void addChild(WebMetaData parent, PassivationConfig config, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setPassivationConfig(config);
    }

    public void addChild(WebMetaData parent, EjbLocalRefMetaData ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEjbLocalRef(ref);
    }

    public void addChild(WebMetaData parent, EjbRefMetaData ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEjbRef(ref);
    }

    public void addChild(WebMetaData parent, EnvEntryMetaData ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEnvEntry(ref);
    }

    public void addChild(WebMetaData parent, MessageDestinationMetaData destination, UnmarshallingContext navigator, String namespaceURI, String localName) {
        MessageDestinationMetaData ref;
        log.debug("addMessageDestinationMetaData, " + destination);
        parent.addMessageDestination(destination);
        String link = destination.getJNDIName();
        if (link != null && (ref = parent.getMessageDestination(link)) != null) {
            log.debug("ressolved " + ref + " to link JndiName: " + destination.getJNDIName());
            ref.setJNDIName(destination.getJNDIName());
        }
    }

    public void addChild(WebMetaData parent, MessageDestinationRefMetaData ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.debug("addMessageDestinationMetaDataRef, " + ref);
        parent.addMessageDestinationRef(ref);
    }

    public void addChild(WebMetaData parent, ResourceEnvRefMetaData ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.updateResourceEnvRef(ref);
    }

    public void addChild(WebMetaData parent, ResourceRefMetaData ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.updateResourceRef(ref);
    }

    public void addChild(WebMetaData parent, SecurityRoleMetaData role, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addSecurityRole(role);
    }

    public void addChild(WebMetaData parent, LoaderRepositoryFactory.LoaderRepositoryConfig cfg, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setLoaderConfig(cfg);
    }

    public void addChild(WebMetaData parent, ServiceRefMetaData sref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        String refName = sref.getServiceRefName();
        if (refName == null) {
            throw new IllegalStateException("Invalid service-ref-name: " + refName);
        }
        ServiceRefMetaData targetRef = parent.getServiceRef(refName);
        if (targetRef == null) {
            log.debug("Cannot find <service-ref> with name: " + refName);
            parent.addServiceRef(sref);
        } else {
            targetRef.merge(sref);
        }
    }

    public void addChild(WebMetaData parent, Servlet servlet, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.updateServlet(servlet);
    }

    public void setValue(WebMetaData dd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("depends")) {
            dd.addDependency(value);
        } else if (localName.equals("context-root")) {
            dd.setContextRoot(value);
        } else if (localName.equals("security-domain")) {
            dd.setSecurityDomain(value);
        }
    }

    public void setValue(ReplicationConfig config, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("replication-trigger")) {
            config.setTrigger(value);
        } else if (localName.equals("replication-granularity")) {
            config.setGranularity(value);
        } else if (localName.equals("replication-field-batch-mode")) {
            config.setFieldBatchMode(value);
        }
    }

    public void setValue(PassivationConfig config, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("use-session-passivation")) {
            config.setUseSessionPassivation(value);
        } else if (localName.equals("passivation-min-idle-time")) {
            config.setPassivationMinIdleTime(value);
        } else if (localName.equals("passivation-max-idle-time")) {
            config.setPassivationMaxIdleTime(value);
        }
    }

    public void setValue(Servlet servlet, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("servlet-name")) {
            servlet.setName(value);
        } else if (localName.equals("run-as-principal")) {
            servlet.setRunAsPrincipal(value);
        }
    }

    public void setValue(ServletMapping mapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("servlet-name")) {
            mapping.setName(value);
        } else if (localName.equals("url-pattern")) {
            mapping.addUrlPattern(value);
        }
    }

    public void setValue(SecurityRoleMetaData role, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("principal-name")) {
            role.addPrincipalName(value);
        } else {
            super.setValue(role, navigator, namespaceURI, localName, value);
        }
    }

    public void setValue(LoaderRepositoryFactory.LoaderRepositoryConfig cfg, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("loader-repository")) {
            cfg.repositoryName = ObjectNameFactory.create(value);
        } else if (localName.equals("loader-repository-config")) {
            cfg.repositoryConfig = value;
        }
    }
}

