/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.CacheInvalidationConfigMetaData;
import org.jboss.metadata.QueryMetaData;
import org.jboss.util.Strings;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMetaData
extends BeanMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CMP_VERSION_1 = 1;
    public static final int CMP_VERSION_2 = 2;
    public static final String DEFAULT_ENTITY_INVOKER_PROXY_BINDING = "entity-unified-invoker";
    public static final String DEFAULT_CLUSTERED_ENTITY_INVOKER_PROXY_BINDING = "clustered-entity-unified-invoker";
    private boolean cmp;
    private String primaryKeyClass;
    private boolean reentrant;
    private int cmpVersion;
    private String abstractSchemaName;
    private ArrayList<String> cmpFields = new ArrayList();
    private String primKeyField;
    private ArrayList<QueryMetaData> queries = new ArrayList();
    private boolean readOnly = false;
    private boolean doDistCachInvalidations = false;
    private CacheInvalidationConfigMetaData cacheInvalidConfig = null;
    private static Logger log = Logger.getLogger(EntityMetaData.class);

    public EntityMetaData(ApplicationMetaData app) {
        super(app, 'E');
    }

    public boolean isCMP() {
        return this.cmp;
    }

    public void setCmp(boolean cmp) {
        this.cmp = cmp;
    }

    public boolean isCMP1x() {
        return this.cmp && this.cmpVersion == 1;
    }

    public boolean isCMP2x() {
        return this.cmp && this.cmpVersion == 2;
    }

    public boolean isBMP() {
        return !this.cmp;
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public void setAbstractSchemaName(String abstractSchemaName) {
        this.abstractSchemaName = abstractSchemaName;
    }

    public CacheInvalidationConfigMetaData getCacheInvalidConfig() {
        return this.cacheInvalidConfig;
    }

    public void setCacheInvalidConfig(CacheInvalidationConfigMetaData cacheInvalidConfig) {
        this.cacheInvalidConfig = cacheInvalidConfig;
    }

    public ArrayList<String> getCmpFields() {
        return this.cmpFields;
    }

    public void setCmpFields(ArrayList<String> cmpFields) {
        this.cmpFields = cmpFields;
    }

    public int getCmpVersion() {
        return this.cmpVersion;
    }

    public void setCmpVersion(int cmpVersion) {
        this.cmpVersion = cmpVersion;
    }

    public boolean isDoDistCachInvalidations() {
        return this.doDistCachInvalidations;
    }

    public void setDoDistCachInvalidations(boolean doDistCachInvalidations) {
        this.doDistCachInvalidations = doDistCachInvalidations;
    }

    public String getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public void setPrimaryKeyClass(String primaryKeyClass) {
        this.primaryKeyClass = primaryKeyClass;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReentrant() {
        return this.reentrant;
    }

    public void setReentrant(boolean reentrant) {
        this.reentrant = reentrant;
    }

    public void setPrimKeyField(String primKeyField) {
        this.primKeyField = primKeyField;
    }

    public void setQueries(ArrayList queries) {
        this.queries = queries;
    }

    public Iterator getCMPFields() {
        return this.cmpFields.iterator();
    }

    public String getPrimKeyField() {
        return this.primKeyField;
    }

    public Iterator getQueries() {
        return this.queries.iterator();
    }

    public void addQuery(QueryMetaData query) {
        this.queries.add(query);
    }

    @Override
    public String getDefaultConfigurationName() {
        if (this.isCMP()) {
            if (this.getApplicationMetaData().isEJB2x()) {
                if (this.isClustered()) {
                    return "Clustered CMP 2.x EntityBean";
                }
                return "Standard CMP 2.x EntityBean";
            }
            if (this.isClustered()) {
                return "Clustered CMP EntityBean";
            }
            return "Standard CMP EntityBean";
        }
        if (this.isClustered()) {
            return "Clustered BMP EntityBean";
        }
        return "Standard BMP EntityBean";
    }

    public boolean doDistributedCacheInvalidations() {
        return this.doDistCachInvalidations;
    }

    public CacheInvalidationConfigMetaData getDistributedCacheInvalidationConfig() {
        return this.cacheInvalidConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void importEjbJarXml(Element element) throws DeploymentException {
        super.importEjbJarXml(element);
        String persistenceType = EntityMetaData.getElementContent(EntityMetaData.getUniqueChild(element, "persistence-type"));
        if (persistenceType.equals("Bean")) {
            this.cmp = false;
        } else {
            if (!persistenceType.equals("Container")) throw new DeploymentException(this.getEjbName() + ": " + "persistence-type must be 'Bean' or 'Container'!");
            this.cmp = true;
        }
        this.primaryKeyClass = EntityMetaData.getElementContent(EntityMetaData.getUniqueChild(element, "prim-key-class"));
        this.reentrant = Boolean.valueOf(EntityMetaData.getElementContent(EntityMetaData.getUniqueChild(element, "reentrant")));
        if (!this.isCMP()) return;
        if (this.getApplicationMetaData().isEJB2x()) {
            String cmpVersionString = EntityMetaData.getElementContent(EntityMetaData.getOptionalChild(element, "cmp-version"));
            if (cmpVersionString == null) {
                this.cmpVersion = 2;
            } else if ("1.x".equals(cmpVersionString)) {
                this.cmpVersion = 1;
            } else {
                if (!"2.x".equals(cmpVersionString)) throw new DeploymentException(this.getEjbName() + ": " + "cmp-version must be '1.x' or '2.x', if specified");
                this.cmpVersion = 2;
            }
        } else {
            this.cmpVersion = 1;
        }
        this.abstractSchemaName = EntityMetaData.getOptionalChildContent(element, "abstract-schema-name");
        if (this.cmpVersion == 2) {
            String ejbName = this.getEjbName();
            if (!Strings.isValidJavaIdentifier(ejbName)) {
                throw new DeploymentException("The ejb-name for a CMP2.x Entity must be a valid Java Identifier");
            }
            if (Strings.isEjbQlIdentifier(ejbName)) {
                log.warn(ejbName + ": The ejb-name for a CMP 2.x Entity " + "should not be a reserved EJB-QL keyword");
            }
            if (this.abstractSchemaName == null) {
                throw new DeploymentException("The abstract-schema-name must be specified for CMP 2.x Beans");
            }
            if (!Strings.isValidJavaIdentifier(this.abstractSchemaName)) {
                throw new DeploymentException("The abstract-schema-name must be a valid Java Identifier '" + this.abstractSchemaName + "'");
            }
            if (Strings.isEjbQlIdentifier(this.abstractSchemaName)) {
                log.warn(ejbName + ": The abstract-schema-name should " + "not be a reserved EJB-QL Identifier '" + this.abstractSchemaName + "'");
            }
        }
        Iterator iterator = EntityMetaData.getChildrenByTagName(element, "cmp-field");
        while (iterator.hasNext()) {
            Element field = (Element)iterator.next();
            this.cmpFields.add(EntityMetaData.getElementContent(EntityMetaData.getUniqueChild(field, "field-name")));
        }
        this.primKeyField = EntityMetaData.getElementContent(EntityMetaData.getOptionalChild(element, "primkey-field"));
        if (this.primKeyField != null && !this.cmpFields.contains(this.primKeyField)) {
            throw new DeploymentException("primkey-field " + this.primKeyField + " is not a cmp-field");
        }
        iterator = EntityMetaData.getChildrenByTagName(element, "query");
        while (iterator.hasNext()) {
            Element queryElement = (Element)iterator.next();
            QueryMetaData queryMetaData = new QueryMetaData();
            queryMetaData.importEjbJarXml(queryElement);
            this.queries.add(queryMetaData);
        }
    }

    @Override
    protected void defaultInvokerBindings() {
        this.invokerBindings = new HashMap();
        if (this.isClustered()) {
            this.invokerBindings.put(DEFAULT_CLUSTERED_ENTITY_INVOKER_PROXY_BINDING, this.getJndiName());
        } else {
            this.invokerBindings.put(DEFAULT_ENTITY_INVOKER_PROXY_BINDING, this.getJndiName());
        }
    }

    @Override
    public void importJbossXml(Element element) throws DeploymentException {
        super.importJbossXml(element);
        String readOnlyString = EntityMetaData.getElementContent(EntityMetaData.getOptionalChild(element, "read-only"));
        if (readOnlyString != null) {
            this.readOnly = Boolean.valueOf(readOnlyString);
        }
        String distCacheInvalidations = EntityMetaData.getElementContent(EntityMetaData.getOptionalChild(element, "cache-invalidation"), this.doDistCachInvalidations ? "True" : "False");
        this.doDistCachInvalidations = distCacheInvalidations.equalsIgnoreCase("True");
        Element cacheInvalidConfigElement = EntityMetaData.getOptionalChild(element, "cache-invalidation-config");
        this.cacheInvalidConfig = new CacheInvalidationConfigMetaData();
        this.cacheInvalidConfig.init(this);
        if (cacheInvalidConfigElement != null) {
            this.cacheInvalidConfig.importJbossXml(cacheInvalidConfigElement);
        }
    }
}

