/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterTransaction;
import org.jboss.messaging.core.plugin.postoffice.cluster.PostOfficeInternal;
import org.jboss.messaging.core.plugin.postoffice.cluster.TransactionId;

abstract class TransactionRequest
extends ClusterRequest
implements ClusterTransaction {
    private static final Logger log = Logger.getLogger(TransactionRequest.class);
    protected int nodeId;
    protected long txId;
    protected boolean hold;
    protected long checkChannelID;

    TransactionRequest() {
    }

    TransactionRequest(int nodeId, long txId, boolean hold, long checkChannelID) {
        this.nodeId = nodeId;
        this.txId = txId;
        this.hold = hold;
        this.checkChannelID = checkChannelID;
    }

    TransactionRequest(int nodeId, long txId, boolean hold) {
        this.nodeId = nodeId;
        this.txId = txId;
        this.hold = hold;
    }

    Object execute(PostOfficeInternal office) throws Throwable {
        TransactionId id = new TransactionId(this.nodeId, this.txId);
        if (this.hold) {
            office.holdTransaction(id, this);
        } else {
            office.commitTransaction(id);
        }
        return null;
    }

    public void read(DataInputStream in) throws Exception {
        this.nodeId = in.readInt();
        this.txId = in.readLong();
        this.hold = in.readBoolean();
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.nodeId);
        out.writeLong(this.txId);
        out.writeBoolean(this.hold);
    }
}

