/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.plugin.contract.MessagingComponent;
import org.jboss.messaging.core.plugin.postoffice.cluster.DefaultClusteredPostOffice;
import org.jboss.messaging.core.plugin.postoffice.cluster.PostOfficeInternal;

public class StatsSender
implements MessagingComponent {
    private static final Logger log = Logger.getLogger(DefaultClusteredPostOffice.class);
    private PostOfficeInternal office;
    private boolean started;
    private Timer timer;
    private long period;
    private SendStatsTimerTask task;

    StatsSender(PostOfficeInternal office, long period) {
        this.office = office;
        this.period = period;
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.timer = new Timer(true);
        long delay = (long)((double)this.period * Math.random());
        this.task = new SendStatsTimerTask();
        this.timer.schedule((TimerTask)this.task, delay, this.period);
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.task.stop();
        this.timer.cancel();
        this.timer = null;
        this.started = false;
    }

    class SendStatsTimerTask
    extends TimerTask {
        SendStatsTimerTask() {
        }

        public synchronized void run() {
            try {
                StatsSender.this.office.sendQueueStats();
            }
            catch (Exception e) {
                log.error("Failed to send statistics", e);
            }
        }

        synchronized void stop() {
            this.cancel();
        }
    }
}

