/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.MessageHolder;
import org.jboss.messaging.core.plugin.postoffice.cluster.PostOfficeInternal;

class MessagesRequest
extends ClusterRequest {
    static final int TYPE = 4;
    private List messageHolders;

    MessagesRequest() {
    }

    MessagesRequest(List messageHolders) {
        this.messageHolders = messageHolders;
    }

    Object execute(PostOfficeInternal office) throws Exception {
        Iterator iter = this.messageHolders.iterator();
        while (iter.hasNext()) {
            MessageHolder holder = (MessageHolder)iter.next();
            office.routeFromCluster(holder.getMessage(), holder.getRoutingKey(), holder.getQueueNameToNodeIdMap());
        }
        return null;
    }

    byte getType() {
        return 4;
    }

    public void read(DataInputStream in) throws Exception {
        int size = in.readInt();
        this.messageHolders = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            MessageHolder holder = new MessageHolder();
            holder.read(in);
            this.messageHolders.add(holder);
        }
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.messageHolders.size());
        Iterator iter = this.messageHolders.iterator();
        while (iter.hasNext()) {
            MessageHolder holder = (MessageHolder)iter.next();
            holder.write(out);
        }
    }
}

