/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.Delivery;
import org.jboss.messaging.core.DeliveryObserver;
import org.jboss.messaging.core.Queue;
import org.jboss.messaging.core.Receiver;
import org.jboss.messaging.core.message.MessageReference;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterRouter;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusteredQueue;
import org.jboss.messaging.core.tx.Transaction;

public class DefaultRouter
implements ClusterRouter {
    private static final Logger log = Logger.getLogger(DefaultRouter.class);
    private boolean trace = log.isTraceEnabled();
    private ArrayList nonLocalQueues = new ArrayList();
    private Queue localQueue;
    private int target;

    public Delivery handle(DeliveryObserver observer, MessageReference ref, Transaction tx) {
        if (this.trace) {
            log.trace(this + " routing " + ref);
        }
        if (this.localQueue != null) {
            Delivery del = this.localQueue.handle(observer, ref, tx);
            if (this.trace) {
                log.trace(this + " routed to local queue, it returned " + del);
            }
            return del;
        }
        if (!this.nonLocalQueues.isEmpty()) {
            ClusteredQueue queue = (ClusteredQueue)this.nonLocalQueues.get(this.target);
            Delivery del = queue.handle(observer, ref, tx);
            if (this.trace) {
                log.trace(this + " routed to remote queue, it returned " + del);
            }
            this.incTarget();
            return del;
        }
        if (this.trace) {
            log.trace(this + " no queues to route to so return null");
        }
        return null;
    }

    public boolean contains(Receiver queue) {
        return this.localQueue == queue || this.nonLocalQueues.contains(queue);
    }

    public Iterator iterator() {
        ArrayList<Queue> queues = new ArrayList<Queue>();
        if (this.localQueue != null) {
            queues.add(this.localQueue);
        }
        queues.addAll(this.nonLocalQueues);
        return queues.iterator();
    }

    public boolean add(Receiver receiver) {
        return this.add(receiver, false);
    }

    public boolean remove(Receiver queue) {
        if (this.localQueue == queue) {
            this.localQueue = null;
            return true;
        }
        if (this.nonLocalQueues.remove(queue)) {
            if (this.target >= this.nonLocalQueues.size() - 1) {
                this.target = this.nonLocalQueues.size() - 1;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this.nonLocalQueues.clear();
        this.localQueue = null;
        this.target = 0;
    }

    public int getNumberOfReceivers() {
        return this.nonLocalQueues.size() + (this.localQueue != null ? 1 : 0);
    }

    public List getQueues() {
        ArrayList<Queue> queues = new ArrayList<Queue>();
        if (this.localQueue != null) {
            queues.add(this.localQueue);
        }
        queues.addAll(this.nonLocalQueues);
        return queues;
    }

    public Queue getLocalQueue() {
        return this.localQueue;
    }

    public boolean add(Receiver receiver, boolean failedOver) {
        if (receiver instanceof ClusteredQueue) {
            ClusteredQueue queue = (ClusteredQueue)receiver;
            if (queue.isLocal()) {
                if (this.localQueue != null) {
                    throw new IllegalStateException(this + " already has local queue");
                }
                this.localQueue = queue;
            } else {
                this.nonLocalQueues.add(queue);
            }
        } else {
            this.localQueue = (Queue)receiver;
        }
        return true;
    }

    public int size() {
        return this.nonLocalQueues.size() + (this.localQueue == null ? 0 : 1);
    }

    public String toString() {
        return "Router[" + Integer.toHexString(this.hashCode()) + "]";
    }

    private void incTarget() {
        ++this.target;
        if (this.target == this.nonLocalQueues.size()) {
            this.target = 0;
        }
    }
}

