/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.messaging.core.plugin.postoffice.Binding;
import org.jboss.messaging.core.plugin.postoffice.DefaultBindings;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterRouter;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusteredBindings;

class DefaultClusteredBindings
extends DefaultBindings
implements ClusteredBindings {
    private Map nameMap = new HashMap();
    private int thisNode;
    private int localDurableCount;

    DefaultClusteredBindings(int thisNode) {
        this.thisNode = thisNode;
    }

    public void addBinding(Binding binding) {
        super.addBinding(binding);
        if (binding.getNodeID() == this.thisNode && binding.getQueue().isRecoverable()) {
            ++this.localDurableCount;
        }
    }

    public boolean removeBinding(Binding binding) {
        boolean removed = super.removeBinding(binding);
        if (!removed) {
            return false;
        }
        if (binding.getNodeID() == this.thisNode && binding.getQueue().isRecoverable()) {
            --this.localDurableCount;
        }
        return true;
    }

    public Collection getRouters() {
        return this.nameMap.values();
    }

    public int getLocalDurableCount() {
        return this.localDurableCount;
    }

    public void addRouter(String queueName, ClusterRouter router) {
        this.nameMap.put(queueName, router);
    }

    public void removeRouter(String queueName) {
        this.nameMap.remove(queueName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(":ClusteredBindings[");
        Iterator i = this.nameMap.keySet().iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(',');
        }
        sb.append("]");
        return sb.toString();
    }
}

