/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.messaging.core.plugin.postoffice.cluster.BindRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.LeaveClusterRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.MessageRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.MessagesRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.PostOfficeInternal;
import org.jboss.messaging.core.plugin.postoffice.cluster.PullMessageResultRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.PullMessagesRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.PutReplicantRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.QueueStatsRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.RemoveReplicantRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.RollbackPullRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.SendTransactionRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.UnbindRequest;
import org.jboss.messaging.util.Streamable;

abstract class ClusterRequest
implements Streamable {
    ClusterRequest() {
    }

    static ClusterRequest createFromStream(DataInputStream dais) throws Exception {
        byte type = dais.readByte();
        ClusterRequest request = null;
        switch (type) {
            case 1: {
                request = new BindRequest();
                break;
            }
            case 2: {
                request = new PullMessageResultRequest();
                break;
            }
            case 3: {
                request = new MessageRequest();
                break;
            }
            case 4: {
                request = new MessagesRequest();
                break;
            }
            case 5: {
                request = new PullMessagesRequest();
                break;
            }
            case 6: {
                request = new QueueStatsRequest();
                break;
            }
            case 8: {
                request = new SendTransactionRequest();
                break;
            }
            case 9: {
                request = new UnbindRequest();
                break;
            }
            case 10: {
                request = new RollbackPullRequest();
                break;
            }
            case 11: {
                request = new LeaveClusterRequest();
                break;
            }
            case 12: {
                request = new PutReplicantRequest();
                break;
            }
            case 13: {
                request = new RemoveReplicantRequest();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + type);
            }
        }
        request.read(dais);
        return request;
    }

    public static void writeToStream(DataOutputStream daos, ClusterRequest request) throws Exception {
        daos.writeByte(request.getType());
        request.write(daos);
    }

    abstract Object execute(PostOfficeInternal var1) throws Throwable;

    abstract byte getType();
}

