/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.message.Message;
import org.jboss.messaging.core.message.MessageFactory;
import org.jboss.messaging.core.message.MessageReference;
import org.jboss.messaging.core.message.MessageSupport;
import org.jboss.messaging.core.plugin.JDBCSupport;
import org.jboss.messaging.core.plugin.LockMap;
import org.jboss.messaging.core.plugin.contract.PersistenceManager;
import org.jboss.messaging.core.tx.MessagingXid;
import org.jboss.messaging.core.tx.PreparedTxInfo;
import org.jboss.messaging.core.tx.Transaction;
import org.jboss.messaging.core.tx.TxCallback;
import org.jboss.messaging.util.JDBCUtil;
import org.jboss.messaging.util.StreamUtils;
import org.jboss.messaging.util.Util;

public class JDBCPersistenceManager
extends JDBCSupport
implements PersistenceManager {
    private static final Logger log = Logger.getLogger(JDBCPersistenceManager.class);
    private boolean trace = log.isTraceEnabled();
    private boolean usingBatchUpdates = false;
    private boolean usingBinaryStream = true;
    private boolean usingTrailingByte = false;
    private int maxParams;
    private short orderCount;

    public JDBCPersistenceManager(DataSource ds, TransactionManager tm, Properties sqlProperties, boolean createTablesOnStartup, boolean usingBatchUpdates, boolean usingBinaryStream, boolean usingTrailingByte, int maxParams) {
        super(ds, tm, sqlProperties, createTablesOnStartup);
        this.usingBatchUpdates = usingBatchUpdates;
        this.usingBinaryStream = usingBinaryStream;
        this.usingTrailingByte = usingTrailingByte;
        this.maxParams = maxParams;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws Exception {
        JDBCSupport.TransactionWrapper wrap;
        block6: {
            super.start();
            Connection conn = null;
            wrap = new JDBCSupport.TransactionWrapper(this);
            try {
                try {
                    conn = this.ds.getConnection();
                    if (conn.getTransactionIsolation() != 2) {
                        int level = conn.getTransactionIsolation();
                        String warn = "\n\nJBoss Messaging Warning: DataSource connection transaction isolation should be READ_COMMITTED, but it is currently " + Util.transactionIsolationToString(level) + ".\n" + "                         Using an isolation level less strict than READ_COMMITTED may lead to data consistency problems.\n" + "                         Using an isolation level more strict than READ_COMMITTED may lead to deadlock.\n";
                        log.warn(warn);
                    }
                }
                catch (Exception e) {
                    wrap.exceptionOccurred();
                    throw e;
                }
                Object var6_6 = null;
                if (conn == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (conn != null) {
                    conn.close();
                }
                wrap.end();
                throw throwable;
            }
            conn.close();
        }
        wrap.end();
        log.debug(this + " started");
    }

    public void stop() throws Exception {
        super.stop();
    }

    public List getMessageChannelPairRefsForTx(long transactionId) throws Exception {
        String sql = this.getSQLStatement("SELECT_MESSAGE_ID_FOR_REF");
        return this.getMessageChannelPair(sql, transactionId);
    }

    public List getMessageChannelPairAcksForTx(long transactionId) throws Exception {
        String sql = this.getSQLStatement("SELECT_MESSAGE_ID_FOR_ACK");
        return this.getMessageChannelPair(sql, transactionId);
    }

    /*
     * Loose catch block
     */
    public List retrievePreparedTransactions() throws Exception {
        Throwable e2222;
        ArrayList<PreparedTxInfo> arrayList;
        JDBCSupport.TransactionWrapper wrap;
        ResultSet rs;
        Statement st;
        Connection conn;
        block19: {
            conn = null;
            st = null;
            rs = null;
            PreparedTxInfo txInfo = null;
            wrap = new JDBCSupport.TransactionWrapper(this);
            ArrayList<PreparedTxInfo> transactions = new ArrayList<PreparedTxInfo>();
            conn = this.ds.getConnection();
            st = conn.createStatement();
            String sql = this.getSQLStatement("SELECT_PREPARED_TRANSACTIONS");
            rs = st.executeQuery(sql);
            while (rs.next()) {
                long txId = rs.getLong(1);
                byte[] branchQual = this.getVarBinaryColumn(rs, 2);
                int formatId = rs.getInt(3);
                byte[] globalTxId = this.getVarBinaryColumn(rs, 4);
                MessagingXid xid = new MessagingXid(branchQual, formatId, globalTxId);
                txInfo = new PreparedTxInfo(txId, xid);
                transactions.add(txInfo);
            }
            arrayList = transactions;
            Object var15_15 = null;
            if (rs == null) break block19;
            try {
                rs.close();
            }
            catch (Throwable e2222) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (Throwable e2222) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable e2222) {
                // empty catch block
            }
        }
        wrap.end();
        return arrayList;
        catch (Exception e3) {
            try {
                wrap.exceptionOccurred();
                throw e3;
            }
            catch (Throwable throwable) {
                Throwable e2222;
                Object var15_16 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable e2222) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Throwable e2222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable e2222) {
                        // empty catch block
                    }
                }
                wrap.end();
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public long reserveIDBlock(String counterName, int size) throws Exception {
        Throwable e222;
        long l;
        JDBCSupport.TransactionWrapper wrap;
        Statement ps;
        Connection conn;
        block25: {
            ResultSet rs;
            block22: {
                Throwable e222;
                long l2;
                block23: {
                    if (this.trace) {
                        log.trace("Getting ID block for counter " + counterName + ", size " + size);
                    }
                    if (size <= 0) {
                        throw new IllegalArgumentException("block size must be > 0");
                    }
                    conn = null;
                    ps = null;
                    rs = null;
                    wrap = new JDBCSupport.TransactionWrapper(this);
                    conn = this.ds.getConnection();
                    String selectCounterSQL = this.getSQLStatement("SELECT_COUNTER");
                    ps = conn.prepareStatement(selectCounterSQL);
                    ps.setString(1, counterName);
                    rs = ps.executeQuery();
                    if (this.trace) {
                        log.trace(JDBCUtil.statementToString(selectCounterSQL, counterName));
                    }
                    if (rs.next()) break block22;
                    rs.close();
                    rs = null;
                    ps.close();
                    String insertCounterSQL = this.getSQLStatement("INSERT_COUNTER");
                    ps = conn.prepareStatement(insertCounterSQL);
                    ps.setString(1, counterName);
                    ps.setLong(2, size);
                    int rows = this.updateWithRetry((PreparedStatement)ps);
                    if (this.trace) {
                        log.trace(JDBCUtil.statementToString(insertCounterSQL, counterName, new Integer(size)) + " inserted " + rows + " rows");
                    }
                    ps.close();
                    ps = null;
                    l2 = 0L;
                    Object var15_14 = null;
                    if (ps == null) break block23;
                    try {
                        ps.close();
                    }
                    catch (Throwable e222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable e222) {
                        // empty catch block
                    }
                }
                wrap.end();
                return l2;
            }
            long nextId = rs.getLong(1);
            rs.close();
            rs = null;
            ps.close();
            String updateCounterSQL = this.getSQLStatement("UPDATE_COUNTER");
            ps = conn.prepareStatement(updateCounterSQL);
            ps.setLong(1, nextId + (long)size);
            ps.setString(2, counterName);
            int rows = this.updateWithRetry((PreparedStatement)ps);
            if (this.trace) {
                log.trace(JDBCUtil.statementToString(updateCounterSQL, new Long(nextId + (long)size), counterName) + " updated " + rows + " rows");
            }
            l = nextId;
            Object var15_15 = null;
            if (ps == null) break block25;
            try {
                ps.close();
            }
            catch (Throwable e222) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable e222) {
                // empty catch block
            }
        }
        wrap.end();
        return l;
        catch (Exception e3) {
            try {
                wrap.exceptionOccurred();
                throw e3;
            }
            catch (Throwable throwable) {
                Throwable e222;
                Object var15_16 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable e222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable e222) {
                        // empty catch block
                    }
                }
                wrap.end();
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public List getMessages(List messageIds) throws Exception {
        Throwable e2222;
        ArrayList<Message> arrayList;
        JDBCSupport.TransactionWrapper wrap;
        ResultSet rs;
        Statement ps;
        Connection conn;
        block25: {
            if (this.trace) {
                log.trace("Getting batch of messages for " + messageIds);
            }
            conn = null;
            ps = null;
            rs = null;
            wrap = new JDBCSupport.TransactionWrapper(this);
            conn = this.ds.getConnection();
            Iterator iter = messageIds.iterator();
            int size = messageIds.size();
            int count = 0;
            ArrayList<Message> msgs = new ArrayList<Message>();
            while (iter.hasNext()) {
                if (ps == null) {
                    int numParams = count < size / this.maxParams * this.maxParams ? this.maxParams : size % this.maxParams;
                    StringBuffer buff = new StringBuffer(this.getSQLStatement("LOAD_MESSAGES"));
                    buff.append(" WHERE ").append(this.getSQLStatement("MESSAGE_ID_COLUMN")).append(" IN (");
                    for (int i = 0; i < numParams; ++i) {
                        buff.append("?");
                        if (i >= numParams - 1) continue;
                        buff.append(",");
                    }
                    buff.append(")");
                    ps = conn.prepareStatement(buff.toString());
                    if (this.trace) {
                        log.trace(buff.toString());
                    }
                }
                long msgId = (Long)iter.next();
                ps.setLong(count % this.maxParams + 1, msgId);
                if (iter.hasNext() && ++count % this.maxParams != 0) continue;
                rs = ps.executeQuery();
                while (rs.next()) {
                    long messageId = rs.getLong(1);
                    boolean reliable = rs.getString(2).equals("Y");
                    long expiration = rs.getLong(3);
                    long timestamp = rs.getLong(4);
                    byte priority = rs.getByte(5);
                    byte[] bytes = this.getBytes(rs, 6);
                    HashMap headers = this.bytesToMap(bytes);
                    byte[] payload = this.getBytes(rs, 7);
                    byte type = rs.getByte(8);
                    Message m = MessageFactory.createMessage(messageId, reliable, expiration, timestamp, priority, headers, payload, type);
                    msgs.add(m);
                }
                rs.close();
                rs = null;
                ps.close();
                ps = null;
            }
            if (this.trace) {
                log.trace("Loaded " + msgs.size() + " messages in total");
            }
            arrayList = msgs;
            Object var26_26 = null;
            if (rs == null) break block25;
            try {
                rs.close();
            }
            catch (Throwable e2222) {
                // empty catch block
            }
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Throwable e2222) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable e2222) {
                // empty catch block
            }
        }
        wrap.end();
        return arrayList;
        catch (Exception e3) {
            try {
                wrap.exceptionOccurred();
                throw e3;
            }
            catch (Throwable throwable) {
                Throwable e2222;
                Object var26_27 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable e2222) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable e2222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable e2222) {
                        // empty catch block
                    }
                }
                wrap.end();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void pageReferences(long channelID, List references, boolean paged) throws Exception {
        Throwable t2222;
        JDBCSupport.TransactionWrapper wrap;
        Statement psUpdateMessage;
        Statement psInsertMessage;
        Statement psInsertReference;
        Connection conn;
        block49: {
            block48: {
                int[] rowsMessage;
                conn = null;
                psInsertReference = null;
                psInsertMessage = null;
                psUpdateMessage = null;
                PreparedStatement psMessageExists = null;
                ResultSet rsMessageExists = null;
                wrap = new JDBCSupport.TransactionWrapper(this);
                this.orderReferences(references);
                this.getLocks(references);
                conn = this.ds.getConnection();
                Iterator iter = references.iterator();
                boolean messageInsertsInBatch = false;
                boolean messageUpdatesInBatch = false;
                if (this.usingBatchUpdates) {
                    psInsertReference = conn.prepareStatement(this.getSQLStatement("INSERT_MESSAGE_REF"));
                    psInsertMessage = conn.prepareStatement(this.getSQLStatement("INSERT_MESSAGE"));
                    psUpdateMessage = conn.prepareStatement(this.getSQLStatement("INC_CHANNEL_COUNT"));
                }
                while (iter.hasNext()) {
                    int rows;
                    boolean added;
                    MessageReference ref = (MessageReference)iter.next();
                    if (!this.usingBatchUpdates) {
                        psInsertReference = conn.prepareStatement(this.getSQLStatement("INSERT_MESSAGE_REF"));
                    }
                    this.addReference(channelID, ref, (PreparedStatement)psInsertReference, paged);
                    if (this.usingBatchUpdates) {
                        psInsertReference.addBatch();
                    } else {
                        int rows2 = this.updateWithRetry((PreparedStatement)psInsertReference);
                        if (this.trace) {
                            log.trace("Inserted " + rows2 + " rows");
                        }
                        psInsertReference.close();
                        psInsertReference = null;
                    }
                    if (!this.usingBatchUpdates) {
                        psInsertMessage = conn.prepareStatement(this.getSQLStatement("INSERT_MESSAGE"));
                        psUpdateMessage = conn.prepareStatement(this.getSQLStatement("INC_CHANNEL_COUNT"));
                    }
                    Message m = ref.getMessage();
                    psMessageExists = conn.prepareStatement(this.getSQLStatement("MESSAGE_EXISTS"));
                    psMessageExists.setLong(1, m.getMessageID());
                    rsMessageExists = psMessageExists.executeQuery();
                    if (rsMessageExists.next()) {
                        this.incrementChannelCount(m, (PreparedStatement)psUpdateMessage);
                        added = false;
                    } else {
                        this.storeMessage(m, (PreparedStatement)psInsertMessage);
                        added = true;
                    }
                    if (this.usingBatchUpdates) {
                        if (added) {
                            psInsertMessage.addBatch();
                            messageInsertsInBatch = true;
                            continue;
                        }
                        psUpdateMessage.addBatch();
                        messageUpdatesInBatch = true;
                        continue;
                    }
                    if (added) {
                        rows = this.updateWithRetry((PreparedStatement)psInsertMessage);
                        if (this.trace) {
                            log.trace("Inserted " + rows + " rows");
                        }
                    } else {
                        rows = this.updateWithRetry((PreparedStatement)psUpdateMessage);
                        if (this.trace) {
                            log.trace("Updated " + rows + " rows");
                        }
                    }
                    psInsertMessage.close();
                    psInsertMessage = null;
                    psUpdateMessage.close();
                    psUpdateMessage = null;
                }
                if (!this.usingBatchUpdates) break block48;
                int[] rowsReference = this.updateWithRetryBatch((PreparedStatement)psInsertReference);
                if (this.trace) {
                    this.logBatchUpdate(this.getSQLStatement("INSERT_MESSAGE_REF"), rowsReference, "inserted");
                }
                if (messageInsertsInBatch) {
                    rowsMessage = this.updateWithRetryBatch((PreparedStatement)psInsertMessage);
                    if (this.trace) {
                        this.logBatchUpdate(this.getSQLStatement("INSERT_MESSAGE"), rowsMessage, "inserted");
                    }
                }
                if (messageUpdatesInBatch) {
                    rowsMessage = this.updateWithRetryBatch((PreparedStatement)psUpdateMessage);
                    if (this.trace) {
                        this.logBatchUpdate(this.getSQLStatement("INC_CHANNEL_COUNT"), rowsMessage, "updated");
                    }
                }
                psInsertReference.close();
                psInsertReference = null;
                psInsertMessage.close();
                psInsertMessage = null;
                psUpdateMessage.close();
                psUpdateMessage = null;
            }
            Object var20_20 = null;
            if (psInsertReference == null) break block49;
            try {
                psInsertReference.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        if (psInsertMessage != null) {
            try {
                psInsertMessage.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        if (psUpdateMessage != null) {
            try {
                psUpdateMessage.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        try {
            wrap.end();
        }
        finally {
            this.releaseLocks(references);
        }
        {
            catch (Exception e) {
                wrap.exceptionOccurred();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Throwable t2222;
            Object var20_21 = null;
            if (psInsertReference != null) {
                try {
                    psInsertReference.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (psInsertMessage != null) {
                try {
                    psInsertMessage.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (psUpdateMessage != null) {
                try {
                    psUpdateMessage.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            try {
                wrap.end();
            }
            finally {
                this.releaseLocks(references);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void removeDepagedReferences(long channelID, List references) throws Exception {
        Throwable t2222;
        JDBCSupport.TransactionWrapper wrap;
        Statement psUpdateMessage;
        Statement psDeleteMessage;
        Statement psDeleteReference;
        Connection conn;
        block43: {
            block42: {
                if (this.trace) {
                    log.trace(this + " Removing " + references.size() + " refs from channel " + channelID);
                }
                conn = null;
                psDeleteReference = null;
                psDeleteMessage = null;
                psUpdateMessage = null;
                wrap = new JDBCSupport.TransactionWrapper(this);
                this.orderReferences(references);
                this.getLocks(references);
                conn = this.ds.getConnection();
                Iterator iter = references.iterator();
                if (this.usingBatchUpdates) {
                    psDeleteReference = conn.prepareStatement(this.getSQLStatement("DELETE_MESSAGE_REF"));
                    psDeleteMessage = conn.prepareStatement(this.getSQLStatement("DELETE_MESSAGE"));
                    psUpdateMessage = conn.prepareStatement(this.getSQLStatement("DEC_CHANNEL_COUNT"));
                }
                while (iter.hasNext()) {
                    MessageReference ref = (MessageReference)iter.next();
                    if (!this.usingBatchUpdates) {
                        psDeleteReference = conn.prepareStatement(this.getSQLStatement("DELETE_MESSAGE_REF"));
                    }
                    this.removeReference(channelID, ref, (PreparedStatement)psDeleteReference);
                    if (this.usingBatchUpdates) {
                        psDeleteReference.addBatch();
                    } else {
                        int rows = this.updateWithRetry((PreparedStatement)psDeleteReference);
                        if (this.trace) {
                            log.trace("Deleted " + rows + " rows");
                        }
                        psDeleteReference.close();
                        psDeleteReference = null;
                    }
                    if (!this.usingBatchUpdates) {
                        psDeleteMessage = conn.prepareStatement(this.getSQLStatement("DELETE_MESSAGE"));
                        psUpdateMessage = conn.prepareStatement(this.getSQLStatement("DEC_CHANNEL_COUNT"));
                    }
                    Message m = ref.getMessage();
                    this.decrementChannelCount(m, (PreparedStatement)psUpdateMessage);
                    this.removeMessage(m, (PreparedStatement)psDeleteMessage);
                    if (this.usingBatchUpdates) {
                        psUpdateMessage.addBatch();
                        psDeleteMessage.addBatch();
                        continue;
                    }
                    int rows = this.updateWithRetry((PreparedStatement)psUpdateMessage);
                    if (this.trace) {
                        log.trace("Updated " + rows + " rows");
                    }
                    rows = this.updateWithRetry((PreparedStatement)psDeleteMessage);
                    if (this.trace) {
                        log.trace("Deleted " + rows + " rows");
                    }
                    psDeleteMessage.close();
                    psDeleteMessage = null;
                    psUpdateMessage.close();
                    psUpdateMessage = null;
                }
                if (!this.usingBatchUpdates) break block42;
                int[] rowsReference = this.updateWithRetryBatch((PreparedStatement)psDeleteReference);
                if (this.trace) {
                    this.logBatchUpdate(this.getSQLStatement("DELETE_MESSAGE_REF"), rowsReference, "deleted");
                }
                rowsReference = this.updateWithRetryBatch((PreparedStatement)psUpdateMessage);
                if (this.trace) {
                    this.logBatchUpdate(this.getSQLStatement("DEC_CHANNEL_COUNT"), rowsReference, "updated");
                }
                rowsReference = this.updateWithRetryBatch((PreparedStatement)psDeleteMessage);
                if (this.trace) {
                    this.logBatchUpdate(this.getSQLStatement("DELETE_MESSAGE"), rowsReference, "deleted");
                }
                psDeleteReference.close();
                psDeleteReference = null;
                psDeleteMessage.close();
                psDeleteMessage = null;
                psUpdateMessage.close();
                psUpdateMessage = null;
            }
            Object var14_14 = null;
            if (psDeleteReference == null) break block43;
            try {
                psDeleteReference.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        if (psDeleteMessage != null) {
            try {
                psDeleteMessage.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        if (psUpdateMessage != null) {
            try {
                psUpdateMessage.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        try {
            wrap.end();
        }
        finally {
            this.releaseLocks(references);
        }
        {
            catch (Exception e) {
                wrap.exceptionOccurred();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Throwable t2222;
            Object var14_15 = null;
            if (psDeleteReference != null) {
                try {
                    psDeleteReference.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (psDeleteMessage != null) {
                try {
                    psDeleteMessage.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (psUpdateMessage != null) {
                try {
                    psUpdateMessage.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            try {
                wrap.end();
            }
            finally {
                this.releaseLocks(references);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public void updateReferencesNotPagedInRange(long channelID, long orderStart, long orderEnd, long num) throws Exception {
        JDBCSupport.TransactionWrapper wrap;
        block17: {
            Throwable e22;
            Statement ps;
            Connection conn;
            block16: {
                if (this.trace) {
                    log.trace("Updating paaged references for channel " + channelID + " between " + orderStart + " and " + orderEnd);
                }
                conn = null;
                ps = null;
                wrap = new JDBCSupport.TransactionWrapper(this);
                conn = this.ds.getConnection();
                ps = conn.prepareStatement(this.getSQLStatement("UPDATE_REFS_NOT_PAGED"));
                ps.setLong(1, orderStart);
                ps.setLong(2, orderEnd);
                ps.setLong(3, channelID);
                int rows = this.updateWithRetry((PreparedStatement)ps);
                if (this.trace) {
                    log.trace(JDBCUtil.statementToString(this.getSQLStatement("UPDATE_REFS_NOT_PAGED"), new Long(channelID), new Long(orderStart), new Long(orderEnd)) + " updated " + rows + " rows");
                }
                if ((long)rows != num) {
                    throw new IllegalStateException("Did not update correct number of rows");
                }
                Object var14_10 = null;
                if (ps == null) break block16;
                try {
                    ps.close();
                }
                catch (Throwable e22) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                    break block17;
                }
                catch (Throwable e22) {
                    // empty catch block
                }
                {
                }
            }
            break block17;
            {
                catch (Exception e3) {
                    wrap.exceptionOccurred();
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                Throwable e22;
                Object var14_11 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable e22) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable e22) {
                        // empty catch block
                    }
                }
                wrap.end();
                throw throwable;
            }
        }
        wrap.end();
    }

    /*
     * Loose catch block
     */
    public PersistenceManager.InitialLoadInfo mergeAndLoad(long fromChannelID, long toChannelID, int numberToLoad, long firstPagingOrder, long nextPagingOrder) throws Exception {
        Throwable e222222;
        PersistenceManager.InitialLoadInfo initialLoadInfo;
        Statement ps2;
        JDBCSupport.TransactionWrapper wrap;
        Statement ps;
        Connection conn;
        block38: {
            ArrayList<PersistenceManager.ReferenceInfo> refs;
            block34: {
                Throwable e222222;
                PersistenceManager.InitialLoadInfo initialLoadInfo2;
                block35: {
                    if (this.trace) {
                        log.trace("Merging channel from " + fromChannelID + " to " + toChannelID + " numberToLoad:" + numberToLoad + " firstPagingOrder:" + firstPagingOrder + " nextPagingOrder:" + nextPagingOrder);
                    }
                    conn = null;
                    ps = null;
                    ResultSet rs = null;
                    wrap = new JDBCSupport.TransactionWrapper(this);
                    ps2 = null;
                    conn = this.ds.getConnection();
                    refs = new ArrayList<PersistenceManager.ReferenceInfo>();
                    ps = conn.prepareStatement(this.getSQLStatement("LOAD_REFS"));
                    ps.setLong(1, fromChannelID);
                    rs = ps.executeQuery();
                    int count = 0;
                    boolean arePaged = false;
                    long pageOrd = nextPagingOrder;
                    while (rs.next()) {
                        long msgId = rs.getLong(1);
                        int deliveryCount = rs.getInt(2);
                        long sched = rs.getLong(3);
                        if (count < numberToLoad) {
                            PersistenceManager.ReferenceInfo ri = new PersistenceManager.ReferenceInfo(msgId, deliveryCount, sched);
                            refs.add(ri);
                        }
                        if (ps2 == null) {
                            ps2 = conn.prepareStatement(this.getSQLStatement("UPDATE_PAGE_ORDER"));
                        }
                        if (count < numberToLoad) {
                            ps2.setNull(1, -5);
                            if (this.trace) {
                                log.trace("Set page ord to null");
                            }
                        } else {
                            ps2.setLong(1, pageOrd);
                            if (this.trace) {
                                log.trace("Set page ord to " + pageOrd);
                            }
                            arePaged = true;
                            ++pageOrd;
                        }
                        ps2.setLong(2, msgId);
                        ps2.setLong(3, fromChannelID);
                        int rows = this.updateWithRetry((PreparedStatement)ps2);
                        if (this.trace) {
                            log.trace("Update page ord updated " + rows + " rows");
                        }
                        ++count;
                    }
                    ps.close();
                    ps = conn.prepareStatement(this.getSQLStatement("UPDATE_CHANNEL_ID"));
                    ps.setLong(1, toChannelID);
                    ps.setLong(2, fromChannelID);
                    int rows = this.updateWithRetry((PreparedStatement)ps);
                    if (this.trace) {
                        log.trace("Update channel id updated " + rows + " rows");
                    }
                    if (!arePaged) break block34;
                    initialLoadInfo2 = new PersistenceManager.InitialLoadInfo(new Long(firstPagingOrder), new Long(pageOrd - 1L), refs);
                    Object var27_24 = null;
                    if (ps == null) break block35;
                    try {
                        ps.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                if (ps2 != null) {
                    try {
                        ps2.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                wrap.end();
                return initialLoadInfo2;
            }
            initialLoadInfo = new PersistenceManager.InitialLoadInfo(null, null, refs);
            Object var27_25 = null;
            if (ps == null) break block38;
            try {
                ps.close();
            }
            catch (Throwable e222222) {
                // empty catch block
            }
        }
        if (ps2 != null) {
            try {
                ps2.close();
            }
            catch (Throwable e222222) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable e222222) {
                // empty catch block
            }
        }
        wrap.end();
        return initialLoadInfo;
        catch (Exception e3) {
            try {
                wrap.exceptionOccurred();
                throw e3;
            }
            catch (Throwable throwable) {
                Throwable e222222;
                Object var27_26 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                if (ps2 != null) {
                    try {
                        ps2.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                wrap.end();
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void updatePageOrder(long channelID, List references) throws Exception {
        JDBCSupport.TransactionWrapper wrap;
        block22: {
            Throwable t22;
            Statement psUpdateReference;
            Connection conn;
            block21: {
                block20: {
                    conn = null;
                    psUpdateReference = null;
                    wrap = new JDBCSupport.TransactionWrapper(this);
                    if (this.trace) {
                        log.trace("Updating page order for channel:" + channelID);
                    }
                    conn = this.ds.getConnection();
                    Iterator iter = references.iterator();
                    if (this.usingBatchUpdates) {
                        psUpdateReference = conn.prepareStatement(this.getSQLStatement("UPDATE_PAGE_ORDER"));
                    }
                    while (iter.hasNext()) {
                        MessageReference ref = (MessageReference)iter.next();
                        if (!this.usingBatchUpdates) {
                            psUpdateReference = conn.prepareStatement(this.getSQLStatement("UPDATE_PAGE_ORDER"));
                        }
                        psUpdateReference.setLong(1, ref.getPagingOrder());
                        psUpdateReference.setLong(2, ref.getMessage().getMessageID());
                        psUpdateReference.setLong(3, channelID);
                        if (this.usingBatchUpdates) {
                            psUpdateReference.addBatch();
                            continue;
                        }
                        int rows = this.updateWithRetry((PreparedStatement)psUpdateReference);
                        if (this.trace) {
                            log.trace("Updated " + rows + " rows");
                        }
                        psUpdateReference.close();
                        psUpdateReference = null;
                    }
                    if (!this.usingBatchUpdates) break block20;
                    int[] rowsReference = this.updateWithRetryBatch((PreparedStatement)psUpdateReference);
                    if (this.trace) {
                        this.logBatchUpdate(this.getSQLStatement("UPDATE_PAGE_ORDER"), rowsReference, "updated");
                    }
                    psUpdateReference.close();
                    psUpdateReference = null;
                }
                Object var11_10 = null;
                if (psUpdateReference == null) break block21;
                try {
                    psUpdateReference.close();
                }
                catch (Throwable t22) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                    break block22;
                }
                catch (Throwable t22) {
                    // empty catch block
                }
                {
                }
            }
            break block22;
            {
                catch (Exception e) {
                    wrap.exceptionOccurred();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Throwable t22;
                Object var11_11 = null;
                if (psUpdateReference != null) {
                    try {
                        psUpdateReference.close();
                    }
                    catch (Throwable t22) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable t22) {
                        // empty catch block
                    }
                }
                wrap.end();
                throw throwable;
            }
        }
        wrap.end();
    }

    /*
     * Loose catch block
     */
    public List getPagedReferenceInfos(long channelID, long orderStart, int number) throws Exception {
        Throwable e2222;
        ArrayList<PersistenceManager.ReferenceInfo> arrayList;
        JDBCSupport.TransactionWrapper wrap;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block22: {
            if (this.trace) {
                log.trace("loading message reference info for channel " + channelID + " from " + orderStart + " number " + number);
            }
            ArrayList<PersistenceManager.ReferenceInfo> refs = new ArrayList<PersistenceManager.ReferenceInfo>();
            conn = null;
            ps = null;
            rs = null;
            wrap = new JDBCSupport.TransactionWrapper(this);
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(this.getSQLStatement("LOAD_PAGED_REFS"));
            ps.setLong(1, channelID);
            ps.setLong(2, orderStart);
            ps.setLong(3, orderStart + (long)number - 1L);
            rs = ps.executeQuery();
            long ord = orderStart;
            while (rs.next()) {
                long msgId = rs.getLong(1);
                int deliveryCount = rs.getInt(2);
                int pageOrd = rs.getInt(3);
                long sched = rs.getLong(4);
                if ((long)pageOrd != ord) {
                    throw new IllegalStateException("Unexpected pageOrd: " + pageOrd + " expected: " + ord);
                }
                PersistenceManager.ReferenceInfo ri = new PersistenceManager.ReferenceInfo(msgId, deliveryCount, sched);
                refs.add(ri);
                ++ord;
            }
            if (ord != orderStart + (long)number) {
                throw new IllegalStateException("Didn't load expected number of references, loaded: " + (ord - orderStart) + " expected: " + number);
            }
            arrayList = refs;
            Object var21_17 = null;
            if (rs == null) break block22;
            try {
                rs.close();
            }
            catch (Throwable e2222) {
                // empty catch block
            }
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Throwable e2222) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable e2222) {
                // empty catch block
            }
        }
        wrap.end();
        return arrayList;
        catch (Exception e3) {
            try {
                wrap.exceptionOccurred();
                throw e3;
            }
            catch (Throwable throwable) {
                Throwable e2222;
                Object var21_18 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable e2222) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable e2222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable e2222) {
                        // empty catch block
                    }
                }
                wrap.end();
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public PersistenceManager.InitialLoadInfo loadFromStart(long channelID, int number) throws Exception {
        Throwable e2222;
        PersistenceManager.InitialLoadInfo initialLoadInfo;
        JDBCSupport.TransactionWrapper wrap;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block24: {
            if (this.trace) {
                log.trace("loading initial reference infos for channel " + channelID);
            }
            conn = null;
            ps = null;
            rs = null;
            wrap = new JDBCSupport.TransactionWrapper(this);
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(this.getSQLStatement("SELECT_MIN_MAX_PAGE_ORD"));
            ps.setLong(1, channelID);
            rs = ps.executeQuery();
            rs.next();
            Long minOrdering = new Long(rs.getLong(1));
            if (rs.wasNull()) {
                minOrdering = null;
            }
            Long maxOrdering = new Long(rs.getLong(2));
            if (rs.wasNull()) {
                maxOrdering = null;
            }
            conn.close();
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(this.getSQLStatement("LOAD_UNPAGED_REFS"));
            ps.setLong(1, channelID);
            rs = ps.executeQuery();
            ArrayList<PersistenceManager.ReferenceInfo> refs = new ArrayList<PersistenceManager.ReferenceInfo>();
            int count = 0;
            while (rs.next()) {
                long msgId = rs.getLong(1);
                int deliveryCount = rs.getInt(2);
                long sched = rs.getLong(3);
                PersistenceManager.ReferenceInfo ri = new PersistenceManager.ReferenceInfo(msgId, deliveryCount, sched);
                if (count < number) {
                    refs.add(ri);
                }
                ++count;
            }
            if (count > number) {
                throw new IllegalStateException("Cannot load channel " + channelID + " since the fullSize parameter is too small to load " + " all the required references, fullSize needs to be at least " + count + " it is currently " + number);
            }
            initialLoadInfo = new PersistenceManager.InitialLoadInfo(minOrdering, maxOrdering, refs);
            Object var19_17 = null;
            if (rs == null) break block24;
            try {
                rs.close();
            }
            catch (Throwable e2222) {
                // empty catch block
            }
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Throwable e2222) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable e2222) {
                // empty catch block
            }
        }
        wrap.end();
        return initialLoadInfo;
        catch (Exception e3) {
            try {
                wrap.exceptionOccurred();
                throw e3;
            }
            catch (Throwable throwable) {
                Throwable e2222;
                Object var19_18 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable e2222) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable e2222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable e2222) {
                        // empty catch block
                    }
                }
                wrap.end();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void addReference(long channelID, MessageReference ref, Transaction tx) throws Exception {
        if (tx != null) {
            TransactionCallback callback = this.getCallback(tx);
            callback.addReferenceToAdd(channelID, ref);
        } else {
            Throwable t2222;
            Message m;
            Connection conn;
            Statement psMessage;
            PreparedStatement psReference;
            JDBCSupport.TransactionWrapper wrap;
            block29: {
                wrap = new JDBCSupport.TransactionWrapper(this);
                psReference = null;
                psMessage = null;
                conn = this.ds.getConnection();
                m = ref.getMessage();
                LockMap.instance.obtainLock(m);
                psReference = conn.prepareStatement(this.getSQLStatement("INSERT_MESSAGE_REF"));
                this.addReference(channelID, ref, psReference, false);
                int rows = this.updateWithRetry(psReference);
                if (this.trace) {
                    log.trace("Inserted " + rows + " rows");
                }
                if (!m.isPersisted()) {
                    psMessage = conn.prepareStatement(this.getSQLStatement("INSERT_MESSAGE"));
                    this.storeMessage(m, (PreparedStatement)psMessage);
                    m.setPersisted(true);
                } else {
                    psMessage = conn.prepareStatement(this.getSQLStatement("INC_CHANNEL_COUNT"));
                    this.incrementChannelCount(m, (PreparedStatement)psMessage);
                }
                rows = this.updateWithRetry((PreparedStatement)psMessage);
                if (this.trace) {
                    log.trace("Inserted/updated " + rows + " rows");
                }
                log.trace("message Inserted/updated " + rows + " rows");
                Object var12_12 = null;
                if (psReference == null) break block29;
                try {
                    psReference.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (psMessage != null) {
                try {
                    psMessage.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            try {
                wrap.end();
            }
            finally {
                LockMap.instance.releaseLock(m);
            }
            {
                catch (Exception e) {
                    wrap.exceptionOccurred();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Throwable t2222;
                Object var12_13 = null;
                if (psReference != null) {
                    try {
                        psReference.close();
                    }
                    catch (Throwable t2222) {
                        // empty catch block
                    }
                }
                if (psMessage != null) {
                    try {
                        psMessage.close();
                    }
                    catch (Throwable t2222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable t2222) {
                        // empty catch block
                    }
                }
                try {
                    wrap.end();
                }
                finally {
                    LockMap.instance.releaseLock(m);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void updateDeliveryCount(long channelID, MessageReference ref) throws Exception {
        JDBCSupport.TransactionWrapper wrap;
        block15: {
            Throwable t22;
            Connection conn;
            PreparedStatement psReference;
            block14: {
                block13: {
                    wrap = new JDBCSupport.TransactionWrapper(this);
                    psReference = null;
                    conn = this.ds.getConnection();
                    psReference = conn.prepareStatement(this.getSQLStatement("UPDATE_DELIVERY_COUNT"));
                    psReference.setInt(1, ref.getDeliveryCount());
                    psReference.setLong(2, channelID);
                    psReference.setLong(3, ref.getMessage().getMessageID());
                    int rows = this.updateWithRetry(psReference);
                    if (!this.trace) break block13;
                    log.trace("Updated " + rows + " rows");
                }
                Object var9_8 = null;
                if (psReference == null) break block14;
                try {
                    psReference.close();
                }
                catch (Throwable t22) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                    break block15;
                }
                catch (Throwable t22) {
                    // empty catch block
                }
                {
                }
            }
            break block15;
            {
                catch (Exception e) {
                    wrap.exceptionOccurred();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Throwable t22;
                Object var9_9 = null;
                if (psReference != null) {
                    try {
                        psReference.close();
                    }
                    catch (Throwable t22) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable t22) {
                        // empty catch block
                    }
                }
                wrap.end();
                throw throwable;
            }
        }
        wrap.end();
    }

    /*
     * Exception decompiling
     */
    public void removeReference(long channelID, MessageReference ref, Transaction tx) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public boolean referenceExists(long channelID, long messageID) throws Exception {
        Throwable e222222;
        boolean bl;
        JDBCSupport.TransactionWrapper wrap;
        ResultSet rs;
        PreparedStatement st;
        Connection conn;
        block28: {
            block24: {
                Throwable e222222;
                boolean bl2;
                block25: {
                    conn = null;
                    st = null;
                    rs = null;
                    wrap = new JDBCSupport.TransactionWrapper(this);
                    conn = this.ds.getConnection();
                    st = conn.prepareStatement(this.getSQLStatement("SELECT_EXISTS_REF"));
                    st.setLong(1, channelID);
                    st.setLong(2, messageID);
                    rs = st.executeQuery();
                    if (!rs.next()) break block24;
                    bl2 = true;
                    Object var11_10 = null;
                    if (rs == null) break block25;
                    try {
                        rs.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                wrap.end();
                return bl2;
            }
            bl = false;
            Object var11_11 = null;
            if (rs == null) break block28;
            try {
                rs.close();
            }
            catch (Throwable e222222) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (Throwable e222222) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable e222222) {
                // empty catch block
            }
        }
        wrap.end();
        return bl;
        catch (Exception e3) {
            try {
                wrap.exceptionOccurred();
                throw e3;
            }
            catch (Throwable throwable) {
                Throwable e222222;
                Object var11_12 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                wrap.end();
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean referenceExists(long messageID) throws Exception {
        Throwable e222222;
        boolean bl;
        JDBCSupport.TransactionWrapper wrap;
        ResultSet rs;
        PreparedStatement st;
        Connection conn;
        block28: {
            block24: {
                Throwable e222222;
                boolean bl2;
                block25: {
                    conn = null;
                    st = null;
                    rs = null;
                    wrap = new JDBCSupport.TransactionWrapper(this);
                    conn = this.ds.getConnection();
                    st = conn.prepareStatement(this.getSQLStatement("SELECT_EXISTS_REF_MESSAGE_ID"));
                    st.setLong(1, messageID);
                    rs = st.executeQuery();
                    if (!rs.next()) break block24;
                    bl2 = true;
                    Object var9_9 = null;
                    if (rs == null) break block25;
                    try {
                        rs.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                wrap.end();
                return bl2;
            }
            bl = false;
            Object var9_10 = null;
            if (rs == null) break block28;
            try {
                rs.close();
            }
            catch (Throwable e222222) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (Throwable e222222) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable e222222) {
                // empty catch block
            }
        }
        wrap.end();
        return bl;
        catch (Exception e3) {
            try {
                wrap.exceptionOccurred();
                throw e3;
            }
            catch (Throwable throwable) {
                Throwable e222222;
                Object var9_11 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable e222222) {
                        // empty catch block
                    }
                }
                wrap.end();
                throw throwable;
            }
        }
    }

    public String toString() {
        return "JDBCPersistenceManager[" + Integer.toHexString(this.hashCode()) + "]";
    }

    protected TransactionCallback getCallback(Transaction tx) {
        TransactionCallback callback = (TransactionCallback)tx.getCallback(this);
        if (callback == null) {
            callback = new TransactionCallback(tx);
            tx.addCallback(callback, this);
        }
        return callback;
    }

    protected void orderReferences(List references) {
        Collections.sort(references, MessageOrderComparator.instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void handleBeforeCommit1PC(List refsToAdd, List refsToRemove, Transaction tx) throws Exception {
        Throwable t2222;
        JDBCSupport.TransactionWrapper wrap;
        Statement psDeleteMessage;
        Statement psDecMessage;
        Statement psIncMessage;
        Statement psInsertMessage;
        Statement psReference;
        Connection conn;
        ArrayList<MessageReference> allRefs;
        block81: {
            block80: {
                ChannelRefPair pair;
                boolean batch;
                ChannelRefPair pair2;
                allRefs = new ArrayList<MessageReference>(refsToAdd.size() + refsToRemove.size());
                Iterator i = refsToAdd.iterator();
                while (i.hasNext()) {
                    pair2 = (ChannelRefPair)i.next();
                    allRefs.add(pair2.ref);
                }
                i = refsToRemove.iterator();
                while (i.hasNext()) {
                    pair2 = (ChannelRefPair)i.next();
                    allRefs.add(pair2.ref);
                }
                this.orderReferences(allRefs);
                conn = null;
                psReference = null;
                psInsertMessage = null;
                psIncMessage = null;
                psDecMessage = null;
                psDeleteMessage = null;
                wrap = new JDBCSupport.TransactionWrapper(this);
                conn = this.ds.getConnection();
                this.getLocks(allRefs);
                boolean messageInsertsInBatch = false;
                boolean messageUpdatesInBatch = false;
                boolean bl = batch = this.usingBatchUpdates && refsToAdd.size() > 0;
                if (batch) {
                    psReference = conn.prepareStatement(this.getSQLStatement("INSERT_MESSAGE_REF"));
                    psInsertMessage = conn.prepareStatement(this.getSQLStatement("INSERT_MESSAGE"));
                    psIncMessage = conn.prepareStatement(this.getSQLStatement("INC_CHANNEL_COUNT"));
                }
                Iterator i2 = refsToAdd.iterator();
                while (i2.hasNext()) {
                    int rows;
                    boolean added;
                    pair = (ChannelRefPair)i2.next();
                    MessageReference ref = pair.ref;
                    if (!batch) {
                        psReference = conn.prepareStatement(this.getSQLStatement("INSERT_MESSAGE_REF"));
                    }
                    this.addReference(pair.channelID, ref, (PreparedStatement)psReference, false);
                    if (batch) {
                        psReference.addBatch();
                    } else {
                        int rows2 = this.updateWithRetry((PreparedStatement)psReference);
                        if (this.trace) {
                            log.trace("Inserted " + rows2 + " rows");
                        }
                        psReference.close();
                        psReference = null;
                    }
                    Message m = ref.getMessage();
                    if (!batch) {
                        psInsertMessage = conn.prepareStatement(this.getSQLStatement("INSERT_MESSAGE"));
                        psIncMessage = conn.prepareStatement(this.getSQLStatement("INC_CHANNEL_COUNT"));
                    }
                    if (!m.isPersisted()) {
                        this.storeMessage(m, (PreparedStatement)psInsertMessage);
                        added = true;
                        m.setPersisted(true);
                    } else {
                        this.incrementChannelCount(m, (PreparedStatement)psIncMessage);
                        added = false;
                    }
                    if (batch) {
                        if (added) {
                            psInsertMessage.addBatch();
                            if (this.trace) {
                                log.trace("Message does not already exist so inserting it");
                            }
                            messageInsertsInBatch = true;
                            continue;
                        }
                        if (this.trace) {
                            log.trace("Message already exists so updating count");
                        }
                        psIncMessage.addBatch();
                        messageUpdatesInBatch = true;
                        continue;
                    }
                    if (added) {
                        if (this.trace) {
                            log.trace("Message does not already exist so inserting it");
                        }
                        rows = this.updateWithRetry((PreparedStatement)psInsertMessage);
                        if (this.trace) {
                            log.trace("Inserted " + rows + " rows");
                        }
                    } else {
                        if (this.trace) {
                            log.trace("Message already exists so updating count");
                        }
                        rows = this.updateWithRetry((PreparedStatement)psIncMessage);
                        if (this.trace) {
                            log.trace("Updated " + rows + " rows");
                        }
                    }
                    psInsertMessage.close();
                    psInsertMessage = null;
                    psIncMessage.close();
                    psIncMessage = null;
                }
                if (batch) {
                    int[] rowsMessage;
                    int[] rowsReference = this.updateWithRetryBatch((PreparedStatement)psReference);
                    if (this.trace) {
                        this.logBatchUpdate(this.getSQLStatement("INSERT_MESSAGE_REF"), rowsReference, "inserted");
                    }
                    if (messageInsertsInBatch) {
                        rowsMessage = this.updateWithRetryBatch((PreparedStatement)psInsertMessage);
                        if (this.trace) {
                            this.logBatchUpdate(this.getSQLStatement("INSERT_MESSAGE"), rowsMessage, "inserted");
                        }
                    }
                    if (messageUpdatesInBatch) {
                        rowsMessage = this.updateWithRetryBatch((PreparedStatement)psIncMessage);
                        if (this.trace) {
                            this.logBatchUpdate(this.getSQLStatement("INC_CHANNEL_COUNT"), rowsMessage, "updated");
                        }
                    }
                    psReference.close();
                    psReference = null;
                    psInsertMessage.close();
                    psInsertMessage = null;
                    psIncMessage.close();
                    psIncMessage = null;
                }
                psReference = null;
                psDeleteMessage = null;
                boolean bl2 = batch = this.usingBatchUpdates && refsToRemove.size() > 0;
                if (batch) {
                    psReference = conn.prepareStatement(this.getSQLStatement("DELETE_MESSAGE_REF"));
                    psDeleteMessage = conn.prepareStatement(this.getSQLStatement("DELETE_MESSAGE"));
                    psDecMessage = conn.prepareStatement(this.getSQLStatement("DEC_CHANNEL_COUNT"));
                }
                i2 = refsToRemove.iterator();
                while (i2.hasNext()) {
                    pair = (ChannelRefPair)i2.next();
                    if (!batch) {
                        psReference = conn.prepareStatement(this.getSQLStatement("DELETE_MESSAGE_REF"));
                    }
                    this.removeReference(pair.channelID, pair.ref, (PreparedStatement)psReference);
                    if (batch) {
                        psReference.addBatch();
                    } else {
                        int rows = this.updateWithRetry((PreparedStatement)psReference);
                        if (this.trace) {
                            log.trace("Deleted " + rows + " rows");
                        }
                        psReference.close();
                        psReference = null;
                    }
                    if (!batch) {
                        psDeleteMessage = conn.prepareStatement(this.getSQLStatement("DELETE_MESSAGE"));
                        psDecMessage = conn.prepareStatement(this.getSQLStatement("DEC_CHANNEL_COUNT"));
                    }
                    Message m = pair.ref.getMessage();
                    this.decrementChannelCount(m, (PreparedStatement)psDecMessage);
                    this.removeMessage(m, (PreparedStatement)psDeleteMessage);
                    if (batch) {
                        psDecMessage.addBatch();
                        psDeleteMessage.addBatch();
                        continue;
                    }
                    int rows = this.updateWithRetry((PreparedStatement)psDecMessage);
                    if (this.trace) {
                        log.trace("Updated " + rows + " rows");
                    }
                    rows = this.updateWithRetry((PreparedStatement)psDeleteMessage);
                    if (this.trace) {
                        log.trace("Deleted " + rows + " rows");
                    }
                    psDeleteMessage.close();
                    psDeleteMessage = null;
                    psDecMessage.close();
                    psDecMessage = null;
                }
                if (!batch) break block80;
                int[] rows = this.updateWithRetryBatch((PreparedStatement)psReference);
                if (this.trace) {
                    this.logBatchUpdate(this.getSQLStatement("DELETE_MESSAGE_REF"), rows, "deleted");
                }
                rows = this.updateWithRetryBatch((PreparedStatement)psDecMessage);
                if (this.trace) {
                    this.logBatchUpdate(this.getSQLStatement("DEC_CHANNEL_COUNT"), rows, "updated");
                }
                rows = this.updateWithRetryBatch((PreparedStatement)psDeleteMessage);
                if (this.trace) {
                    this.logBatchUpdate(this.getSQLStatement("DELETE_MESSAGE"), rows, "deleted");
                }
                psReference.close();
                psReference = null;
                psDeleteMessage.close();
                psDeleteMessage = null;
                psDecMessage.close();
                psDecMessage = null;
            }
            Object var22_25 = null;
            if (psReference == null) break block81;
            try {
                psReference.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        if (psInsertMessage != null) {
            try {
                psInsertMessage.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        if (psIncMessage != null) {
            try {
                psIncMessage.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        if (psDecMessage != null) {
            try {
                psDecMessage.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        if (psDeleteMessage != null) {
            try {
                psDeleteMessage.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                if (this.trace) {
                    log.trace("Closing connection");
                }
                conn.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        try {
            wrap.end();
        }
        finally {
            this.releaseLocks(allRefs);
        }
        {
            catch (Exception e) {
                wrap.exceptionOccurred();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Throwable t2222;
            Object var22_26 = null;
            if (psReference != null) {
                try {
                    psReference.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (psInsertMessage != null) {
                try {
                    psInsertMessage.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (psIncMessage != null) {
                try {
                    psIncMessage.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (psDecMessage != null) {
                try {
                    psDecMessage.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (psDeleteMessage != null) {
                try {
                    psDeleteMessage.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    if (this.trace) {
                        log.trace("Closing connection");
                    }
                    conn.close();
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            try {
                wrap.end();
            }
            finally {
                this.releaseLocks(allRefs);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void handleBeforeCommit2PC(List refsToRemove, Transaction tx) throws Exception {
        Throwable t22;
        ArrayList<MessageReference> refs;
        JDBCSupport.TransactionWrapper wrap;
        Statement psDeleteMessage;
        Statement psUpdateMessage;
        Connection conn;
        block33: {
            block32: {
                boolean batch;
                conn = null;
                psUpdateMessage = null;
                psDeleteMessage = null;
                wrap = new JDBCSupport.TransactionWrapper(this);
                refs = new ArrayList<MessageReference>(refsToRemove.size());
                Iterator iter = refsToRemove.iterator();
                while (iter.hasNext()) {
                    ChannelRefPair pair = (ChannelRefPair)iter.next();
                    refs.add(pair.ref);
                }
                this.orderReferences(refs);
                this.getLocks(refs);
                conn = this.ds.getConnection();
                this.commitPreparedTransaction(tx, conn);
                boolean bl = batch = this.usingBatchUpdates && refsToRemove.size() > 0;
                if (batch) {
                    psDeleteMessage = conn.prepareStatement(this.getSQLStatement("DELETE_MESSAGE"));
                    psUpdateMessage = conn.prepareStatement(this.getSQLStatement("DEC_CHANNEL_COUNT"));
                }
                iter = refsToRemove.iterator();
                while (iter.hasNext()) {
                    ChannelRefPair pair = (ChannelRefPair)iter.next();
                    MessageReference ref = pair.ref;
                    if (!batch) {
                        psDeleteMessage = conn.prepareStatement(this.getSQLStatement("DELETE_MESSAGE"));
                        psUpdateMessage = conn.prepareStatement(this.getSQLStatement("DEC_CHANNEL_COUNT"));
                    }
                    Message m = ref.getMessage();
                    this.decrementChannelCount(m, (PreparedStatement)psUpdateMessage);
                    this.removeMessage(m, (PreparedStatement)psDeleteMessage);
                    if (batch) {
                        psUpdateMessage.addBatch();
                        psDeleteMessage.addBatch();
                        continue;
                    }
                    int rows = this.updateWithRetry((PreparedStatement)psUpdateMessage);
                    if (this.trace) {
                        log.trace("Updated " + rows + " rows");
                    }
                    rows = this.updateWithRetry((PreparedStatement)psDeleteMessage);
                    if (this.trace) {
                        log.trace("Deleted " + rows + " rows");
                    }
                    psDeleteMessage.close();
                    psDeleteMessage = null;
                    psUpdateMessage.close();
                    psUpdateMessage = null;
                }
                if (!batch) break block32;
                int[] rows = this.updateWithRetryBatch((PreparedStatement)psUpdateMessage);
                if (this.trace) {
                    this.logBatchUpdate(this.getSQLStatement("DEC_CHANNEL_COUNT"), rows, "updated");
                }
                psUpdateMessage.close();
                psUpdateMessage = null;
                rows = this.updateWithRetryBatch((PreparedStatement)psDeleteMessage);
                if (this.trace) {
                    this.logBatchUpdate(this.getSQLStatement("DELETE_MESSAGE"), rows, "deleted");
                }
                psDeleteMessage.close();
                psDeleteMessage = null;
            }
            Object var15_16 = null;
            if (psDeleteMessage == null) break block33;
            try {
                psDeleteMessage.close();
            }
            catch (Throwable t22) {
                // empty catch block
            }
        }
        if (psUpdateMessage != null) {
            try {
                psUpdateMessage.close();
            }
            catch (Throwable t22) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        try {
            wrap.end();
        }
        finally {
            this.releaseLocks(refs);
        }
        {
            catch (Exception e) {
                wrap.exceptionOccurred();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Throwable t22;
            Object var15_17 = null;
            if (psDeleteMessage != null) {
                try {
                    psDeleteMessage.close();
                }
                catch (Throwable t22) {
                    // empty catch block
                }
            }
            if (psUpdateMessage != null) {
                try {
                    psUpdateMessage.close();
                }
                catch (Throwable t22) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            try {
                wrap.end();
            }
            finally {
                this.releaseLocks(refs);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void handleBeforePrepare(List refsToAdd, List refsToRemove, Transaction tx) throws Exception {
        Throwable t2222;
        JDBCSupport.TransactionWrapper wrap;
        Connection conn;
        Statement psUpdateMessage;
        Statement psInsertMessage;
        Statement psReference;
        ArrayList<MessageReference> refs;
        block58: {
            block57: {
                ChannelRefPair pair;
                refs = new ArrayList<MessageReference>(refsToAdd.size());
                Iterator iter = refsToAdd.iterator();
                while (iter.hasNext()) {
                    ChannelRefPair pair2 = (ChannelRefPair)iter.next();
                    refs.add(pair2.ref);
                }
                this.orderReferences(refs);
                psReference = null;
                psInsertMessage = null;
                psUpdateMessage = null;
                conn = null;
                wrap = new JDBCSupport.TransactionWrapper(this);
                this.getLocks(refs);
                conn = this.ds.getConnection();
                if (!refsToAdd.isEmpty() || !refsToRemove.isEmpty()) {
                    this.addTXRecord(conn, tx);
                }
                iter = refsToAdd.iterator();
                boolean batch = this.usingBatchUpdates && refsToAdd.size() > 1;
                boolean messageInsertsInBatch = false;
                boolean messageUpdatesInBatch = false;
                if (batch) {
                    psReference = conn.prepareStatement(this.getSQLStatement("INSERT_MESSAGE_REF"));
                    psInsertMessage = conn.prepareStatement(this.getSQLStatement("INSERT_MESSAGE"));
                    psUpdateMessage = conn.prepareStatement(this.getSQLStatement("INC_CHANNEL_COUNT"));
                }
                while (iter.hasNext()) {
                    int rows;
                    boolean added;
                    Message m;
                    pair = (ChannelRefPair)iter.next();
                    if (!batch) {
                        psReference = conn.prepareStatement(this.getSQLStatement("INSERT_MESSAGE_REF"));
                    }
                    this.prepareToAddReference(pair.channelID, pair.ref, tx, (PreparedStatement)psReference);
                    if (batch) {
                        psReference.addBatch();
                    } else {
                        int rows2 = this.updateWithRetry((PreparedStatement)psReference);
                        if (this.trace) {
                            log.trace("Inserted " + rows2 + " rows");
                        }
                        psReference.close();
                        psReference = null;
                    }
                    if (!batch) {
                        psInsertMessage = conn.prepareStatement(this.getSQLStatement("INSERT_MESSAGE"));
                        psUpdateMessage = conn.prepareStatement(this.getSQLStatement("INC_CHANNEL_COUNT"));
                    }
                    if (!(m = pair.ref.getMessage()).isPersisted()) {
                        this.storeMessage(m, (PreparedStatement)psInsertMessage);
                        m.setPersisted(true);
                        added = true;
                    } else {
                        this.incrementChannelCount(m, (PreparedStatement)psUpdateMessage);
                        added = false;
                    }
                    if (batch) {
                        if (added) {
                            psInsertMessage.addBatch();
                            messageInsertsInBatch = true;
                            continue;
                        }
                        psUpdateMessage.addBatch();
                        messageUpdatesInBatch = true;
                        continue;
                    }
                    if (added) {
                        rows = this.updateWithRetry((PreparedStatement)psInsertMessage);
                        if (this.trace) {
                            log.trace("Inserted " + rows + " rows");
                        }
                    } else {
                        rows = this.updateWithRetry((PreparedStatement)psUpdateMessage);
                        if (this.trace) {
                            log.trace("Updated " + rows + " rows");
                        }
                    }
                    psInsertMessage.close();
                    psInsertMessage = null;
                    psUpdateMessage.close();
                    psUpdateMessage = null;
                }
                if (batch) {
                    int[] rowsMessage;
                    int[] rowsReference = this.updateWithRetryBatch((PreparedStatement)psReference);
                    if (this.trace) {
                        this.logBatchUpdate(this.getSQLStatement("INSERT_MESSAGE_REF"), rowsReference, "inserted");
                    }
                    if (messageInsertsInBatch) {
                        rowsMessage = this.updateWithRetryBatch((PreparedStatement)psInsertMessage);
                        if (this.trace) {
                            this.logBatchUpdate(this.getSQLStatement("INSERT_MESSAGE"), rowsMessage, "inserted");
                        }
                    }
                    if (messageUpdatesInBatch) {
                        rowsMessage = this.updateWithRetryBatch((PreparedStatement)psUpdateMessage);
                        if (this.trace) {
                            this.logBatchUpdate(this.getSQLStatement("INC_CHANNEL_COUNT"), rowsMessage, "updated");
                        }
                    }
                    psReference.close();
                    psReference = null;
                    psInsertMessage.close();
                    psInsertMessage = null;
                    psUpdateMessage.close();
                    psUpdateMessage = null;
                }
                iter = refsToRemove.iterator();
                boolean bl = batch = this.usingBatchUpdates && refsToRemove.size() > 1;
                if (batch) {
                    psReference = conn.prepareStatement(this.getSQLStatement("UPDATE_MESSAGE_REF"));
                }
                while (iter.hasNext()) {
                    pair = (ChannelRefPair)iter.next();
                    if (!batch) {
                        psReference = conn.prepareStatement(this.getSQLStatement("UPDATE_MESSAGE_REF"));
                    }
                    this.prepareToRemoveReference(pair.channelID, pair.ref, tx, (PreparedStatement)psReference);
                    if (batch) {
                        psReference.addBatch();
                        continue;
                    }
                    int rows = this.updateWithRetry((PreparedStatement)psReference);
                    if (this.trace) {
                        log.trace("updated " + rows + " rows");
                    }
                    psReference.close();
                    psReference = null;
                }
                if (!batch) break block57;
                int[] rows = this.updateWithRetryBatch((PreparedStatement)psReference);
                if (this.trace) {
                    this.logBatchUpdate(this.getSQLStatement("UPDATE_MESSAGE_REF"), rows, "updated");
                }
                psReference.close();
                psReference = null;
            }
            Object var19_21 = null;
            if (psReference == null) break block58;
            try {
                psReference.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        if (psInsertMessage != null) {
            try {
                psInsertMessage.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        if (psUpdateMessage != null) {
            try {
                psUpdateMessage.close();
            }
            catch (Throwable t2222) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        try {
            wrap.end();
        }
        finally {
            this.releaseLocks(refs);
        }
        {
            catch (Exception e) {
                wrap.exceptionOccurred();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Throwable t2222;
            Object var19_22 = null;
            if (psReference != null) {
                try {
                    psReference.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (psInsertMessage != null) {
                try {
                    psInsertMessage.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (psUpdateMessage != null) {
                try {
                    psUpdateMessage.close();
                }
                catch (Throwable t2222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            try {
                wrap.end();
            }
            finally {
                this.releaseLocks(refs);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void handleBeforeRollback(List refsToAdd, Transaction tx) throws Exception {
        Throwable t22;
        ArrayList<MessageReference> refs;
        JDBCSupport.TransactionWrapper wrap;
        Connection conn;
        Statement psUpdateMessage;
        Statement psDeleteMessage;
        block33: {
            block32: {
                boolean batch;
                psDeleteMessage = null;
                psUpdateMessage = null;
                conn = null;
                wrap = new JDBCSupport.TransactionWrapper(this);
                refs = new ArrayList<MessageReference>(refsToAdd.size());
                Iterator iter = refsToAdd.iterator();
                while (iter.hasNext()) {
                    ChannelRefPair pair = (ChannelRefPair)iter.next();
                    refs.add(pair.ref);
                }
                this.orderReferences(refs);
                this.getLocks(refs);
                conn = this.ds.getConnection();
                this.rollbackPreparedTransaction(tx, conn);
                iter = refsToAdd.iterator();
                boolean bl = batch = this.usingBatchUpdates && refsToAdd.size() > 1;
                if (batch) {
                    psDeleteMessage = conn.prepareStatement(this.getSQLStatement("DELETE_MESSAGE"));
                    psUpdateMessage = conn.prepareStatement(this.getSQLStatement("DEC_CHANNEL_COUNT"));
                }
                while (iter.hasNext()) {
                    ChannelRefPair pair = (ChannelRefPair)iter.next();
                    if (!batch) {
                        psDeleteMessage = conn.prepareStatement(this.getSQLStatement("DELETE_MESSAGE"));
                        psUpdateMessage = conn.prepareStatement(this.getSQLStatement("DEC_CHANNEL_COUNT"));
                    }
                    Message m = pair.ref.getMessage();
                    this.decrementChannelCount(m, (PreparedStatement)psUpdateMessage);
                    this.removeMessage(m, (PreparedStatement)psDeleteMessage);
                    if (batch) {
                        psUpdateMessage.addBatch();
                        psDeleteMessage.addBatch();
                        continue;
                    }
                    int rows = this.updateWithRetry((PreparedStatement)psUpdateMessage);
                    if (this.trace) {
                        log.trace("updated " + rows + " rows");
                    }
                    rows = this.updateWithRetry((PreparedStatement)psDeleteMessage);
                    if (this.trace) {
                        log.trace("deleted " + rows + " rows");
                    }
                    psDeleteMessage.close();
                    psDeleteMessage = null;
                    psUpdateMessage.close();
                    psUpdateMessage = null;
                }
                if (!batch) break block32;
                int[] rows = this.updateWithRetryBatch((PreparedStatement)psUpdateMessage);
                if (this.trace) {
                    this.logBatchUpdate(this.getSQLStatement("DEC_CHANNEL_COUNT"), rows, "updated");
                }
                rows = this.updateWithRetryBatch((PreparedStatement)psDeleteMessage);
                if (this.trace) {
                    this.logBatchUpdate(this.getSQLStatement("DELETE_MESSAGE"), rows, "deleted");
                }
                psDeleteMessage.close();
                psDeleteMessage = null;
                psUpdateMessage.close();
                psUpdateMessage = null;
            }
            Object var14_15 = null;
            if (psDeleteMessage == null) break block33;
            try {
                psDeleteMessage.close();
            }
            catch (Throwable t22) {
                // empty catch block
            }
        }
        if (psUpdateMessage != null) {
            try {
                psUpdateMessage.close();
            }
            catch (Throwable t22) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        try {
            wrap.end();
        }
        finally {
            this.releaseLocks(refs);
        }
        {
            catch (Exception e) {
                wrap.exceptionOccurred();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Throwable t22;
            Object var14_16 = null;
            if (psDeleteMessage != null) {
                try {
                    psDeleteMessage.close();
                }
                catch (Throwable t22) {
                    // empty catch block
                }
            }
            if (psUpdateMessage != null) {
                try {
                    psUpdateMessage.close();
                }
                catch (Throwable t22) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            try {
                wrap.end();
            }
            finally {
                this.releaseLocks(refs);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTXRecord(Connection conn, Transaction tx) throws Exception {
        PreparedStatement ps;
        block9: {
            if (this.trace) {
                log.trace("Inserting tx record for " + tx);
            }
            ps = null;
            String statement = "UNDEFINED";
            int rows = -1;
            int formatID = -1;
            try {
                statement = this.getSQLStatement("INSERT_TRANSACTION");
                ps = conn.prepareStatement(statement);
                ps.setLong(1, tx.getId());
                Xid xid = tx.getXid();
                formatID = xid.getFormatId();
                this.setVarBinaryColumn(2, ps, xid.getBranchQualifier());
                ps.setInt(3, formatID);
                this.setVarBinaryColumn(4, ps, xid.getGlobalTransactionId());
                rows = this.updateWithRetry(ps);
                Object var9_8 = null;
                if (!this.trace) break block9;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (this.trace) {
                    String s = JDBCUtil.statementToString(statement, new Long(tx.getId()), "<byte-array>", new Integer(formatID), "<byte-array>");
                    log.trace(s + (rows == -1 ? " failed!" : " inserted " + rows + " row(s)"));
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                throw throwable;
            }
            String s = JDBCUtil.statementToString(statement, new Long(tx.getId()), "<byte-array>", new Integer(formatID), "<byte-array>");
            log.trace(s + (rows == -1 ? " failed!" : " inserted " + rows + " row(s)"));
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (Throwable e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTXRecord(Connection conn, Transaction tx) throws Exception {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.getSQLStatement("DELETE_TRANSACTION"));
            ps.setLong(1, tx.getId());
            int rows = this.updateWithRetry(ps);
            if (this.trace) {
                log.trace(JDBCUtil.statementToString(this.getSQLStatement("DELETE_TRANSACTION"), new Long(tx.getId())) + " removed " + rows + " row(s)");
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (Throwable e) {}
    }

    protected void addReference(long channelID, MessageReference ref, PreparedStatement ps, boolean paged) throws Exception {
        if (this.trace) {
            log.trace("adding " + ref + " to channel " + channelID);
        }
        ps.setLong(1, channelID);
        ps.setLong(2, ref.getMessage().getMessageID());
        ps.setNull(3, -5);
        ps.setString(4, "C");
        ps.setLong(5, this.getOrdering());
        if (paged) {
            ps.setLong(6, ref.getPagingOrder());
        } else {
            ps.setNull(6, -5);
        }
        ps.setInt(7, ref.getDeliveryCount());
        ps.setLong(8, ref.getScheduledDeliveryTime());
    }

    protected void removeReference(long channelID, MessageReference ref, PreparedStatement ps) throws Exception {
        if (this.trace) {
            log.trace("removing " + ref + " from channel " + channelID);
        }
        ps.setLong(1, ref.getMessage().getMessageID());
        ps.setLong(2, channelID);
    }

    protected void prepareToAddReference(long channelID, MessageReference ref, Transaction tx, PreparedStatement ps) throws Exception {
        if (this.trace) {
            log.trace("adding " + ref + " to channel " + channelID + (tx == null ? " non-transactionally" : " on transaction: " + tx));
        }
        ps.setLong(1, channelID);
        ps.setLong(2, ref.getMessage().getMessageID());
        ps.setLong(3, tx.getId());
        ps.setString(4, "+");
        ps.setLong(5, this.getOrdering());
        ps.setNull(6, -5);
        ps.setInt(7, ref.getDeliveryCount());
        ps.setLong(8, ref.getScheduledDeliveryTime());
    }

    protected void prepareToRemoveReference(long channelID, MessageReference ref, Transaction tx, PreparedStatement ps) throws Exception {
        if (this.trace) {
            log.trace("removing " + ref + " from channel " + channelID + (tx == null ? " non-transactionally" : " on transaction: " + tx));
        }
        ps.setLong(1, tx.getId());
        ps.setLong(2, ref.getMessage().getMessageID());
        ps.setLong(3, channelID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void commitPreparedTransaction(Transaction tx, Connection conn) throws Exception {
        PreparedStatement ps = null;
        if (this.trace) {
            log.trace(this + " commitPreparedTransaction, tx= " + tx);
        }
        try {
            ps = conn.prepareStatement(this.getSQLStatement("COMMIT_MESSAGE_REF1"));
            ps.setLong(1, tx.getId());
            int rows = this.updateWithRetry(ps);
            if (this.trace) {
                log.trace(JDBCUtil.statementToString(this.getSQLStatement("COMMIT_MESSAGE_REF1"), new Long(tx.getId())) + " removed " + rows + " row(s)");
            }
            ps.close();
            ps = conn.prepareStatement(this.getSQLStatement("COMMIT_MESSAGE_REF2"));
            ps.setLong(1, tx.getId());
            rows = this.updateWithRetry(ps);
            if (this.trace) {
                log.trace(JDBCUtil.statementToString(this.getSQLStatement("COMMIT_MESSAGE_REF2"), new Long(tx.getId())) + " updated " + rows + " row(s)");
            }
            this.removeTXRecord(conn, tx);
            Object var6_5 = null;
            if (ps == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (ps == null) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ps.close();
            return;
        }
        catch (Throwable e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void rollbackPreparedTransaction(Transaction tx, Connection conn) throws Exception {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.getSQLStatement("ROLLBACK_MESSAGE_REF1"));
            ps.setLong(1, tx.getId());
            int rows = this.updateWithRetry(ps);
            if (this.trace) {
                log.trace(JDBCUtil.statementToString(this.getSQLStatement("ROLLBACK_MESSAGE_REF1"), new Long(tx.getId())) + " removed " + rows + " row(s)");
            }
            ps.close();
            ps = conn.prepareStatement(this.getSQLStatement("ROLLBACK_MESSAGE_REF2"));
            ps.setLong(1, tx.getId());
            rows = this.updateWithRetry(ps);
            if (this.trace) {
                log.trace(JDBCUtil.statementToString(this.getSQLStatement("ROLLBACK_MESSAGE_REF2"), new Long(tx.getId())) + " updated " + rows + " row(s)");
            }
            this.removeTXRecord(conn, tx);
            Object var6_5 = null;
            if (ps == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (ps == null) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ps.close();
            return;
        }
        catch (Throwable e) {}
    }

    protected byte[] mapToBytes(Map map) throws Exception {
        if (map == null || map.isEmpty()) {
            return null;
        }
        int BUFFER_SIZE = 1024;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        DataOutputStream oos = new DataOutputStream(bos);
        StreamUtils.writeMap(oos, map, true);
        oos.close();
        return bos.toByteArray();
    }

    protected HashMap bytesToMap(byte[] bytes) throws Exception {
        if (bytes == null) {
            return new HashMap();
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream dais = new DataInputStream(bis);
        HashMap map = StreamUtils.readMap(dais, true);
        dais.close();
        return map;
    }

    protected void incrementChannelCount(Message m, PreparedStatement ps) throws Exception {
        ps.setLong(1, m.getMessageID());
    }

    protected void decrementChannelCount(Message m, PreparedStatement ps) throws Exception {
        ps.setLong(1, m.getMessageID());
    }

    protected void storeMessage(Message m, PreparedStatement ps) throws Exception {
        ps.setLong(1, m.getMessageID());
        ps.setString(2, m.isReliable() ? "Y" : "N");
        ps.setLong(3, m.getExpiration());
        ps.setLong(4, m.getTimestamp());
        ps.setByte(5, m.getPriority());
        byte[] bytes = this.mapToBytes(((MessageSupport)m).getHeaders());
        if (bytes != null) {
            this.setBytes(ps, 6, bytes);
        } else {
            ps.setNull(6, -4);
        }
        byte[] payload = m.getPayloadAsByteArray();
        if (payload != null) {
            this.setBytes(ps, 7, payload);
        } else {
            ps.setNull(7, -4);
        }
        ps.setInt(8, 1);
        ps.setByte(9, m.getType());
    }

    protected void removeMessage(Message message, PreparedStatement ps) throws Exception {
        ps.setLong(1, message.getMessageID());
    }

    protected void setVarBinaryColumn(int column, PreparedStatement ps, byte[] bytes) throws Exception {
        if (this.usingTrailingByte) {
            byte[] res = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, res, 0, bytes.length);
            res[bytes.length] = 127;
            bytes = res;
        }
        ps.setBytes(column, bytes);
        if (this.trace) {
            log.trace("Setting varbinary column of length: " + bytes.length);
        }
    }

    protected byte[] getVarBinaryColumn(ResultSet rs, int columnIndex) throws Exception {
        byte[] bytes = rs.getBytes(columnIndex);
        if (this.usingTrailingByte) {
            byte[] newBytes = new byte[bytes.length - 1];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length - 1);
            bytes = newBytes;
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBytes(PreparedStatement ps, int columnIndex, byte[] bytes) throws Exception {
        if (this.usingBinaryStream) {
            ByteArrayInputStream is = null;
            try {
                is = new ByteArrayInputStream(bytes);
                ps.setBinaryStream(columnIndex, (InputStream)is, bytes.length);
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        } else {
            this.setVarBinaryColumn(columnIndex, ps, bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getBytes(ResultSet rs, int columnIndex) throws Exception {
        if (this.usingBinaryStream) {
            byte[] byArray;
            ByteArrayOutputStream os;
            block11: {
                InputStream is;
                block9: {
                    byte[] byArray2;
                    block10: {
                        is = null;
                        os = null;
                        int BUFFER_SIZE = 4096;
                        InputStream i = rs.getBinaryStream(columnIndex);
                        if (i != null) break block9;
                        byArray2 = null;
                        Object var10_9 = null;
                        if (is == null) break block10;
                        is.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                    return byArray2;
                }
                try {
                    int b;
                    is = new BufferedInputStream(rs.getBinaryStream(columnIndex), 4096);
                    os = new ByteArrayOutputStream(4096);
                    while ((b = is.read()) != -1) {
                        os.write(b);
                    }
                    byArray = os.toByteArray();
                    Object var10_10 = null;
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (is != null) {
                        is.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                    throw throwable;
                }
                is.close();
            }
            if (os != null) {
                os.close();
            }
            return byArray;
        }
        return this.getVarBinaryColumn(rs, columnIndex);
    }

    protected void getLocks(List refs) {
        Iterator iter = refs.iterator();
        while (iter.hasNext()) {
            MessageReference ref = (MessageReference)iter.next();
            Message m = ref.getMessage();
            LockMap.instance.obtainLock(m);
        }
    }

    protected void releaseLocks(List refs) {
        Iterator iter = refs.iterator();
        while (iter.hasNext()) {
            MessageReference ref = (MessageReference)iter.next();
            Message m = ref.getMessage();
            LockMap.instance.releaseLock(m);
        }
    }

    protected void logBatchUpdate(String name, int[] rows, String action) {
        int count = 0;
        for (int i = 0; i < rows.length; ++i) {
            count += rows[i];
        }
        log.trace("Batch update " + name + ", " + action + " total of " + count + " rows");
    }

    protected int updateWithRetry(PreparedStatement ps) throws Exception {
        return this.updateWithRetry(ps, false)[0];
    }

    protected int[] updateWithRetryBatch(PreparedStatement ps) throws Exception {
        return this.updateWithRetry(ps, true);
    }

    protected Map getDefaultDDLStatements() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("CREATE_MESSAGE_REFERENCE", "CREATE TABLE JBM_MSG_REF (CHANNEL_ID BIGINT, MESSAGE_ID BIGINT, TRANSACTION_ID BIGINT, STATE CHAR(1), ORD BIGINT, PAGE_ORD BIGINT, DELIVERY_COUNT INTEGER, SCHED_DELIVERY BIGINT, PRIMARY KEY(CHANNEL_ID, MESSAGE_ID))");
        map.put("CREATE_IDX_MESSAGE_REF_TX", "CREATE INDEX JBM_MSG_REF_TX ON JBM_MSG_REF (TRANSACTION_ID)");
        map.put("CREATE_IDX_MESSAGE_REF_ORD", "CREATE INDEX JBM_MSG_REF_ORD ON JBM_MSG_REF (ORD)");
        map.put("CREATE_IDX_MESSAGE_REF_PAGE_ORD", "CREATE INDEX JBM_MSG_REF__PAGE_ORD ON JBM_MSG_REF (PAGE_ORD)");
        map.put("CREATE_IDX_MESSAGE_REF_MESSAGE_ID", "CREATE INDEX JBM_MSG_REF_MESSAGE_ID ON JBM_MSG_REF (MESSAGE_ID)");
        map.put("CREATE_IDX_MESSAGE_REF_SCHED_DELIVERY", "CREATE INDEX JBM_MSG_REF_SCHED_DELIVERY ON JBM_MSG_REF (SCHED_DELIVERY)");
        map.put("CREATE_MESSAGE", "CREATE TABLE JBM_MSG (MESSAGE_ID BIGINT, RELIABLE CHAR(1), EXPIRATION BIGINT, TIMESTAMP BIGINT, PRIORITY TINYINT, HEADERS LONGVARBINARY, PAYLOAD LONGVARBINARY, CHANNEL_COUNT INTEGER, TYPE TINYINT, PRIMARY KEY (MESSAGE_ID))");
        map.put("CREATE_TRANSACTION", "CREATE TABLE JBM_TX (TRANSACTION_ID BIGINT, BRANCH_QUAL VARBINARY(254), FORMAT_ID INTEGER, GLOBAL_TXID VARBINARY(254), PRIMARY KEY (TRANSACTION_ID))");
        map.put("CREATE_COUNTER", "CREATE TABLE JBM_COUNTER (NAME VARCHAR(255), NEXT_ID BIGINT, PRIMARY KEY(NAME))");
        return map;
    }

    protected Map getDefaultDMLStatements() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("INSERT_MESSAGE_REF", "INSERT INTO JBM_MSG_REF (CHANNEL_ID, MESSAGE_ID, TRANSACTION_ID, STATE, ORD, PAGE_ORD, DELIVERY_COUNT, SCHED_DELIVERY) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        map.put("DELETE_MESSAGE_REF", "DELETE FROM JBM_MSG_REF WHERE MESSAGE_ID=? AND CHANNEL_ID=? AND STATE='C'");
        map.put("UPDATE_MESSAGE_REF", "UPDATE JBM_MSG_REF SET TRANSACTION_ID=?, STATE='-' WHERE MESSAGE_ID=? AND CHANNEL_ID=? AND STATE='C'");
        map.put("UPDATE_PAGE_ORDER", "UPDATE JBM_MSG_REF SET PAGE_ORD = ? WHERE MESSAGE_ID=? AND CHANNEL_ID=?");
        map.put("COMMIT_MESSAGE_REF1", "UPDATE JBM_MSG_REF SET STATE='C', TRANSACTION_ID = NULL WHERE TRANSACTION_ID=? AND STATE='+'");
        map.put("COMMIT_MESSAGE_REF2", "DELETE FROM JBM_MSG_REF WHERE TRANSACTION_ID=? AND STATE='-'");
        map.put("ROLLBACK_MESSAGE_REF1", "DELETE FROM JBM_MSG_REF WHERE TRANSACTION_ID=? AND STATE='+'");
        map.put("ROLLBACK_MESSAGE_REF2", "UPDATE JBM_MSG_REF SET STATE='C', TRANSACTION_ID = NULL WHERE TRANSACTION_ID=? AND STATE='-'");
        map.put("LOAD_PAGED_REFS", "SELECT MESSAGE_ID, DELIVERY_COUNT, PAGE_ORD, SCHED_DELIVERY FROM JBM_MSG_REF WHERE CHANNEL_ID = ? AND PAGE_ORD BETWEEN ? AND ? ORDER BY PAGE_ORD");
        map.put("LOAD_UNPAGED_REFS", "SELECT MESSAGE_ID, DELIVERY_COUNT, SCHED_DELIVERY FROM JBM_MSG_REF WHERE STATE = 'C' AND CHANNEL_ID = ? AND PAGE_ORD IS NULL ORDER BY ORD");
        map.put("LOAD_REFS", "SELECT MESSAGE_ID, DELIVERY_COUNT, SCHED_DELIVERY FROM JBM_MSG_REF WHERE STATE = 'C' AND CHANNEL_ID = ? ORDER BY ORD");
        map.put("UPDATE_REFS_NOT_PAGED", "UPDATE JBM_MSG_REF SET PAGE_ORD = NULL WHERE PAGE_ORD BETWEEN ? AND ? AND CHANNEL_ID=?");
        map.put("SELECT_MIN_MAX_PAGE_ORD", "SELECT MIN(PAGE_ORD), MAX(PAGE_ORD) FROM JBM_MSG_REF WHERE CHANNEL_ID = ?");
        map.put("SELECT_EXISTS_REF", "SELECT MESSAGE_ID FROM JBM_MSG_REF WHERE CHANNEL_ID = ? AND MESSAGE_ID = ?");
        map.put("SELECT_EXISTS_REF_MESSAGE_ID", "SELECT MESSAGE_ID FROM JBM_MSG_REF WHERE MESSAGE_ID = ?");
        map.put("UPDATE_DELIVERY_COUNT", "UPDATE JBM_MSG_REF SET DELIVERY_COUNT = ? WHERE CHANNEL_ID = ? AND MESSAGE_ID = ?");
        map.put("UPDATE_CHANNEL_ID", "UPDATE JBM_MSG_REF SET CHANNEL_ID = ? WHERE CHANNEL_ID = ?");
        map.put("LOAD_MESSAGES", "SELECT MESSAGE_ID, RELIABLE, EXPIRATION, TIMESTAMP, PRIORITY, HEADERS, PAYLOAD, TYPE FROM JBM_MSG");
        map.put("INSERT_MESSAGE", "INSERT INTO JBM_MSG (MESSAGE_ID, RELIABLE, EXPIRATION, TIMESTAMP, PRIORITY, HEADERS, PAYLOAD, CHANNEL_COUNT, TYPE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        map.put("INC_CHANNEL_COUNT", "UPDATE JBM_MSG SET CHANNEL_COUNT = CHANNEL_COUNT + 1 WHERE MESSAGE_ID=?");
        map.put("DEC_CHANNEL_COUNT", "UPDATE JBM_MSG SET CHANNEL_COUNT = CHANNEL_COUNT - 1 WHERE MESSAGE_ID=?");
        map.put("DELETE_MESSAGE", "DELETE FROM JBM_MSG WHERE MESSAGE_ID=? AND CHANNEL_COUNT = 0");
        map.put("MESSAGE_ID_COLUMN", "MESSAGE_ID");
        map.put("MESSAGE_EXISTS", "SELECT MESSAGE_ID FROM JBM_MSG WHERE MESSAGE_ID = ?");
        map.put("INSERT_TRANSACTION", "INSERT INTO JBM_TX (TRANSACTION_ID, BRANCH_QUAL, FORMAT_ID, GLOBAL_TXID) VALUES(?, ?, ?, ?)");
        map.put("DELETE_TRANSACTION", "DELETE FROM JBM_TX WHERE TRANSACTION_ID = ?");
        map.put("SELECT_PREPARED_TRANSACTIONS", "SELECT TRANSACTION_ID, BRANCH_QUAL, FORMAT_ID, GLOBAL_TXID FROM JBM_TX");
        map.put("SELECT_MESSAGE_ID_FOR_REF", "SELECT MESSAGE_ID, CHANNEL_ID FROM JBM_MSG_REF WHERE TRANSACTION_ID = ? AND STATE = '+' ORDER BY ORD");
        map.put("SELECT_MESSAGE_ID_FOR_ACK", "SELECT MESSAGE_ID, CHANNEL_ID FROM JBM_MSG_REF WHERE TRANSACTION_ID = ? AND STATE = '-' ORDER BY ORD");
        map.put("UPDATE_COUNTER", "UPDATE JBM_COUNTER SET NEXT_ID = ? WHERE NAME=?");
        map.put("SELECT_COUNTER", "SELECT NEXT_ID FROM JBM_COUNTER WHERE NAME=?");
        map.put("INSERT_COUNTER", "INSERT INTO JBM_COUNTER (NAME, NEXT_ID) VALUES (?, ?)");
        map.put("SELECT_ALL_CHANNELS", "SELECT DISTINCT(CHANNEL_ID) FROM JBM_MSG_REF");
        return map;
    }

    private int[] updateWithRetry(PreparedStatement ps, boolean batch) throws Exception {
        int MAX_TRIES = 25;
        int rows = 0;
        int[] rowsArr = null;
        int tries = 0;
        while (true) {
            try {
                if (batch) {
                    rowsArr = ps.executeBatch();
                } else {
                    rows = ps.executeUpdate();
                }
                if (tries <= 0) break;
                log.warn("Update worked after retry");
            }
            catch (SQLException e) {
                log.warn("SQLException caught - assuming deadlock detected, try:" + (tries + 1), e);
                if (++tries == 25) {
                    log.error("Retried " + tries + " times, now giving up");
                    throw new IllegalStateException("Failed to update references");
                }
                log.warn("Trying again after a pause");
                Thread.sleep((long)(Math.random() * 500.0));
                continue;
            }
            break;
        }
        if (batch) {
            return rowsArr;
        }
        return new int[]{rows};
    }

    /*
     * Loose catch block
     */
    private List getMessageChannelPair(String sqlQuery, long transactionId) throws Exception {
        Throwable e2222;
        ArrayList<PersistenceManager.MessageChannelPair> arrayList;
        JDBCSupport.TransactionWrapper wrap;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block23: {
            class Holder {
                long messageId;
                long channelId;

                Holder(long messageId, long channelId) {
                    this.messageId = messageId;
                    this.channelId = channelId;
                }
            }
            Holder holder;
            if (this.trace) {
                log.trace("loading message and channel ids for tx [" + transactionId + "]");
            }
            conn = null;
            ps = null;
            rs = null;
            wrap = new JDBCSupport.TransactionWrapper(this);
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(sqlQuery);
            ps.setLong(1, transactionId);
            rs = ps.executeQuery();
            ArrayList<Holder> holders = new ArrayList<Holder>();
            HashSet<Long> msgIds = new HashSet<Long>();
            while (rs.next()) {
                long messageId = rs.getLong(1);
                long channelId = rs.getLong(2);
                holder = new Holder(messageId, channelId);
                holders.add(holder);
                msgIds.add(new Long(messageId));
                if (!this.trace) continue;
                log.trace("Loaded MsgID: " + messageId + " and ChannelID: " + channelId);
            }
            HashMap<Long, Message> messageMap = new HashMap<Long, Message>();
            List messages = this.getMessages(new ArrayList(msgIds));
            Iterator iter = messages.iterator();
            while (iter.hasNext()) {
                Message msg = (Message)iter.next();
                messageMap.put(new Long(msg.getMessageID()), msg);
            }
            ArrayList<PersistenceManager.MessageChannelPair> returnList = new ArrayList<PersistenceManager.MessageChannelPair>();
            Iterator iter2 = holders.iterator();
            while (iter2.hasNext()) {
                holder = (Holder)iter2.next();
                Message msg = (Message)messageMap.get(new Long(holder.messageId));
                if (msg == null) {
                    throw new IllegalStateException("Cannot find message " + holder.messageId);
                }
                PersistenceManager.MessageChannelPair pair = new PersistenceManager.MessageChannelPair(msg, holder.channelId);
                returnList.add(pair);
            }
            arrayList = returnList;
            Object var18_19 = null;
            if (rs == null) break block23;
            try {
                rs.close();
            }
            catch (Throwable e2222) {
                // empty catch block
            }
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Throwable e2222) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable e2222) {
                // empty catch block
            }
        }
        wrap.end();
        return arrayList;
        catch (Exception e3) {
            try {
                wrap.exceptionOccurred();
                throw e3;
            }
            catch (Throwable throwable) {
                Throwable e2222;
                Object var18_20 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable e2222) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable e2222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable e2222) {
                        // empty catch block
                    }
                }
                wrap.end();
                throw throwable;
            }
        }
    }

    private synchronized long getOrdering() {
        long order = System.currentTimeMillis();
        order <<= 15;
        this.orderCount = this.orderCount == Short.MAX_VALUE ? (short)0 : (short)(this.orderCount + 1);
        return order |= (long)this.orderCount;
    }

    static class MessageOrderComparator
    implements Comparator {
        static MessageOrderComparator instance = new MessageOrderComparator();

        MessageOrderComparator() {
        }

        public int compare(Object o1, Object o2) {
            long id2;
            MessageReference ref1 = (MessageReference)o1;
            MessageReference ref2 = (MessageReference)o2;
            long id1 = ref1.getMessage().getMessageID();
            return id1 < (id2 = ref2.getMessage().getMessageID()) ? -1 : (id1 == id2 ? 0 : 1);
        }
    }

    private class TransactionCallback
    implements TxCallback {
        private Transaction tx;
        private List refsToAdd;
        private List refsToRemove;

        private TransactionCallback(Transaction tx) {
            this.tx = tx;
            this.refsToAdd = new ArrayList();
            this.refsToRemove = new ArrayList();
        }

        private void addReferenceToAdd(long channelId, MessageReference ref) {
            this.refsToAdd.add(new ChannelRefPair(channelId, ref));
        }

        private void addReferenceToRemove(long channelId, MessageReference ref) {
            this.refsToRemove.add(new ChannelRefPair(channelId, ref));
        }

        public void afterCommit(boolean onePhase) {
        }

        public void afterPrepare() {
        }

        public void afterRollback(boolean onePhase) {
        }

        public void beforeCommit(boolean onePhase) throws Exception {
            if (onePhase) {
                JDBCPersistenceManager.this.handleBeforeCommit1PC(this.refsToAdd, this.refsToRemove, this.tx);
            } else {
                JDBCPersistenceManager.this.handleBeforeCommit2PC(this.refsToRemove, this.tx);
            }
        }

        public void beforePrepare() throws Exception {
            JDBCPersistenceManager.this.handleBeforePrepare(this.refsToAdd, this.refsToRemove, this.tx);
        }

        public void beforeRollback(boolean onePhase) throws Exception {
            if (!onePhase) {
                JDBCPersistenceManager.this.handleBeforeRollback(this.refsToAdd, this.tx);
            }
        }

        static /* synthetic */ void access$100(TransactionCallback x0, long x1, MessageReference x2) {
            x0.addReferenceToRemove(x1, x2);
        }
    }

    private static class ChannelRefPair {
        private long channelID;
        private MessageReference ref;

        private ChannelRefPair(long channelID, MessageReference ref) {
            this.channelID = channelID;
            this.ref = ref;
        }
    }
}

