/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.local;

import org.jboss.messaging.core.Delivery;
import org.jboss.messaging.core.DeliveryObserver;
import org.jboss.messaging.core.Filter;
import org.jboss.messaging.core.PagingChannelSupport;
import org.jboss.messaging.core.Queue;
import org.jboss.messaging.core.SimpleDelivery;
import org.jboss.messaging.core.local.RoundRobinPointToPointRouter;
import org.jboss.messaging.core.message.MessageReference;
import org.jboss.messaging.core.plugin.contract.MessageStore;
import org.jboss.messaging.core.plugin.contract.PersistenceManager;
import org.jboss.messaging.core.tx.Transaction;

public class PagingFilteredQueue
extends PagingChannelSupport
implements Queue {
    protected String name;
    protected Filter filter;

    public PagingFilteredQueue(String name, long id, MessageStore ms, PersistenceManager pm, boolean acceptReliableMessages, boolean recoverable, int maxSize, Filter filter) {
        super(id, ms, pm, acceptReliableMessages, recoverable, maxSize);
        this.router = new RoundRobinPointToPointRouter();
        this.name = name;
        this.filter = filter;
    }

    public PagingFilteredQueue(String name, long id, MessageStore ms, PersistenceManager pm, boolean acceptReliableMessages, boolean recoverable, int maxSize, Filter filter, int fullSize, int pageSize, int downCacheSize) {
        super(id, ms, pm, acceptReliableMessages, recoverable, maxSize, fullSize, pageSize, downCacheSize);
        this.router = new RoundRobinPointToPointRouter();
        this.name = name;
        this.filter = filter;
    }

    public boolean isClustered() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Delivery handle(DeliveryObserver sender, MessageReference ref, Transaction tx) {
        if (this.filter == null || this.filter.accept(ref.getMessage())) {
            return super.handle(sender, ref, tx);
        }
        return new SimpleDelivery(this, ref, true, false);
    }

    public String toString() {
        return "Queue[" + this.getChannelID() + "/" + this.getName() + "]";
    }
}

