/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.plugins;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedObjectImpl
implements ManagedObject {
    private static final long serialVersionUID = -2588364350006686542L;
    private String name;
    private Serializable attachment;
    private Set<ManagedProperty> properties;

    public ManagedObjectImpl(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = name;
        this.properties = new HashSet<ManagedProperty>();
    }

    public ManagedObjectImpl(String name, Set<ManagedProperty> properties) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Null properties");
        }
        this.name = name;
        this.properties = properties;
    }

    public ManagedObjectImpl(String name, Set<ManagedProperty> properties, Serializable attachment) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Null properties");
        }
        this.name = name;
        this.properties = properties;
        this.setAttachment(attachment);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getPropertyNames() {
        HashSet<String> result = new HashSet<String>(this.properties.size());
        for (ManagedProperty property : this.properties) {
            result.add(property.getName());
        }
        return result;
    }

    @Override
    public ManagedProperty getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        for (ManagedProperty property : this.properties) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    @Override
    public Set<ManagedProperty> getProperties() {
        return this.properties;
    }

    @Override
    public Serializable getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Serializable attachment) {
        this.attachment = attachment;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ManagedObject)) {
            return false;
        }
        ManagedObject other = (ManagedObject)obj;
        return this.getName().equals(other.getName()) && ((Object)this.getProperties()).equals(other.getProperties());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "ManagedObject{" + this.name + "}";
    }
}

