/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.jms.server.endpoint.DeliveryRecovery;
import org.jboss.jms.server.endpoint.SessionEndpoint;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;

public class SessionRecoverDeliveriesRequest
extends RequestSupport {
    private List dels;

    public SessionRecoverDeliveriesRequest() {
    }

    public SessionRecoverDeliveriesRequest(int objectId, byte version, List dels) {
        super(objectId, 313, version);
        this.dels = dels;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        int size = is.readInt();
        this.dels = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            DeliveryRecovery del = new DeliveryRecovery();
            del.read(is);
            this.dels.add(del);
        }
    }

    public ResponseSupport serverInvoke() throws Exception {
        SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        endpoint.recoverDeliveries(this.dels);
        return null;
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeInt(this.dels.size());
        Iterator iter = this.dels.iterator();
        while (iter.hasNext()) {
            DeliveryRecovery del = (DeliveryRecovery)iter.next();
            del.write(os);
        }
        os.flush();
    }
}

