/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.server.endpoint.ConnectionEndpoint;
import org.jboss.jms.tx.TransactionRequest;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.logging.Logger;

public class ConnectionSendTransactionRequest
extends RequestSupport {
    private static final Logger log = Logger.getLogger(ConnectionSendTransactionRequest.class);
    private TransactionRequest req;
    private boolean checkForDuplicates;

    public ConnectionSendTransactionRequest() {
    }

    public ConnectionSendTransactionRequest(int objectId, byte version, TransactionRequest req, boolean checkForDuplicates) {
        super(objectId, 206, version);
        this.req = req;
        this.checkForDuplicates = checkForDuplicates;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        this.req = new TransactionRequest();
        this.req.read(is);
        this.checkForDuplicates = is.readBoolean();
    }

    public ResponseSupport serverInvoke() throws Exception {
        ConnectionEndpoint endpoint = (ConnectionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        endpoint.sendTransaction(this.req, this.checkForDuplicates);
        return null;
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        this.req.write(os);
        os.writeBoolean(this.checkForDuplicates);
        os.flush();
    }
}

