/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.remoting;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import org.jboss.jms.client.remoting.ClientSocketWrapper;
import org.jboss.logging.Logger;

public class ServerSocketWrapper
extends ClientSocketWrapper {
    private static final Logger log = Logger.getLogger(ServerSocketWrapper.class);
    private boolean trace = log.isTraceEnabled();

    public ServerSocketWrapper(Socket socket) throws Exception {
        super(socket);
    }

    public ServerSocketWrapper(Socket socket, Map metadata, Integer timeout) throws Exception {
        super(socket, metadata, timeout);
    }

    public void close() throws IOException {
        if (this.getSocket() != null) {
            try {
                this.getOutputStream().write(1);
                this.getOutputStream().flush();
                log.debug("wrote CLOSING byte");
            }
            catch (IOException e) {
                log.debug("cannot write CLOSING byte", e);
            }
            super.close();
        }
    }

    public void checkConnection() throws IOException {
        byte ACK = 0;
        try {
            ACK = ((DataInputStream)this.getInputStream()).readByte();
        }
        catch (EOFException eof) {
            if (this.trace) {
                log.trace("socket timeout is set to: " + this.getTimeout());
                log.trace("EOFException waiting on ACK in readByte().");
            }
            throw eof;
        }
        catch (IOException e) {
            log.trace("IOException when reading in ACK", e);
            throw e;
        }
        if (this.trace) {
            log.trace("acknowledge read byte " + Thread.currentThread());
        }
        DataOutputStream out = (DataOutputStream)this.getOutputStream();
        out.writeByte(ACK);
        out.flush();
    }

    public String toString() {
        Socket socket = this.getSocket();
        return "ServerSocketWrapper[" + socket + "." + Integer.toHexString(System.identityHashCode(socket)) + "]";
    }
}

