/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.endpoint;

import java.util.ArrayList;
import java.util.Iterator;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.selector.Selector;
import org.jboss.jms.server.endpoint.BrowserEndpoint;
import org.jboss.jms.server.endpoint.ServerSessionEndpoint;
import org.jboss.jms.util.ExceptionUtil;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.Channel;
import org.jboss.messaging.core.Filter;

public class ServerBrowserEndpoint
implements BrowserEndpoint {
    private static final Logger log = Logger.getLogger(ServerBrowserEndpoint.class);
    private static boolean trace = log.isTraceEnabled();
    private int id;
    private boolean closed;
    private ServerSessionEndpoint session;
    private Channel destination;
    private Filter filter;
    private Iterator iterator;

    ServerBrowserEndpoint(ServerSessionEndpoint session, int id, Channel destination, String messageSelector) throws JMSException {
        this.session = session;
        this.id = id;
        this.destination = destination;
        if (messageSelector != null) {
            this.filter = new Selector(messageSelector);
        }
    }

    public void reset() throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Browser is closed");
            }
            log.debug(this + " is being resetted");
            this.iterator = this.createIterator();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " hasNextMessage");
        }
    }

    public boolean hasNextMessage() throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Browser is closed");
            }
            if (this.iterator == null) {
                this.iterator = this.createIterator();
            }
            boolean has = this.iterator.hasNext();
            if (trace) {
                log.trace(this + (has ? " has" : " DOESN'T have") + " a next message");
            }
            return has;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " hasNextMessage");
        }
    }

    public JBossMessage nextMessage() throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Browser is closed");
            }
            if (this.iterator == null) {
                this.iterator = this.createIterator();
            }
            JBossMessage r = (JBossMessage)this.iterator.next();
            if (trace) {
                log.trace(this + " returning " + r);
            }
            return r;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " nextMessage");
        }
    }

    public JBossMessage[] nextMessageBlock(int maxMessages) throws JMSException {
        if (trace) {
            log.trace(this + " returning next message block of " + maxMessages);
        }
        try {
            if (this.closed) {
                throw new IllegalStateException("Browser is closed");
            }
            if (maxMessages < 2) {
                throw new IllegalArgumentException("maxMessages must be >=2 otherwise use nextMessage");
            }
            if (this.iterator == null) {
                this.iterator = this.createIterator();
            }
            ArrayList<Message> messages = new ArrayList<Message>(maxMessages);
            for (int i = 0; i < maxMessages && this.iterator.hasNext(); ++i) {
                Message m = (Message)this.iterator.next();
                messages.add(m);
            }
            return messages.toArray(new JBossMessage[messages.size()]);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " nextMessageBlock");
        }
    }

    public void close() throws JMSException {
        try {
            this.localClose();
            this.session.removeBrowser(this.id);
            log.debug(this + " closed");
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " close");
        }
    }

    public long closing() throws JMSException {
        return -1L;
    }

    public String toString() {
        return "BrowserEndpoint[" + this.id + "]";
    }

    void localClose() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Browser is already closed");
        }
        this.iterator = null;
        Dispatcher.instance.unregisterTarget(this.id, (Object)this);
        this.closed = true;
    }

    private Iterator createIterator() {
        return this.destination.browse(this.filter).iterator();
    }
}

