/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.endpoint;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.messaging.util.Streamable;

public class DeliveryRecovery
implements Streamable {
    private long deliveryID;
    private long messageID;
    private String queueName;

    public DeliveryRecovery() {
    }

    public DeliveryRecovery(long deliveryID, long messageID, String queueName) {
        this.deliveryID = deliveryID;
        this.messageID = messageID;
        this.queueName = queueName;
    }

    public void read(DataInputStream in) throws Exception {
        this.deliveryID = in.readLong();
        this.messageID = in.readLong();
        this.queueName = in.readUTF();
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeLong(this.deliveryID);
        out.writeLong(this.messageID);
        out.writeUTF(this.queueName);
    }

    public long getDeliveryID() {
        return this.deliveryID;
    }

    public long getMessageID() {
        return this.messageID;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String toString() {
        return "DeliveryRecovery[ID=" + this.deliveryID + ", MID=" + this.messageID + ", Queue name=" + this.queueName + "]";
    }
}

