/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.connectionmanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import org.jboss.jms.server.ConnectionManager;
import org.jboss.jms.server.endpoint.ConnectionEndpoint;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.Util;
import org.jboss.remoting.Client;
import org.jboss.remoting.ClientDisconnectedException;
import org.jboss.remoting.ConnectionListener;

public class SimpleConnectionManager
implements ConnectionManager,
ConnectionListener {
    private static final Logger log = Logger.getLogger(SimpleConnectionManager.class);
    private static boolean trace = log.isTraceEnabled();
    protected Map jmsClients = new HashMap();
    protected Map remotingSessions = new HashMap();
    protected Set activeConnectionEndpoints = new HashSet();

    public synchronized void registerConnection(String jmsClientVMID, String remotingClientSessionID, ConnectionEndpoint endpoint) {
        HashMap<String, ConnectionEndpoint> endpoints = (HashMap<String, ConnectionEndpoint>)this.jmsClients.get(jmsClientVMID);
        if (endpoints == null) {
            endpoints = new HashMap<String, ConnectionEndpoint>();
            this.jmsClients.put(jmsClientVMID, endpoints);
        }
        endpoints.put(remotingClientSessionID, endpoint);
        this.remotingSessions.put(remotingClientSessionID, jmsClientVMID);
        this.activeConnectionEndpoints.add(endpoint);
        log.debug("registered connection " + endpoint + " as " + Util.guidToString(remotingClientSessionID));
    }

    public synchronized ConnectionEndpoint unregisterConnection(String jmsClientVMId, String remotingClientSessionID) {
        Map endpoints = (Map)this.jmsClients.get(jmsClientVMId);
        if (endpoints != null) {
            ConnectionEndpoint e = (ConnectionEndpoint)endpoints.remove(remotingClientSessionID);
            if (e != null) {
                endpoints.remove(e);
                this.activeConnectionEndpoints.remove(e);
            }
            log.debug("unregistered connection " + e + " with remoting session ID " + Util.guidToString(remotingClientSessionID));
            if (endpoints.isEmpty()) {
                this.jmsClients.remove(jmsClientVMId);
            }
            this.remotingSessions.remove(remotingClientSessionID);
            return e;
        }
        return null;
    }

    public synchronized void handleClientFailure(String remotingSessionID, boolean clientToServer) {
        String jmsClientID = (String)this.remotingSessions.get(remotingSessionID);
        if (jmsClientID != null) {
            log.warn(this + " cannot look up remoting session ID " + remotingSessionID);
        }
        log.warn("A problem has been detected " + (clientToServer ? "with the connection to remote client " : "trying to send a message to remote client ") + remotingSessionID + ". It is possible the client has exited without closing " + "its connection(s) or there is a network problem. All connection resources " + "corresponding to that client process will now be removed.");
        Map endpoints = (Map)this.jmsClients.get(jmsClientID);
        if (endpoints != null) {
            ArrayList<ConnectionEndpoint> sces = new ArrayList<ConnectionEndpoint>();
            Iterator i = endpoints.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ConnectionEndpoint sce = (ConnectionEndpoint)entry.getValue();
                sces.add(sce);
            }
            i = sces.iterator();
            while (i.hasNext()) {
                ConnectionEndpoint sce = (ConnectionEndpoint)((Object)i.next());
                try {
                    sce.closing();
                    sce.close();
                    log.debug("cleared up state for connection " + sce);
                }
                catch (JMSException e) {
                    log.error("Failed to close connection", e);
                }
            }
        }
    }

    public synchronized List getActiveConnections() {
        ArrayList list2 = new ArrayList();
        list2.addAll(this.activeConnectionEndpoints);
        return list2;
    }

    public void handleConnectionException(Throwable t, Client client) {
        String remotingSessionID;
        if (t instanceof ClientDisconnectedException) {
            if (trace) {
                log.trace(this + " notified that client " + client + " has disconnected");
            }
            return;
        }
        if (trace) {
            log.trace(this + " detected failure on client " + client, t);
        }
        if ((remotingSessionID = client.getSessionId()) != null) {
            this.handleClientFailure(remotingSessionID, true);
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public synchronized boolean containsRemotingSession(String remotingClientSessionID) {
        return this.remotingSessions.containsKey(remotingClientSessionID);
    }

    public synchronized Map getClients() {
        return Collections.unmodifiableMap(this.jmsClients);
    }

    public String toString() {
        return "ConnectionManager[" + Integer.toHexString(this.hashCode()) + "]";
    }
}

