/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.bridge;

import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.jms.server.bridge.ConnectionFactoryFactory;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.plugin.contract.MessagingComponent;
import org.jboss.tm.TransactionManagerLocator;
import org.jboss.tm.TxManager;

public class Bridge
implements MessagingComponent {
    private static final Logger log = Logger.getLogger(Bridge.class);
    private static boolean trace = log.isTraceEnabled();
    public static final int QOS_AT_MOST_ONCE = 0;
    public static final int QOS_DUPLICATES_OK = 1;
    public static final int QOS_ONCE_AND_ONLY_ONCE = 2;
    private String sourceUsername;
    private String sourcePassword;
    private String targetUsername;
    private String targetPassword;
    private TransactionManager tm;
    private String selector;
    private long failureRetryInterval;
    private int maxRetries;
    private int qualityOfServiceMode;
    private int maxBatchSize;
    private long maxBatchTime;
    private String subName;
    private String clientID;
    private boolean started;
    private LinkedList messages = new LinkedList();
    private Object lock = new Object();
    private ConnectionFactoryFactory sourceCff;
    private ConnectionFactoryFactory targetCff;
    private Connection sourceConn;
    private Connection targetConn;
    private Destination sourceDestination;
    private Destination targetDestination;
    private Session sourceSession;
    private Session targetSession;
    private MessageConsumer consumer;
    private MessageProducer producer;
    private BatchTimeChecker timeChecker;
    private Thread checkerThread;
    private long batchExpiryTime;
    private boolean paused;
    private Transaction tx;
    private boolean failed;
    private boolean usingXA;

    public Bridge() {
    }

    public Bridge(ConnectionFactoryFactory sourceCff, ConnectionFactoryFactory destCff, Destination sourceDestination, Destination targetDestination, String sourceUsername, String sourcePassword, String targetUsername, String targetPassword, String selector, long failureRetryInterval, int maxRetries, int qosMode, int maxBatchSize, long maxBatchTime, String subName, String clientID) {
        this();
        this.sourceCff = sourceCff;
        this.targetCff = destCff;
        this.sourceDestination = sourceDestination;
        this.targetDestination = targetDestination;
        this.sourceUsername = sourceUsername;
        this.sourcePassword = sourcePassword;
        this.targetUsername = targetUsername;
        this.targetPassword = targetPassword;
        this.selector = selector;
        this.failureRetryInterval = failureRetryInterval;
        this.maxRetries = maxRetries;
        this.qualityOfServiceMode = qosMode;
        this.maxBatchSize = maxBatchSize;
        this.maxBatchTime = maxBatchTime;
        this.subName = subName;
        this.clientID = clientID;
        if (trace) {
            log.trace("Created " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized void start() throws Exception {
        void var2_3;
        if (this.started) {
            log.warn("Attempt to start, but is already started");
            return;
        }
        if (trace) {
            log.trace("Starting " + this);
        }
        this.checkParams();
        TransactionManager tm = this.getTm();
        Transaction toResume = null;
        try {
            toResume = tm.suspend();
            boolean ok = this.setupJMSObjects();
        }
        finally {
            if (toResume != null) {
                tm.resume(toResume);
            }
        }
        if (var2_3 != false) {
            this.sourceConn.start();
            this.started = true;
            if (this.maxBatchTime != -1L) {
                if (trace) {
                    log.trace("Starting time checker thread");
                }
                this.timeChecker = new BatchTimeChecker();
                this.checkerThread = new Thread(this.timeChecker);
                this.batchExpiryTime = System.currentTimeMillis() + this.maxBatchTime;
                this.checkerThread.start();
                if (trace) {
                    log.trace("Started time checker thread");
                }
            }
            if (trace) {
                log.trace("Started " + this);
            }
        } else {
            log.warn("Failed to start bridge");
            this.failed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws Exception {
        block22: {
            block21: {
                if (!this.started) {
                    log.warn("Attempt to stop, but is already stopped");
                    return;
                }
                if (trace) {
                    log.trace("Stopping " + this);
                }
                Object object = this.lock;
                synchronized (object) {
                    this.started = false;
                    if (this.checkerThread != null) {
                        this.checkerThread.interrupt();
                    }
                }
                if (this.checkerThread != null) {
                    if (trace) {
                        log.trace("Waiting for checker thread to finish");
                    }
                    this.checkerThread.join();
                    if (trace) {
                        log.trace("Checker thread has finished");
                    }
                }
                if (this.tx != null) {
                    block20: {
                        if (trace) {
                            log.trace("Rolling back remaining tx");
                        }
                        try {
                            this.tx.rollback();
                        }
                        catch (Exception ignore) {
                            if (!trace) break block20;
                            log.trace("Failed to rollback", ignore);
                        }
                    }
                    if (trace) {
                        log.trace("Rolled back remaining tx");
                    }
                }
                try {
                    this.sourceConn.close();
                }
                catch (Exception ignore) {
                    if (!trace) break block21;
                    log.trace("Failed to close source conn", ignore);
                }
            }
            if (this.targetConn != null) {
                try {
                    this.targetConn.close();
                }
                catch (Exception ignore) {
                    if (!trace) break block22;
                    log.trace("Failed to close target conn", ignore);
                }
            }
        }
        if (trace) {
            log.trace("Stopped " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pause() throws Exception {
        if (trace) {
            log.trace("Pausing " + this);
        }
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
            this.sourceConn.stop();
        }
        if (trace) {
            log.trace("Paused " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resume() throws Exception {
        if (trace) {
            log.trace("Resuming " + this);
        }
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            this.sourceConn.start();
        }
        if (trace) {
            log.trace("Resumed " + this);
        }
    }

    public Destination getSourceDestination() {
        return this.sourceDestination;
    }

    public void setSourceDestination(Destination dest) {
        if (this.started) {
            log.warn("Cannot set SourceDestination while bridge is started");
            return;
        }
        this.sourceDestination = dest;
    }

    public Destination getTargetDestination() {
        return this.targetDestination;
    }

    public void setTargetDestination(Destination dest) {
        if (this.started) {
            log.warn("Cannot set TargetDestination while bridge is started");
            return;
        }
        this.targetDestination = dest;
    }

    public String getSourceUsername() {
        return this.sourceUsername;
    }

    public synchronized void setSourceUsername(String name) {
        if (this.started) {
            log.warn("Cannot set SourceUsername while bridge is started");
            return;
        }
        this.sourceUsername = name;
    }

    public synchronized String getSourcePassword() {
        return this.sourcePassword;
    }

    public synchronized void setSourcePassword(String pwd) {
        if (this.started) {
            log.warn("Cannot set SourcePassword while bridge is started");
            return;
        }
        this.sourcePassword = pwd;
    }

    public synchronized String getDestUsername() {
        return this.targetUsername;
    }

    public synchronized void setDestUserName(String name) {
        if (this.started) {
            log.warn("Cannot set DestUserName while bridge is started");
            return;
        }
        this.targetUsername = name;
    }

    public synchronized String getDestPassword() {
        return this.targetPassword;
    }

    public synchronized void setDestPassword(String pwd) {
        if (this.started) {
            log.warn("Cannot set DestPassword while bridge is started");
            return;
        }
        this.targetPassword = pwd;
    }

    public synchronized String getSelector() {
        return this.selector;
    }

    public synchronized void setSelector(String selector) {
        if (this.started) {
            log.warn("Cannot set Selector while bridge is started");
            return;
        }
        this.selector = selector;
    }

    public synchronized long getFailureRetryInterval() {
        return this.failureRetryInterval;
    }

    public synchronized void setFailureRetryInterval(long interval) {
        if (this.started) {
            log.warn("Cannot set FailureRetryInterval while bridge is started");
            return;
        }
        this.failureRetryInterval = interval;
    }

    public synchronized int getMaxRetries() {
        return this.maxRetries;
    }

    public synchronized void setMaxRetries(int retries) {
        if (this.started) {
            log.warn("Cannot set MaxRetries while bridge is started");
            return;
        }
        this.maxRetries = retries;
    }

    public synchronized int getQualityOfServiceMode() {
        return this.qualityOfServiceMode;
    }

    public synchronized void setQualityOfServiceMode(int mode) {
        if (this.started) {
            log.warn("Cannot set QualityOfServiceMode while bridge is started");
            return;
        }
        this.qualityOfServiceMode = mode;
    }

    public synchronized int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public synchronized void setMaxBatchSize(int size) {
        if (this.started) {
            log.warn("Cannot set MaxBatchSize while bridge is started");
            return;
        }
        this.maxBatchSize = size;
    }

    public synchronized long getMaxBatchTime() {
        return this.maxBatchTime;
    }

    public synchronized void setMaxBatchTime(long time) {
        if (this.started) {
            log.warn("Cannot set MaxBatchTime while bridge is started");
            return;
        }
        this.maxBatchTime = time;
    }

    public synchronized String getSubName() {
        return this.subName;
    }

    public synchronized void setSubName(String subname) {
        if (this.started) {
            log.warn("Cannot set SubName while bridge is started");
            return;
        }
        this.subName = subname;
    }

    public synchronized String getClientID() {
        return this.clientID;
    }

    public synchronized void setClientID(String clientID) {
        if (this.started) {
            log.warn("Cannot set ClientID while bridge is started");
            return;
        }
        this.clientID = clientID;
    }

    public synchronized boolean isPaused() {
        return this.paused;
    }

    public synchronized boolean isFailed() {
        return this.failed;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized void setSourceConnectionFactoryFactory(ConnectionFactoryFactory cff) {
        if (this.started) {
            log.warn("Cannot set SourceConnectionFactoryFactory while bridge is started");
            return;
        }
        this.sourceCff = cff;
    }

    public synchronized void setDestConnectionFactoryFactory(ConnectionFactoryFactory cff) {
        if (this.started) {
            log.warn("Cannot set DestConnectionFactoryFactory while bridge is started");
            return;
        }
        this.targetCff = cff;
    }

    private void checkParams() {
        if (this.sourceCff == null) {
            throw new IllegalArgumentException("sourceCfFactory cannot be null");
        }
        if (this.targetCff == null) {
            throw new IllegalArgumentException("destCfFactory cannot be null");
        }
        if (this.sourceDestination == null) {
            throw new IllegalArgumentException("destSource cannot be null");
        }
        if (this.targetDestination == null) {
            throw new IllegalArgumentException("destDest cannot be null");
        }
        if (this.failureRetryInterval < 0L && this.failureRetryInterval != -1L) {
            throw new IllegalArgumentException("failureRetryInterval must be > 0 or -1 to represent no retry");
        }
        if (this.maxRetries < 0 && this.maxRetries != -1) {
            throw new IllegalArgumentException("maxRetries must be >= 0 or -1 to represent infinite retries");
        }
        if (this.failureRetryInterval == -1L && this.maxRetries > 0) {
            throw new IllegalArgumentException("If failureRetryInterval == -1 maxRetries must be 0");
        }
        if (this.maxBatchSize < 1) {
            throw new IllegalArgumentException("maxBatchSize must be >= 1");
        }
        if (this.maxBatchTime < 1L && this.maxBatchTime != -1L) {
            throw new IllegalArgumentException("maxBatchTime must be >= 1 or -1 to represent unlimited batch time");
        }
        if (this.qualityOfServiceMode != 0 && this.qualityOfServiceMode != 1 && this.qualityOfServiceMode != 2) {
            throw new IllegalArgumentException("Invalid quality of service mode " + this.qualityOfServiceMode);
        }
    }

    private void enlistResources(Transaction tx) throws Exception {
        if (trace) {
            log.trace("Enlisting resources in tx");
        }
        XAResource resSource = ((XASession)this.sourceSession).getXAResource();
        tx.enlistResource(resSource);
        XAResource resDest = ((XASession)this.targetSession).getXAResource();
        tx.enlistResource(resDest);
        if (trace) {
            log.trace("Enlisted resources in tx");
        }
    }

    private void delistResources(Transaction tx) throws Exception {
        if (trace) {
            log.trace("Delisting resources from tx");
        }
        XAResource resSource = ((XASession)this.sourceSession).getXAResource();
        tx.delistResource(resSource, 0x4000000);
        XAResource resDest = ((XASession)this.targetSession).getXAResource();
        tx.delistResource(resDest, 0x4000000);
        if (trace) {
            log.trace("Delisted resources from tx");
        }
    }

    private Transaction startTx() throws Exception {
        if (trace) {
            log.trace("Starting JTA transaction");
        }
        TransactionManager tm = this.getTm();
        tm.setTransactionTimeout(315360000);
        tm.begin();
        Transaction tx = tm.getTransaction();
        tm.suspend();
        if (trace) {
            log.trace("Started JTA transaction");
        }
        return tx;
    }

    private TransactionManager getTm() {
        if (this.tm == null) {
            this.tm = TransactionManagerLocator.getInstance().locate();
            if (this.tm == null) {
                throw new IllegalStateException("Cannot locate a transaction manager");
            }
            if (this.tm instanceof TxManager) {
                log.warn("WARNING! The old JBoss transaction manager is being used. This does not have XA transaction recovery functionality. For XA transaction recovery please deploy the JBoss Transactions JTA/JTS implementation.");
            }
        }
        return this.tm;
    }

    private Connection createConnection(String username, String password, ConnectionFactoryFactory cff) throws Exception {
        Connection conn;
        ConnectionFactory cf = cff.createConnectionFactory();
        if (this.qualityOfServiceMode == 2 && !(cf instanceof XAConnectionFactory)) {
            throw new IllegalArgumentException("Connection factory must be XAConnectionFactory");
        }
        if (username == null) {
            if (this.qualityOfServiceMode == 2) {
                if (trace) {
                    log.trace("Creating an XA connection");
                }
                conn = ((XAConnectionFactory)((Object)cf)).createXAConnection();
            } else {
                if (trace) {
                    log.trace("Creating a non XA connection");
                }
                conn = cf.createConnection();
            }
        } else if (this.qualityOfServiceMode == 2) {
            if (trace) {
                log.trace("Creating an XA connection");
            }
            conn = ((XAConnectionFactory)((Object)cf)).createXAConnection(username, password);
        } else {
            if (trace) {
                log.trace("Creating a non XA connection");
            }
            conn = cf.createConnection(username, password);
        }
        return conn;
    }

    private boolean setupJMSObjects() {
        try {
            Session sess;
            boolean sourceAndTargetSameServer = this.sourceCff == this.targetCff;
            this.sourceConn = this.createConnection(this.sourceUsername, this.sourcePassword, this.sourceCff);
            if (!sourceAndTargetSameServer) {
                this.targetConn = this.createConnection(this.targetUsername, this.targetPassword, this.targetCff);
            }
            if (this.clientID != null) {
                this.sourceConn.setClientID(this.clientID);
            }
            if (sourceAndTargetSameServer) {
                sess = this.sourceSession = this.sourceConn.createSession(true, 0);
            } else if (this.qualityOfServiceMode == 2) {
                if (trace) {
                    log.trace("Creating XA source session");
                }
                this.sourceSession = ((XAConnection)this.sourceConn).createXASession();
                sess = ((XASession)this.sourceSession).getSession();
                this.usingXA = true;
            } else {
                if (trace) {
                    log.trace("Creating non XA source session");
                }
                int ackMode = this.qualityOfServiceMode == 0 && this.maxBatchSize == 1 ? 1 : 2;
                sess = this.sourceSession = this.sourceConn.createSession(false, ackMode);
            }
            this.consumer = this.subName == null ? (this.selector == null ? sess.createConsumer(this.sourceDestination) : sess.createConsumer(this.sourceDestination, this.selector, false)) : (this.selector == null ? sess.createDurableSubscriber((Topic)this.sourceDestination, this.subName) : sess.createDurableSubscriber((Topic)this.sourceDestination, this.subName, this.selector, false));
            if (!sourceAndTargetSameServer) {
                if (this.usingXA) {
                    if (trace) {
                        log.trace("Creating XA dest session");
                    }
                    this.targetSession = ((XAConnection)this.targetConn).createXASession();
                    sess = ((XASession)this.targetSession).getSession();
                } else {
                    if (trace) {
                        log.trace("Creating non XA dest session");
                    }
                    boolean manualCommit = this.maxBatchSize == 1;
                    sess = this.targetSession = this.targetConn.createSession(manualCommit, manualCommit ? 0 : 1);
                }
            }
            if (this.usingXA) {
                if (trace) {
                    log.trace("Starting JTA transaction");
                }
                this.tx = this.startTx();
                this.enlistResources(this.tx);
            }
            this.producer = sess.createProducer(this.targetDestination);
            this.consumer.setMessageListener(new SourceListener());
            return true;
        }
        catch (Exception e) {
            log.warn("Failed to set up connections", e);
            this.cleanup();
            return false;
        }
    }

    private void cleanup() {
        if (this.tx != null) {
            try {
                this.delistResources(this.tx);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                this.tx.rollback();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        try {
            this.sourceConn.close();
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            if (this.targetConn != null) {
                this.targetConn.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void pause(long interval) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.failureRetryInterval) {
            try {
                Thread.sleep(this.failureRetryInterval);
            }
            catch (InterruptedException ex) {}
        }
    }

    private boolean setupJMSObjectsWithRetry() {
        if (trace) {
            log.trace("Setting up connections");
        }
        int count = 0;
        while (true) {
            boolean ok;
            if (ok = this.setupJMSObjects()) {
                return true;
            }
            if (this.maxRetries != -1 && ++count == this.maxRetries) break;
            log.warn("Failed to set up connections, will retry after a pause of " + this.failureRetryInterval + " ms");
            this.pause(this.failureRetryInterval);
        }
        return false;
    }

    private void sendBatch() {
        if (trace) {
            log.trace("Sending batch of " + this.messages.size() + " messages");
        }
        if (this.paused) {
            if (trace) {
                log.trace("Paused, so not sending now");
            }
            return;
        }
        try {
            if (this.qualityOfServiceMode == 0 && this.sourceSession.getAcknowledgeMode() == 2) {
                ((Message)this.messages.getLast()).acknowledge();
            }
            Iterator iter = this.messages.iterator();
            Message msg = null;
            while (iter.hasNext()) {
                msg = (Message)iter.next();
                if (trace) {
                    log.trace("Sending message " + msg);
                }
                this.producer.send(msg);
                if (!trace) continue;
                log.trace("Sent message " + msg);
            }
            if (this.qualityOfServiceMode == 1 && this.sourceSession.getAcknowledgeMode() == 2) {
                ((Message)this.messages.getLast()).acknowledge();
            }
            if (this.targetSession != null && this.targetSession.getTransacted() && !this.usingXA) {
                if (trace) {
                    log.trace("Committing target session");
                }
                this.targetSession.commit();
                if (trace) {
                    log.trace("Committed target session");
                }
            }
            if (this.sourceSession.getTransacted() && !this.usingXA) {
                if (trace) {
                    log.trace("Committing source session");
                }
                this.sourceSession.commit();
                if (trace) {
                    log.trace("Committed source session");
                }
            }
            if (this.usingXA) {
                this.delistResources(this.tx);
                if (trace) {
                    log.trace("Committing JTA transaction");
                }
                this.tx.commit();
                if (trace) {
                    log.trace("Committed JTA transaction");
                }
                this.tx = this.startTx();
                this.enlistResources(this.tx);
            }
            this.messages.clear();
        }
        catch (Exception e) {
            log.warn("Failed to send + acknowledge batch, closing JMS objects", e);
            this.handleFailure();
        }
    }

    private void handleFailure() {
        this.failed = true;
        Thread t = new Thread(new FailureHandler());
        t.start();
    }

    private class SourceListener
    implements MessageListener {
        private SourceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message msg) {
            Object object = Bridge.this.lock;
            synchronized (object) {
                if (Bridge.this.failed) {
                    if (trace) {
                        log.trace("Bridge has failed so ignoring message");
                    }
                    return;
                }
                if (trace) {
                    log.trace(this + " received message " + msg);
                }
                Bridge.this.messages.add(msg);
                Bridge.this.batchExpiryTime = System.currentTimeMillis() + Bridge.this.maxBatchTime;
                if (trace) {
                    log.trace(this + " rescheduled batchExpiryTime to " + Bridge.this.batchExpiryTime);
                }
                if (Bridge.this.maxBatchSize != -1 && Bridge.this.messages.size() >= Bridge.this.maxBatchSize) {
                    if (trace) {
                        log.trace(this + " maxBatchSize has been reached so sending batch");
                    }
                    Bridge.this.sendBatch();
                    if (trace) {
                        log.trace(this + " sent batch");
                    }
                }
            }
        }
    }

    private class BatchTimeChecker
    implements Runnable {
        private BatchTimeChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (trace) {
                log.trace(this + " running");
            }
            Object object = Bridge.this.lock;
            synchronized (object) {
                while (Bridge.this.started) {
                    long toWait = Bridge.this.batchExpiryTime - System.currentTimeMillis();
                    if (toWait <= 0L) {
                        if (trace) {
                            log.trace(this + " waited enough");
                        }
                        Object object2 = Bridge.this.lock;
                        synchronized (object2) {
                            if (!Bridge.this.failed && !Bridge.this.messages.isEmpty()) {
                                if (trace) {
                                    log.trace(this + " got some messages so sending batch");
                                }
                                Bridge.this.sendBatch();
                                if (trace) {
                                    log.trace(this + " sent batch");
                                }
                            }
                        }
                        Bridge.this.batchExpiryTime = System.currentTimeMillis() + Bridge.this.maxBatchTime;
                        continue;
                    }
                    try {
                        if (trace) {
                            log.trace(this + " waiting for " + toWait);
                        }
                        Bridge.this.lock.wait(toWait);
                        if (!trace) continue;
                        log.trace(this + " woke up");
                    }
                    catch (InterruptedException e) {
                        if (!trace) continue;
                        log.trace(this + " thread was interrupted");
                    }
                }
                return;
            }
        }
    }

    private class FailureHandler
    implements Runnable {
        private FailureHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Bridge.this.messages.clear();
            Bridge.this.cleanup();
            boolean ok = false;
            if (Bridge.this.maxRetries > 0 || Bridge.this.maxRetries == -1) {
                log.warn("Will retry after a pause of " + Bridge.this.failureRetryInterval + " ms");
                Bridge.this.pause(Bridge.this.failureRetryInterval);
                ok = Bridge.this.setupJMSObjectsWithRetry();
            }
            if (!ok) {
                log.warn("Unable to set up connections, bridge will be stopped");
                try {
                    Bridge.this.stop();
                }
                catch (Exception exception) {}
            } else {
                log.info("Succeeded in reconnecting to servers");
                Object object = Bridge.this.lock;
                synchronized (object) {
                    Bridge.this.failed = false;
                    try {
                        Bridge.this.sourceConn.start();
                    }
                    catch (JMSException e) {
                        log.error("Failed to start source connection", e);
                    }
                }
            }
        }
    }
}

