/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.destination;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.jms.Destination;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.jboss.jms.destination.JBossQueue;
import org.jboss.jms.destination.JBossTemporaryQueue;
import org.jboss.jms.destination.JBossTemporaryTopic;
import org.jboss.jms.destination.JBossTopic;
import org.jboss.jms.referenceable.SerializableObjectRefAddr;

public abstract class JBossDestination
implements Destination,
Serializable {
    private static final long serialVersionUID = -3483274922186827576L;
    private static final byte NULL = 0;
    private static final byte QUEUE = 1;
    private static final byte TOPIC = 2;
    private static final byte TEMP_QUEUE = 3;
    private static final byte TEMP_TOPIC = 4;
    protected String name;
    private int hash;

    public static void writeDestination(DataOutputStream out, Destination dest) throws IOException {
        JBossDestination jb = (JBossDestination)dest;
        if (dest == null) {
            out.writeByte(0);
        } else {
            if (!jb.isTemporary()) {
                if (jb.isQueue()) {
                    out.writeByte(1);
                } else {
                    out.writeByte(2);
                }
            } else if (jb.isQueue()) {
                out.writeByte(3);
            } else {
                out.writeByte(4);
            }
            out.writeUTF(jb.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static JBossDestination readDestination(DataInputStream in) throws IOException {
        void var3_3;
        JBossDestination dest;
        byte b = in.readByte();
        if (b == 0) {
            return null;
        }
        String name = in.readUTF();
        if (b == 1) {
            dest = new JBossQueue(name);
        } else if (b == 2) {
            dest = new JBossTopic(name);
        } else if (b == 3) {
            dest = new JBossTemporaryQueue(name);
        } else if (b == 4) {
            dest = new JBossTemporaryTopic(name);
        } else {
            throw new IllegalStateException("Invalid value:" + b);
        }
        return var3_3;
    }

    public JBossDestination(String name) {
        this.name = name;
    }

    public Reference getReference() throws NamingException {
        return new Reference("org.jboss.jms.destination.JBossDestination", new SerializableObjectRefAddr("JBM-DEST", this), "org.jboss.jms.referenceable.DestinationObjectFactory", null);
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isTopic();

    public abstract boolean isQueue();

    public boolean isTemporary() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JBossDestination)) {
            return false;
        }
        JBossDestination that = (JBossDestination)o;
        if (this.name == null) {
            return this.isTopic() == that.isTopic() && that.name == null;
        }
        return this.isTopic() == that.isTopic() && this.name.equals(that.name);
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int code = 0;
        if (this.name != null) {
            code = this.name.hashCode();
        }
        this.hash = code + (this.isTopic() ? 37 : 71);
        return this.hash;
    }
}

