/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.remoting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionListener;

public class ConsolidatedRemotingConnectionListener
implements ConnectionListener {
    private static final Logger log = Logger.getLogger(ConsolidatedRemotingConnectionListener.class);
    private ConnectionState state;
    private ExceptionListener jmsExceptionListener;
    private List delegateListeners = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnectionException(Throwable throwable, Client client) {
        ExceptionListener jmsExceptionListenerCopy;
        ArrayList delegateListenersCopy = new ArrayList();
        ConsolidatedRemotingConnectionListener consolidatedRemotingConnectionListener = this;
        synchronized (consolidatedRemotingConnectionListener) {
            jmsExceptionListenerCopy = this.jmsExceptionListener;
            Iterator i = this.delegateListeners.iterator();
            while (i.hasNext()) {
                delegateListenersCopy.add(i.next());
            }
        }
        Iterator i = delegateListenersCopy.iterator();
        while (i.hasNext()) {
            ConnectionListener l = (ConnectionListener)i.next();
            try {
                log.debug(this + " forwarding remoting failure \"" + throwable + "\" to " + l);
                l.handleConnectionException(throwable, client);
            }
            catch (Exception e) {
                log.warn("Failed to forward " + throwable + " to " + l, e);
            }
        }
        if (jmsExceptionListenerCopy != null) {
            String msg;
            JMSException jmsException = null;
            if (throwable instanceof Error) {
                msg = "Caught Error on underlying remoting connection";
                log.error(this + ": " + "Caught Error on underlying remoting connection", throwable);
                jmsException = new JMSException("Caught Error on underlying remoting connection: " + throwable.getMessage());
            } else if (throwable instanceof Exception) {
                Exception e = (Exception)throwable;
                jmsException = new JMSException("Failure on underlying remoting connection");
                jmsException.setLinkedException(e);
            } else {
                msg = "Caught Throwable on underlying remoting connection";
                log.error(this + ": " + "Caught Throwable on underlying remoting connection", throwable);
                jmsException = new JMSException("Caught Throwable on underlying remoting connection: " + throwable.getMessage());
            }
            jmsExceptionListenerCopy.onException(jmsException);
        }
    }

    public synchronized boolean addDelegateListener(ConnectionListener l) {
        log.debug(this + " adding delegate listener " + l);
        return this.delegateListeners.add(l);
    }

    public synchronized void addJMSExceptionListener(ExceptionListener jmsExceptionListener) {
        log.debug(this + " adding JMS exception listener " + jmsExceptionListener);
        this.jmsExceptionListener = jmsExceptionListener;
    }

    public synchronized ExceptionListener getJMSExceptionListener() {
        return this.jmsExceptionListener;
    }

    public synchronized void clear() {
        this.jmsExceptionListener = null;
        this.delegateListeners.clear();
        log.debug(this + " cleared");
    }

    public void setConnectionState(ConnectionState state) {
        this.state = state;
    }

    public String toString() {
        if (this.state == null) {
            return "ConsolidatedListener(UNINITIALIZED)";
        }
        return this.state + ".ConsolidatedListener";
    }
}

