/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.remoting;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.Map;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.remoting.ConnectionFactoryCallbackHandler;
import org.jboss.jms.client.remoting.MessageCallbackHandler;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.message.MessageProxy;
import org.jboss.jms.wireformat.ClientDelivery;
import org.jboss.jms.wireformat.ConnectionFactoryUpdate;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.message.Message;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;

public class CallbackManager
implements InvokerCallbackHandler {
    private static final Logger log = Logger.getLogger(CallbackManager.class);
    public static final String JMS_CALLBACK_SUBSYSTEM = "CALLBACK";
    private static boolean trace = log.isTraceEnabled();
    protected static CallbackManager theManager;
    protected Map callbackHandlers = new ConcurrentReaderHashMap();
    protected ConnectionFactoryCallbackHandler connectionfactoryCallbackHandler;

    public void handleCallback(Callback callback) throws HandleCallbackException {
        Object parameter = callback.getParameter();
        if (parameter instanceof ClientDelivery) {
            ClientDelivery dr = (ClientDelivery)parameter;
            Message msg = dr.getMessage();
            MessageProxy proxy = JBossMessage.createThinDelegate(dr.getDeliveryId(), (JBossMessage)msg, dr.getDeliveryCount());
            MessageCallbackHandler handler = (MessageCallbackHandler)this.callbackHandlers.get(new Integer(dr.getConsumerId()));
            if (handler == null) {
                log.warn(this + " callback handler not found, message arrived after consumer is closed. Cancelling it bacdk to queue");
                return;
            }
            try {
                handler.handleMessage(proxy);
            }
            catch (Exception e) {
                log.error("Failed to handle message", e);
                throw new HandleCallbackException(e.getMessage(), e);
            }
        } else if (parameter instanceof ConnectionFactoryUpdate) {
            ConnectionFactoryUpdate viewChange = (ConnectionFactoryUpdate)parameter;
            if (trace) {
                log.trace(this + " receiving cluster view change " + viewChange);
            }
            if (this.connectionfactoryCallbackHandler != null) {
                this.connectionfactoryCallbackHandler.handleMessage(viewChange);
            }
        } else {
            throw new HandleCallbackException("Unknow callback type: " + callback);
        }
    }

    public void registerHandler(int consumerID, MessageCallbackHandler handler) {
        this.callbackHandlers.put(new Integer(consumerID), handler);
    }

    public void setConnectionDelegate(ClientConnectionDelegate connectionDelegate) {
        this.connectionfactoryCallbackHandler = new ConnectionFactoryCallbackHandler(connectionDelegate);
    }

    public MessageCallbackHandler unregisterHandler(int consumerID) {
        return (MessageCallbackHandler)this.callbackHandlers.remove(new Integer(consumerID));
    }

    public String toString() {
        return "CallbackManager[" + Integer.toHexString(this.hashCode()) + "]";
    }
}

