/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import javax.jms.MessageListener;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.remoting.CallbackManager;
import org.jboss.jms.client.remoting.MessageCallbackHandler;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.jms.client.state.ConsumerState;
import org.jboss.jms.client.state.SessionState;
import org.jboss.jms.delegate.ConsumerDelegate;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.util.MessageQueueNameHelper;

public class ConsumerAspect {
    public Object handleCreateConsumerDelegate(Invocation invocation) throws Throwable {
        MethodInvocation mi = (MethodInvocation)invocation;
        ConsumerDelegate consumerDelegate = (ConsumerDelegate)invocation.invokeNext();
        boolean isCC = (Boolean)mi.getArguments()[4];
        SessionState sessionState = (SessionState)((DelegateSupport)invocation.getTargetObject()).getState();
        ConnectionState connectionState = (ConnectionState)sessionState.getParent();
        SessionDelegate sessionDelegate = (SessionDelegate)invocation.getTargetObject();
        ConsumerState consumerState = (ConsumerState)((DelegateSupport)((Object)consumerDelegate)).getState();
        int consumerID = consumerState.getConsumerID();
        int prefetchSize = consumerState.getBufferSize();
        QueuedExecutor sessionExecutor = sessionState.getExecutor();
        int maxDeliveries = consumerState.getMaxDeliveries();
        String queueName = null;
        if (consumerState.getSubscriptionName() != null) {
            queueName = MessageQueueNameHelper.createSubscriptionName(connectionState.getClientID(), consumerState.getSubscriptionName());
        } else if (consumerState.getDestination().isQueue()) {
            queueName = consumerState.getDestination().getName();
        }
        MessageCallbackHandler messageHandler = new MessageCallbackHandler(isCC, sessionState.getAcknowledgeMode(), sessionDelegate, consumerDelegate, consumerID, queueName, prefetchSize, sessionExecutor, maxDeliveries);
        sessionState.addCallbackHandler(messageHandler);
        CallbackManager cm = connectionState.getRemotingConnection().getCallbackManager();
        cm.registerHandler(consumerID, messageHandler);
        consumerState.setMessageCallbackHandler(messageHandler);
        consumerDelegate.changeRate(1.0f);
        return consumerDelegate;
    }

    public Object handleClosing(Invocation invocation) throws Throwable {
        ConsumerState consumerState = this.getState(invocation);
        Long l = (Long)invocation.invokeNext();
        long lastDeliveryId = l;
        consumerState.getMessageCallbackHandler().close(lastDeliveryId);
        SessionState sessionState = (SessionState)consumerState.getParent();
        ConnectionState connectionState = (ConnectionState)sessionState.getParent();
        sessionState.removeCallbackHandler(consumerState.getMessageCallbackHandler());
        CallbackManager cm = connectionState.getRemotingConnection().getCallbackManager();
        cm.unregisterHandler(consumerState.getConsumerID());
        consumerState.getMessageCallbackHandler().cancelBuffer();
        return l;
    }

    public Object handleReceive(Invocation invocation) throws Throwable {
        MethodInvocation mi = (MethodInvocation)invocation;
        Object[] args = mi.getArguments();
        long timeout = args == null || args.length == 0 ? 0L : (Long)args[0];
        return this.getMessageCallbackHandler(invocation).receive(timeout);
    }

    public Object handleReceiveNoWait(Invocation invocation) throws Throwable {
        return this.getMessageCallbackHandler(invocation).receive(-1L);
    }

    public Object handleSetMessageListener(Invocation invocation) throws Throwable {
        MethodInvocation mi = (MethodInvocation)invocation;
        Object[] args = mi.getArguments();
        MessageListener l = (MessageListener)args[0];
        this.getMessageCallbackHandler(invocation).setMessageListener(l);
        return null;
    }

    public MessageListener handleGetMessageListener(Invocation invocation) throws Throwable {
        return this.getMessageCallbackHandler(invocation).getMessageListener();
    }

    public Object handleGetDestination(Invocation invocation) throws Throwable {
        return this.getState(invocation).getDestination();
    }

    public Object handleGetNoLocal(Invocation invocation) throws Throwable {
        return this.getState(invocation).isNoLocal() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object handleGetMessageSelector(Invocation invocation) throws Throwable {
        return this.getState(invocation).getSelector();
    }

    private ConsumerState getState(Invocation inv) {
        return (ConsumerState)((DelegateSupport)inv.getTargetObject()).getState();
    }

    private MessageCallbackHandler getMessageCallbackHandler(Invocation inv) {
        ConsumerState state = (ConsumerState)((DelegateSupport)inv.getTargetObject()).getState();
        return state.getMessageCallbackHandler();
    }
}

