/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import org.jboss.jms.client.JBossSession;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.state.ConsumerState;
import org.jboss.jms.delegate.ConnectionDelegate;
import org.jboss.jms.delegate.ConsumerDelegate;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.message.MessageProxy;
import org.jboss.jms.util.MessageQueueNameHelper;
import org.jboss.logging.Logger;

public class JBossConnectionConsumer
implements ConnectionConsumer,
Runnable {
    private static Logger log = Logger.getLogger(JBossConnectionConsumer.class);
    private static boolean trace = log.isTraceEnabled();
    private static final int TIMEOUT = 20000;
    private ConsumerDelegate cons;
    private SessionDelegate sess;
    private int consumerID;
    private ServerSessionPool serverSessionPool;
    private int maxMessages;
    private volatile boolean closed;
    private Thread internalThread;
    private int id;
    private static SynchronizedInt threadId = new SynchronizedInt(0);
    private int maxDeliveries;
    private String queueName;

    public JBossConnectionConsumer(ConnectionDelegate conn, JBossDestination dest, String subName, String messageSelector, ServerSessionPool sessPool, int maxMessages) throws JMSException {
        this.serverSessionPool = sessPool;
        this.maxMessages = maxMessages;
        if (this.maxMessages < 1) {
            this.maxMessages = 1;
        }
        this.sess = conn.createSessionDelegate(false, 2, false);
        this.cons = this.sess.createConsumerDelegate(dest, messageSelector, false, subName, true);
        ConsumerState state = (ConsumerState)((DelegateSupport)((Object)this.cons)).getState();
        this.consumerID = state.getConsumerID();
        this.maxDeliveries = state.getMaxDeliveries();
        this.queueName = subName != null ? MessageQueueNameHelper.createSubscriptionName(conn.getClientID(), subName) : dest.getName();
        this.id = threadId.increment();
        this.internalThread = new Thread((Runnable)this, "Connection Consumer for dest " + dest + " id=" + this.id);
        this.internalThread.start();
        if (trace) {
            log.trace(this + " created");
        }
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.serverSessionPool;
    }

    public void close() throws JMSException {
        block6: {
            if (trace) {
                log.trace("close " + this);
            }
            this.doClose();
            if (trace) {
                log.trace(this + " Waiting for internal thread to complete");
            }
            try {
                this.internalThread.join(20000L);
                if (this.internalThread.isAlive()) {
                    throw new JMSException(this + " Waited " + 20000 + " ms for internal thread to complete, but it didn't");
                }
            }
            catch (InterruptedException e) {
                if (!trace) break block6;
                log.trace(this + " Thread interrupted while waiting for internal thread to complete");
            }
        }
        if (trace) {
            log.trace("Closed: " + this);
        }
    }

    public void run() {
        if (trace) {
            log.trace("running connection consumer");
        }
        try {
            ArrayList<Message> mesList = new ArrayList<Message>();
            while (true) {
                ServerSession serverSession;
                JBossSession session;
                MessageListener listener;
                if (this.closed) {
                    if (!trace) break;
                    log.trace("Connection consumer is closed, breaking");
                    break;
                }
                if (mesList.isEmpty()) {
                    for (int i = 0; i < this.maxMessages; ++i) {
                        Message m;
                        block27: {
                            if (trace) {
                                log.trace(this + " attempting to get message with receiveNoWait");
                            }
                            m = null;
                            try {
                                m = this.cons.receive(-1L);
                            }
                            catch (JMSException e) {
                                if (this.closed) break block27;
                                throw e;
                            }
                        }
                        if (m == null) {
                            if (!trace) break;
                            log.trace("receiveNoWait did not retrieve any message");
                            break;
                        }
                        if (trace) {
                            log.trace("receiveNoWait got message " + m + " adding to queue");
                        }
                        mesList.add(m);
                    }
                    if (mesList.isEmpty()) {
                        Message m;
                        block28: {
                            if (trace) {
                                log.trace(this + " attempting to get message with blocking receive (no timeout)");
                            }
                            m = null;
                            try {
                                m = this.cons.receive(0L);
                            }
                            catch (JMSException e) {
                                if (this.closed) break block28;
                                throw e;
                            }
                        }
                        if (m != null) {
                            if (trace) {
                                log.trace("receive (no timeout) got message " + m + " adding to queue");
                            }
                            mesList.add(m);
                        } else {
                            if (!trace) break;
                            log.trace("blocking receive returned null, consumer must have closed");
                            break;
                        }
                    }
                }
                if (mesList.isEmpty()) continue;
                if (trace) {
                    log.trace("there are " + mesList.size() + " messages to send to session");
                }
                if ((listener = (session = (JBossSession)(serverSession = this.serverSessionPool.getServerSession()).getSession()).getMessageListener()) == null && trace) {
                    log.trace(this + ": session " + session + " did not have a set MessageListener");
                }
                for (int i = 0; i < mesList.size(); ++i) {
                    MessageProxy m = (MessageProxy)mesList.get(i);
                    session.addAsfMessage(m, this.consumerID, this.queueName, this.maxDeliveries, this.sess);
                    if (!trace) continue;
                    log.trace("added " + m + " to session");
                }
                if (trace) {
                    log.trace(this + " starting serverSession " + serverSession);
                }
                serverSession.start();
                if (trace) {
                    log.trace(this + "'s serverSession processed messages");
                }
                mesList.clear();
            }
            if (trace) {
                log.trace("ConnectionConsumer run() exiting");
            }
        }
        catch (Throwable t) {
            log.warn("Connection consumer closing due to error in listening thread " + this, t);
            try {
                this.doClose();
            }
            catch (JMSException e) {
                log.error("Failed to close connection consumer", e);
            }
        }
    }

    protected synchronized void doClose() throws JMSException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.sess.closing();
        this.sess.close();
        if (trace) {
            log.trace(this + "Closed message handler");
        }
    }

    public String toString() {
        return "JBossConnectionConsumer[" + this.consumerID + ", " + this.id + "]";
    }
}

