/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.jrmp.server;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.MarshalledObject;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.invocation.jrmp.interfaces.JRMPInvokerProxy;
import org.jboss.invocation.jrmp.server.JRMPInvokerMBean;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.net.sockets.DefaultSocketFactory;
import org.jboss.security.SecurityDomain;
import org.jboss.system.Registry;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TransactionPropagationContextUtil;

public class JRMPInvoker
extends RemoteServer
implements Invoker,
JRMPInvokerMBean,
MBeanRegistration {
    static final long serialVersionUID = 3110972460891691492L;
    public static final int ANONYMOUS_PORT = 0;
    protected Logger log;
    protected ServiceMBeanSupport support;
    protected int rmiPort = 0;
    protected RMIClientSocketFactory clientSocketFactory;
    protected RMIServerSocketFactory serverSocketFactory;
    protected String clientSocketFactoryName;
    protected String serverSocketFactoryName;
    protected String serverAddress;
    protected String sslDomain;
    protected RemoteStub invokerStub;
    protected int backlog = 200;
    protected boolean enableClassCaching = false;
    private MBeanServerAction serverAction = new MBeanServerAction();

    public JRMPInvoker() {
        final JRMPInvoker delegate = this;
        this.support = new ServiceMBeanSupport(this.getClass()){

            protected void startService() throws Exception {
                delegate.startService();
            }

            protected void stopService() throws Exception {
                delegate.stopService();
            }

            protected void destroyService() throws Exception {
                delegate.destroyService();
            }
        };
        this.log = this.support.getLog();
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int back) {
        this.backlog = back;
    }

    public boolean getEnableClassCaching() {
        return this.enableClassCaching;
    }

    public void setEnableClassCaching(boolean flag) {
        this.enableClassCaching = flag;
        MarshalledValueInputStream.useClassCache(this.enableClassCaching);
    }

    public String getServerHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public void setRMIObjectPort(int rmiPort) {
        this.rmiPort = rmiPort;
    }

    public int getRMIObjectPort() {
        return this.rmiPort;
    }

    public void setRMIClientSocketFactory(String name) {
        this.clientSocketFactoryName = name;
    }

    public String getRMIClientSocketFactory() {
        return this.clientSocketFactoryName;
    }

    public void setRMIClientSocketFactoryBean(RMIClientSocketFactory bean) {
        this.clientSocketFactory = bean;
    }

    public RMIClientSocketFactory getRMIClientSocketFactoryBean() {
        return this.clientSocketFactory;
    }

    public void setRMIServerSocketFactory(String name) {
        this.serverSocketFactoryName = name;
    }

    public String getRMIServerSocketFactory() {
        return this.serverSocketFactoryName;
    }

    public void setRMIServerSocketFactoryBean(RMIServerSocketFactory bean) {
        this.serverSocketFactory = bean;
    }

    public RMIServerSocketFactory getRMIServerSocketFactoryBean() {
        return this.serverSocketFactory;
    }

    public void setServerAddress(String address) {
        this.serverAddress = address;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setSecurityDomain(String domainName) {
        this.sslDomain = domainName;
    }

    public String getSecurityDomain() {
        return this.sslDomain;
    }

    public Serializable getStub() {
        return this.invokerStub;
    }

    protected void startService() throws Exception {
        this.loadCustomSocketFactories();
        this.log.debug("RMI Port='" + (this.rmiPort == 0 ? "Anonymous" : Integer.toString(this.rmiPort)) + "'");
        this.log.debug("Client SocketFactory='" + (this.clientSocketFactory == null ? "Default" : this.clientSocketFactory.toString()) + "'");
        this.log.debug("Server SocketFactory='" + (this.serverSocketFactory == null ? "Default" : this.serverSocketFactory.toString()) + "'");
        this.log.debug("Server SocketAddr='" + (this.serverAddress == null ? "Default" : this.serverAddress) + "'");
        this.log.debug("SecurityDomain='" + (this.sslDomain == null ? "Default" : this.sslDomain) + "'");
        InitialContext ctx = new InitialContext();
        TransactionPropagationContextUtil.getTPCImporter();
        Invoker delegateInvoker = this.createDelegateInvoker();
        Registry.bind(this.support.getServiceName(), delegateInvoker);
        this.exportCI();
        this.log.debug("Bound JRMP invoker for JMX node");
        ctx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() throws Exception {
        InitialContext ctx = new InitialContext();
        try {
            this.unexportCI();
        }
        finally {
            ctx.close();
        }
        this.clientSocketFactory = null;
        this.serverSocketFactory = null;
        this.invokerStub = null;
    }

    protected void destroyService() throws Exception {
        Registry.unbind(this.support.getServiceName());
    }

    public Object invoke(Invocation invocation) throws Exception {
        ClassLoader oldCl = TCLAction.UTIL.getContextClassLoader();
        ObjectName mbean = null;
        try {
            MarshalledInvocation mi = (MarshalledInvocation)invocation;
            invocation.setTransaction(this.importTPC(mi.getTransactionPropagationContext()));
            mbean = (ObjectName)Registry.lookup(invocation.getObjectName());
            Object obj = this.serverAction.invoke(mbean, "invoke", new Object[]{invocation}, Invocation.INVOKE_SIGNATURE);
            MarshalledObject<Object> marshalledObject = new MarshalledObject<Object>(obj);
            return marshalledObject;
        }
        catch (Exception e) {
            Throwable th = JMXExceptionDecoder.decode(e);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Failed to invoke on mbean: " + mbean, th);
            }
            if (th instanceof Exception) {
                e = (Exception)th;
            }
            throw e;
        }
        finally {
            TCLAction.UTIL.setContextClassLoader(oldCl);
            Thread.interrupted();
        }
    }

    protected Invoker createDelegateInvoker() {
        return new JRMPInvokerProxy(this);
    }

    protected void exportCI() throws Exception {
        this.invokerStub = (RemoteStub)UnicastRemoteObject.exportObject(this, this.rmiPort, this.clientSocketFactory, this.serverSocketFactory);
    }

    protected void unexportCI() throws Exception {
        UnicastRemoteObject.unexportObject(this, true);
    }

    protected void rebind(Context ctx, String name, Object val) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        ctx.rebind(n.get(0), val);
    }

    protected void loadCustomSocketFactories() {
        block19: {
            ClassLoader loader = TCLAction.UTIL.getContextClassLoader();
            if (this.clientSocketFactory == null) {
                try {
                    if (this.clientSocketFactoryName != null) {
                        Class<?> csfClass = loader.loadClass(this.clientSocketFactoryName);
                        this.clientSocketFactory = (RMIClientSocketFactory)csfClass.newInstance();
                    }
                }
                catch (Exception e) {
                    this.log.error("Failed to load client socket factory", e);
                    this.clientSocketFactory = null;
                }
            }
            if (this.serverSocketFactory == null) {
                try {
                    if (this.serverSocketFactoryName != null) {
                        Class<?> ssfClass = loader.loadClass(this.serverSocketFactoryName);
                        this.serverSocketFactory = (RMIServerSocketFactory)ssfClass.newInstance();
                        if (this.serverAddress != null) {
                            try {
                                Class[] parameterTypes = new Class[]{String.class};
                                Method m = ssfClass.getMethod("setBindAddress", parameterTypes);
                                Object[] args = new Object[]{this.serverAddress};
                                m.invoke((Object)this.serverSocketFactory, args);
                            }
                            catch (NoSuchMethodException e) {
                                this.log.warn("Socket factory does not support setBindAddress(String)");
                            }
                            catch (Exception e) {
                                this.log.warn("Failed to setBindAddress=" + this.serverAddress + " on socket factory", e);
                            }
                        }
                        if (this.sslDomain != null) {
                            try {
                                InitialContext ctx = new InitialContext();
                                SecurityDomain domain = (SecurityDomain)ctx.lookup(this.sslDomain);
                                Class[] parameterTypes = new Class[]{SecurityDomain.class};
                                Method m = ssfClass.getMethod("setSecurityDomain", parameterTypes);
                                Object[] args = new Object[]{domain};
                                m.invoke((Object)this.serverSocketFactory, args);
                            }
                            catch (NoSuchMethodException e) {
                                this.log.error("Socket factory does not support setSecurityDomain(SecurityDomain)");
                            }
                            catch (Exception e) {
                                this.log.error("Failed to setSecurityDomain=" + this.sslDomain + " on socket factory", e);
                            }
                        }
                        break block19;
                    }
                    if (this.serverAddress != null) {
                        DefaultSocketFactory defaultFactory = new DefaultSocketFactory(this.backlog);
                        this.serverSocketFactory = defaultFactory;
                        try {
                            defaultFactory.setBindAddress(this.serverAddress);
                        }
                        catch (UnknownHostException e) {
                            this.log.error("Failed to setBindAddress=" + this.serverAddress + " on socket factory", e);
                        }
                    }
                }
                catch (Exception e) {
                    this.log.error("operation failed", e);
                    this.serverSocketFactory = null;
                }
            }
        }
    }

    protected Transaction importTPC(Object tpc) {
        if (tpc != null) {
            return TransactionPropagationContextUtil.importTPC(tpc);
        }
        return null;
    }

    public String getName() {
        return this.support.getName();
    }

    public MBeanServer getServer() {
        return this.support.getServer();
    }

    public int getState() {
        return this.support.getState();
    }

    public String getStateString() {
        return this.support.getStateString();
    }

    public void create() throws Exception {
        this.support.create();
    }

    public void start() throws Exception {
        this.support.start();
    }

    public void stop() {
        this.support.stop();
    }

    public void destroy() {
        this.support.destroy();
    }

    public void jbossInternalLifecycle(String method) throws Exception {
        this.support.jbossInternalLifecycle(method);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return this.support.preRegister(server, name);
    }

    public void postRegister(Boolean registrationDone) {
        this.support.postRegister(registrationDone);
    }

    public void preDeregister() throws Exception {
        this.support.preDeregister();
    }

    public void postDeregister() {
        this.support.postDeregister();
    }

    class MBeanServerAction
    implements PrivilegedExceptionAction {
        private ObjectName target;
        String method;
        Object[] args;
        String[] sig;

        MBeanServerAction() {
        }

        MBeanServerAction(ObjectName target, String method, Object[] args, String[] sig) {
            this.target = target;
            this.method = method;
            this.args = args;
            this.sig = sig;
        }

        public Object run() throws Exception {
            Object rtnValue = JRMPInvoker.this.support.getServer().invoke(this.target, this.method, this.args, this.sig);
            return rtnValue;
        }

        Object invoke(ObjectName target, String method, Object[] args, String[] sig) throws Exception {
            SecurityManager sm = System.getSecurityManager();
            Object rtnValue = null;
            if (sm == null) {
                rtnValue = JRMPInvoker.this.support.getServer().invoke(target, method, args, sig);
            } else {
                try {
                    MBeanServerAction action = new MBeanServerAction(target, method, args, sig);
                    rtnValue = AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    throw ex;
                }
            }
            return rtnValue;
        }
    }

    static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public ClassLoader getContextClassLoader(Thread thread) {
                return thread.getContextClassLoader();
            }

            public void setContextClassLoader(ClassLoader cl) {
                Thread.currentThread().setContextClassLoader(cl);
            }

            public void setContextClassLoader(Thread thread, ClassLoader cl) {
                thread.setContextClassLoader(cl);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){
            private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            };

            public ClassLoader getContextClassLoader() {
                return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
            }

            public ClassLoader getContextClassLoader(final Thread thread) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return thread.getContextClassLoader();
                    }
                });
            }

            public void setContextClassLoader(final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            }

            public void setContextClassLoader(final Thread thread, final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        thread.setContextClassLoader(cl);
                        return null;
                    }
                });
            }
        };

        public ClassLoader getContextClassLoader();

        public ClassLoader getContextClassLoader(Thread var1);

        public void setContextClassLoader(ClassLoader var1);

        public void setContextClassLoader(Thread var1, ClassLoader var2);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static ClassLoader getContextClassLoader() {
                return UTIL.getTCLAction().getContextClassLoader();
            }

            static ClassLoader getContextClassLoader(Thread thread) {
                return UTIL.getTCLAction().getContextClassLoader(thread);
            }

            static void setContextClassLoader(ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(cl);
            }

            static void setContextClassLoader(Thread thread, ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(thread, cl);
            }
        }
    }
}

