/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.logging.Logger;
import org.jboss.tm.TxUtils;

public class StatefulRemoveInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(StatefulRemoveInterceptor.class);
    protected boolean retainIfException;

    public StatefulRemoveInterceptor(boolean removeOnException) {
        this.retainIfException = removeOnException;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object rtn = null;
        try {
            rtn = invocation.invokeNext();
        }
        catch (Throwable t) {
            if (TxUtil.getApplicationException(t.getClass(), invocation) != null && this.retainIfException) {
                throw t;
            }
            this.removeSession(invocation, true);
            throw t;
        }
        this.removeSession(invocation, false);
        return rtn;
    }

    protected void removeSession(Invocation invocation, boolean exceptionThrown) throws Throwable {
        StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
        StatefulBeanContext ctx = (StatefulBeanContext)ejb.getBeanContext();
        if (ctx == null || ctx.isDiscarded() || ctx.isRemoved()) {
            return;
        }
        Object id = ejb.getId();
        StatefulContainer container = (StatefulContainer)ejb.getAdvisor();
        Transaction tx = null;
        try {
            tx = TxUtil.getTransactionManager().getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        if (tx != null && TxUtils.isActive(tx)) {
            try {
                tx.registerSynchronization(new RemoveSynchronization(container, id, !exceptionThrown && this.retainIfException));
            }
            catch (RollbackException e) {
                throw new RuntimeException(e);
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        } else {
            container.getCache().remove(id);
        }
    }

    private static class RemoveSynchronization
    implements Synchronization {
        protected boolean retainIfException;
        private StatefulContainer container;
        private Object id;

        public RemoveSynchronization(StatefulContainer container, Object id, boolean removeOnException) {
            this.container = container;
            this.id = id;
            this.retainIfException = removeOnException;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                StatefulBeanContext ctx = this.container.getCache().get(this.id);
                this.container.invokePreDestroy(ctx);
            }
            catch (Throwable t) {
                if (!this.retainIfException) {
                    this.container.getCache().remove(this.id);
                }
                throw new RuntimeException(t);
            }
            this.container.getCache().remove(this.id);
        }
    }
}

