/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import java.security.CodeSource;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.annotation.security.SecurityDomain;
import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.security.JaccAuthorizationInterceptor;
import org.jboss.ejb3.security.SecurityDomainManager;
import org.jboss.security.RealmMapping;

public class JaccAuthorizationInterceptorFactory
implements AspectFactory {
    public Object createPerVM() {
        throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
    }

    public Object createPerClass(Advisor advisor) {
        try {
            String contextID = (String)advisor.getDefaultMetaData().getMetaData("JACC", "ctx");
            CodeSource ejbCS = advisor.getClazz().getProtectionDomain().getCodeSource();
            String ejbName = ((EJBContainer)advisor).getEjbName();
            JaccAuthorizationInterceptor jai = new JaccAuthorizationInterceptor(ejbName, ejbCS);
            jai.setRealmMapping(this.getSecurityManager(advisor));
            return jai;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
    }

    public String getName() {
        return this.getClass().getName();
    }

    public RealmMapping getSecurityManager(Advisor advisor) {
        Object domain = null;
        Container container = (Container)((Object)advisor);
        try {
            InitialContext ctx = container.getInitialContext();
            SecurityDomain securityAnnotation = (SecurityDomain)advisor.resolveAnnotation(SecurityDomain.class);
            if (securityAnnotation != null) {
                domain = SecurityDomainManager.getSecurityManager(securityAnnotation.value(), ctx);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return (RealmMapping)domain;
    }
}

