/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.util.Properties;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.jboss.cache.Version;

public abstract class TransactionalCacheFactory {
    public static TransactionalCacheFactory getFactory(Properties hibernateConfig) throws CacheException {
        String factoryClass = null;
        short version = Version.getVersionShort();
        if (version < Version.getVersionShort((String)"2.0.0.GA") && version > 0) {
            throw new IllegalStateException("Cannot create factory for JBC 1.x");
        }
        factoryClass = "org.jboss.ejb3.entity.JBCCacheFactory";
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(factoryClass);
            TransactionalCacheFactory factory = (TransactionalCacheFactory)clazz.newInstance();
            factory.configure(hibernateConfig);
            return factory;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public abstract Cache buildCache(String var1, Properties var2) throws CacheException;

    protected abstract void configure(Properties var1);

    public abstract boolean isOptimistic();
}

