/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
import org.jboss.virtual.plugins.vfs.helpers.SuffixesExcludeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBoss5DeploymentUnit
implements DeploymentUnit {
    private org.jboss.deployers.spi.deployer.DeploymentUnit unit;
    private InterceptorInfoRepository interceptorInfoRepository = new InterceptorInfoRepository();
    private Map defaultPersistenceProperties;

    public JBoss5DeploymentUnit(org.jboss.deployers.spi.deployer.DeploymentUnit unit) {
        this.unit = unit;
    }

    @Override
    public VirtualFile getRootFile() {
        return this.unit.getDeploymentContext().getRoot();
    }

    @Override
    public URL getRelativeURL(String jar) {
        try {
            return new URL(jar);
        }
        catch (MalformedURLException e) {
            try {
                if (jar.startsWith("..")) {
                    if (this.getUrl() == null) {
                        throw new RuntimeException("relative <jar-file> not allowed when standalone deployment unit is used");
                    }
                    String tmpjar = jar.substring(3);
                    VirtualFile vf = this.unit.getDeploymentContext().getRoot().getParent().findChild(tmpjar);
                    return vf.toURL();
                }
                File fp = new File(jar);
                return fp.toURL();
            }
            catch (Exception e1) {
                throw new RuntimeException("could not find relative path: " + jar, e1);
            }
        }
    }

    URL extractDescriptorUrl(String resource) {
        try {
            VirtualFile vf = this.unit.getMetaDataFile(resource);
            if (vf == null) {
                return null;
            }
            return vf.toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URL getPersistenceXml() {
        return this.extractDescriptorUrl("persistence.xml");
    }

    @Override
    public URL getEjbJarXml() {
        return this.extractDescriptorUrl("ejb-jar.xml");
    }

    @Override
    public URL getJbossXml() {
        return this.extractDescriptorUrl("jboss.xml");
    }

    @Override
    public VirtualFile getMetaDataFile(String name) {
        return this.unit.getMetaDataFile(name);
    }

    @Override
    public List<Class> getClasses() {
        return null;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.unit.getClassLoader();
    }

    @Override
    public ClassLoader getResourceLoader() {
        return this.unit.getClassLoader();
    }

    @Override
    public String getShortName() {
        return this.unit.getDeploymentContext().getRoot().getName();
    }

    @Override
    public URL getUrl() {
        try {
            return this.unit.getDeploymentContext().getRoot().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDefaultEntityManagerName() {
        String url = this.getUrl().toString();
        String name = url.substring(url.lastIndexOf(47) + 1, url.lastIndexOf(46));
        return name;
    }

    @Override
    public Map getDefaultPersistenceProperties() {
        return this.defaultPersistenceProperties;
    }

    public void setDefaultPersistenceProperties(Map defaultPersistenceProperties) {
        this.defaultPersistenceProperties = defaultPersistenceProperties;
    }

    @Override
    public Hashtable getJndiProperties() {
        return null;
    }

    @Override
    public InterceptorInfoRepository getInterceptorInfoRepository() {
        return this.interceptorInfoRepository;
    }

    @Override
    public List<VirtualFile> getResources(VirtualFileFilter filter) {
        VisitorAttributes va = new VisitorAttributes();
        va.setLeavesOnly(true);
        SuffixesExcludeFilter noJars = new SuffixesExcludeFilter(JarUtils.getSuffixes());
        va.setRecurseFilter(noJars);
        FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, va);
        List classpath = this.unit.getDeploymentContext().getClassPath();
        if (classpath != null) {
            for (VirtualFile vf : classpath) {
                try {
                    vf.visit(visitor);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return visitor.getMatched();
    }
}

