/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.management.MBeanServer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.deployers.plugins.deployers.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.MCKernelAbstraction;
import org.jboss.ejb3.clientmodule.ClientENCInjectionContainer;
import org.jboss.ejb3.metamodel.ApplicationClientDD;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3ClientDeployer
extends AbstractSimpleRealDeployer<ApplicationClientDD> {
    private static final Logger log = Logger.getLogger(Ejb3ClientDeployer.class);
    private Kernel kernel;
    private MBeanServer server;

    public Ejb3ClientDeployer() {
        super(ApplicationClientDD.class);
        this.setRelativeOrder(7001);
    }

    public void deploy(DeploymentUnit unit, ApplicationClientDD metaData) throws DeploymentException {
        log.debug("deploy " + unit.getName());
        String appClientName = this.getJndiName(unit, metaData);
        try {
            InitialContext iniCtx = new InitialContext();
            Context encCtx = Util.createSubcontext((Context)iniCtx, appClientName);
            log.debug("Creating client ENC binding under: " + appClientName);
            String mainClassName = this.getMainClassName(unit, true);
            Class<?> mainClass = this.loadClass(unit, mainClassName);
            ClientENCInjectionContainer container = new ClientENCInjectionContainer(unit, metaData, mainClass, appClientName, unit.getClassLoader(), encCtx);
            unit.addAttachment(ClientENCInjectionContainer.class, (Object)container);
            this.getKernelAbstraction().install(container.getObjectName().getCanonicalName(), container.getDependencyPolicy(), container);
        }
        catch (Exception e) {
            log.error("Could not deploy " + unit.getName(), e);
            this.undeploy(unit, metaData);
            throw new DeploymentException("Could not deploy " + unit.getName(), (Throwable)e);
        }
    }

    private String getJndiName(DeploymentUnit unit, ApplicationClientDD dd) {
        String jndiName = dd.getJndiName();
        if (jndiName != null) {
            return jndiName;
        }
        String shortName = unit.getDeploymentContext().getRoot().getName();
        if (shortName.endsWith(".jar/")) {
            jndiName = shortName.substring(0, shortName.length() - 5);
        } else if (shortName.endsWith(".jar")) {
            jndiName = shortName.substring(0, shortName.length() - 4);
        } else {
            throw new IllegalStateException("Expected either '.jar' or '.jar/' at the end of " + shortName);
        }
        return jndiName;
    }

    private KernelAbstraction getKernelAbstraction() {
        return new MCKernelAbstraction(this.kernel, this.server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMainClassName(DeploymentUnit unit, boolean fail) throws Exception {
        VirtualFile file = unit.getMetaDataFile("MANIFEST.MF");
        log.trace("parsing " + file);
        String mainClassName = "org.jboss.client.AppClientMain";
        if (file != null) {
            try {
                Manifest mf;
                InputStream is = file.openStream();
                try {
                    mf = new Manifest(is);
                }
                finally {
                    is.close();
                }
                Attributes attrs = mf.getMainAttributes();
                String className = attrs.getValue(Attributes.Name.MAIN_CLASS);
                if (className != null) {
                    mainClassName = className;
                }
            }
            finally {
                file.close();
            }
        }
        return mainClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClass(DeploymentUnit unit, String className) throws ClassNotFoundException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(unit.getClassLoader());
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            return clazz;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public void setMbeanServer(MBeanServer server) {
        this.server = server;
    }

    public void undeploy(DeploymentUnit unit, ApplicationClientDD metaData) {
        log.debug("undeploy " + unit.getName());
        ClientENCInjectionContainer container = (ClientENCInjectionContainer)unit.getAttachment(ClientENCInjectionContainer.class);
        if (container != null) {
            this.getKernelAbstraction().uninstall(container.getObjectName().getCanonicalName());
        }
        String jndiName = this.getJndiName(unit, metaData);
        log.debug("Removing client ENC from: " + jndiName);
        try {
            InitialContext iniCtx = new InitialContext();
            Util.unbind((Context)iniCtx, jndiName);
        }
        catch (NameNotFoundException e) {
            log.debug("Could not find client ENC");
        }
        catch (NamingException e) {
            log.error("Failed to remove client ENC", e);
        }
    }
}

