/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.io.IOException;
import org.jboss.deployers.plugins.deployers.helpers.ObjectModelFactoryDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.ejb3.metamodel.ApplicationClientDD;
import org.jboss.ejb3.metamodel.ApplicationClientDDObjectFactory;
import org.jboss.util.xml.DOMUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.binding.ObjectModelFactory;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClientParsingDeployer
extends ObjectModelFactoryDeployer<ApplicationClientDD> {
    private String appClientXmlPath = "application-client.xml";

    public AppClientParsingDeployer() {
        super(ApplicationClientDD.class);
    }

    protected ObjectModelFactory getObjectModelFactory(ApplicationClientDD root) {
        return new ApplicationClientDDObjectFactory();
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (this.accepts(unit)) {
            this.createMetaData(unit, this.appClientXmlPath, null);
        }
    }

    private boolean accepts(DeploymentUnit unit) throws DeploymentException {
        Element root;
        boolean accepts = false;
        VirtualFile dd = unit.getMetaDataFile(this.appClientXmlPath);
        if (dd != null) {
            this.log.debug("Found application-client.xml file: " + unit.getName());
            try {
                root = DOMUtils.parse(dd.openStream());
                String namespaceURI = root.getNamespaceURI();
                accepts = "http://java.sun.com/xml/ns/javaee".equals(namespaceURI);
                if (!accepts) {
                    this.log.debug("Ignore application-client.xml with namespace: " + namespaceURI);
                }
            }
            catch (IOException ex) {
                DeploymentException.rethrowAsDeploymentException((String)("Cannot parse " + this.appClientXmlPath), (Throwable)ex);
            }
        }
        if (accepts && (dd = unit.getMetaDataFile("jboss-client.xml")) != null) {
            this.log.debug("Found jboss-client.xml file: " + unit.getName());
            try {
                root = DOMUtils.parse(dd.openStream());
                DocumentType doctype = root.getOwnerDocument().getDoctype();
                String publicId = doctype != null ? doctype.getPublicId() : null;
                accepts = !"-//JBoss//DTD Application Client 4.0//EN".equals(publicId);
            }
            catch (IOException ex) {
                DeploymentException.rethrowAsDeploymentException((String)("Cannot parse " + this.appClientXmlPath), (Throwable)ex);
            }
        }
        return accepts;
    }
}

