/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.txtimer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCMappingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
import org.jboss.ejb.txtimer.DatabasePersistencePluginExt;
import org.jboss.ejb.txtimer.TimedObjectId;
import org.jboss.ejb.txtimer.TimerHandleImpl;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.logging.Logger;
import org.jboss.mx.util.ObjectNameFactory;

public class GeneralPurposeDatabasePersistencePlugin
implements DatabasePersistencePluginExt {
    private static Logger log = Logger.getLogger(GeneralPurposeDatabasePersistencePlugin.class);
    protected MBeanServer server;
    protected ObjectName dataSourceName;
    protected String tableName;
    protected DataSource ds;
    protected ObjectName metaDataName;
    private int binarySqlType;

    public void init(MBeanServer server, ObjectName dataSource, String tableName) throws SQLException {
        if (tableName == null) {
            throw new IllegalArgumentException("Timers tableName is null");
        }
        if (tableName.length() == 0) {
            throw new IllegalArgumentException("Timers tableName is empty");
        }
        this.tableName = tableName;
        this.init(server, dataSource);
    }

    public void init(MBeanServer server, ObjectName dataSourceName) throws SQLException {
        this.server = server;
        this.dataSourceName = dataSourceName;
        try {
            String dsJndiTx = (String)server.getAttribute(dataSourceName, "BindName");
            this.ds = (DataSource)new InitialContext().lookup(dsJndiTx);
        }
        catch (Exception e) {
            throw new SQLException("Failed to lookup data source: " + dataSourceName);
        }
        String dsName = dataSourceName.getKeyProperty("name");
        this.metaDataName = ObjectNameFactory.create("jboss.jdbc:datasource=" + dsName + ",service=metadata");
        if (!this.server.isRegistered(this.metaDataName)) {
            throw new IllegalStateException("Cannot find datasource meta data: " + this.metaDataName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createTableIfNotExists() throws SQLException {
        Connection con = null;
        Statement st = null;
        try {
            JDBCTypeMappingMetaData typeMapping = (JDBCTypeMappingMetaData)this.server.getAttribute(this.metaDataName, "TypeMappingMetaData");
            if (typeMapping == null) {
                throw new IllegalStateException("Cannot obtain type mapping from: " + this.metaDataName);
            }
            JDBCMappingMetaData objectMetaData = typeMapping.getTypeMappingMetaData(Object.class);
            this.binarySqlType = objectMetaData.getJdbcType();
            if (!SQLUtil.tableExists(this.getTableName(), this.ds)) {
                con = this.ds.getConnection();
                String dateType = typeMapping.getTypeMappingMetaData(Timestamp.class).getSqlType();
                String longType = typeMapping.getTypeMappingMetaData(Long.class).getSqlType();
                String objectType = objectMetaData.getSqlType();
                StringBuffer createTableDDL = new StringBuffer("create table " + this.getTableName() + " (" + " " + this.getColumnTimerID() + " varchar(80) not null," + " " + this.getColumnTargetID() + " varchar(250) not null," + " " + this.getColumnInitialDate() + " " + dateType + " not null," + " " + this.getColumnTimerInterval() + " " + longType + "," + " " + this.getColumnInstancePK() + " " + objectType + "," + " " + this.getColumnInfo() + " " + objectType + ", ");
                JDBCFunctionMappingMetaData pkConstraint = typeMapping.getPkConstraintTemplate();
                Object[] templateParams = new String[]{this.getTableName() + "_PK", this.getColumnTimerID() + ", " + this.getColumnTargetID()};
                pkConstraint.getFunctionSql(templateParams, createTableDDL);
                createTableDDL.append(" )");
                log.debug("Executing DDL: " + createTableDDL);
                st = con.createStatement();
                st.executeUpdate(createTableDDL.toString());
            }
            JDBCUtil.safeClose(st);
        }
        catch (SQLException e) {
            throw e;
            catch (Exception e2) {
                log.error("Cannot create timer table", e2);
                return;
            }
        }
        JDBCUtil.safeClose(con);
        return;
        finally {
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTimer(String timerId, TimedObjectId timedObjectId, Date initialExpiration, long intervalDuration, Serializable info) throws SQLException {
        Connection con = null;
        PreparedStatement st = null;
        try {
            con = this.ds.getConnection();
            String sql = "insert into " + this.getTableName() + " " + "(" + this.getColumnTimerID() + "," + this.getColumnTargetID() + "," + this.getColumnInitialDate() + "," + this.getColumnTimerInterval() + "," + this.getColumnInstancePK() + "," + this.getColumnInfo() + ") " + "values (?,?,?,?,?,?)";
            st = con.prepareStatement(sql);
            st.setString(1, timerId);
            st.setString(2, timedObjectId.toString());
            st.setTimestamp(3, new Timestamp(initialExpiration.getTime()));
            st.setLong(4, intervalDuration);
            byte[] bytes = this.serialize(timedObjectId.getInstancePk());
            if (bytes == null) {
                st.setNull(5, this.binarySqlType);
            } else {
                st.setBytes(5, bytes);
            }
            bytes = this.serialize(info);
            if (bytes == null) {
                st.setNull(6, this.binarySqlType);
            } else {
                st.setBytes(6, bytes);
            }
            int rows = st.executeUpdate();
            if (rows != 1) {
                log.error("Unable to insert timer for: " + timedObjectId);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List selectTimers(ObjectName containerId) throws SQLException {
        ArrayList<TimerHandleImpl> arrayList;
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = this.ds.getConnection();
            ArrayList<TimerHandleImpl> list2 = new ArrayList<TimerHandleImpl>();
            st = con.createStatement();
            rs = st.executeQuery("select * from " + this.getTableName());
            while (rs.next()) {
                String timerId = rs.getString(this.getColumnTimerID());
                TimedObjectId targetId = TimedObjectId.parse(rs.getString(this.getColumnTargetID()));
                if (containerId != null && !containerId.equals(targetId.getContainerId())) continue;
                Timestamp initialDate = rs.getTimestamp(this.getColumnInitialDate());
                long interval = rs.getLong(this.getColumnTimerInterval());
                Serializable pKey = (Serializable)this.deserialize(rs.getBytes(this.getColumnInstancePK()));
                Serializable info = null;
                try {
                    info = (Serializable)this.deserialize(rs.getBytes(this.getColumnInfo()));
                }
                catch (Exception e) {
                    log.warn("Cannot deserialize custom info object", e);
                }
                targetId = new TimedObjectId(targetId.getContainerId(), pKey);
                TimerHandleImpl handle = new TimerHandleImpl(timerId, targetId, initialDate, interval, info);
                list2.add(handle);
            }
            arrayList = list2;
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTimer(String timerId, TimedObjectId timedObjectId) throws SQLException {
        Connection con = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            con = this.ds.getConnection();
            String sql = "delete from " + this.getTableName() + " where " + this.getColumnTimerID() + "=? and " + this.getColumnTargetID() + "=?";
            st = con.prepareStatement(sql);
            st.setString(1, timerId);
            st.setString(2, timedObjectId.toString());
            int rows = st.executeUpdate();
            if (rows != 1) {
                log.debug("Unable to remove timer for: " + timerId);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTimers() throws SQLException {
        Connection con = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            con = this.ds.getConnection();
            st = con.prepareStatement("delete from " + this.getTableName());
            st.executeUpdate();
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnTimerID() {
        return "TIMERID";
    }

    public String getColumnTargetID() {
        return "TARGETID";
    }

    public String getColumnInitialDate() {
        return "INITIALDATE";
    }

    public String getColumnTimerInterval() {
        return "TIMERINTERVAL";
    }

    public String getColumnInstancePK() {
        return "INSTANCEPK";
    }

    public String getColumnInfo() {
        return "INFO";
    }

    protected byte[] serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
        }
        catch (IOException e) {
            log.error("Cannot serialize: " + obj, e);
        }
        return baos.toByteArray();
    }

    protected Object deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            MarshalledValueInputStream oos = new MarshalledValueInputStream(bais);
            return oos.readObject();
        }
        catch (Exception e) {
            log.error("Cannot deserialize", e);
            return null;
        }
    }

    protected Object deserialize(InputStream input) {
        if (input == null) {
            return null;
        }
        byte[] barr = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try {
            int b = 0;
            while ((b = input.read(barr)) > 0) {
                baos.write(barr, 0, b);
            }
            return this.deserialize(baos.toByteArray());
        }
        catch (Exception e) {
            log.error("Cannot deserialize", e);
            return null;
        }
    }
}

